/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.servlet.osgi;

import java.util.Dictionary;
import java.util.Hashtable;
import javax.servlet.Servlet;
import javax.servlet.http.HttpServlet;
import org.osgi.service.http.HttpContext;
import org.osgi.service.http.HttpService;

public class OsgiServletRegisterer {
    private String alias;
    private String servletName;
    private HttpServlet servlet;
    private HttpService httpService;
    private HttpContext httpContext;
    private boolean alreadyRegistered;

    public void setHttpService(HttpService httpService) {
        this.httpService = httpService;
    }

    public void setAlias(String alias) {
        this.alias = alias;
    }

    public void setServletName(String servletName) {
        this.servletName = servletName;
    }

    public void setServlet(HttpServlet servlet) {
        this.servlet = servlet;
    }

    public void setHttpContext(HttpContext httpContext) {
        this.httpContext = httpContext;
    }

    public void register() throws Exception {
        HttpContext actualHttpContext = this.httpContext == null ? this.httpService.createDefaultHttpContext() : this.httpContext;
        Hashtable<String, String> initParams = new Hashtable<String, String>();
        ((Dictionary)initParams).put("matchOnUriPrefix", "true");
        ((Dictionary)initParams).put("servlet-name", this.servletName);
        this.httpService.registerServlet(this.alias, (Servlet)this.servlet, initParams, actualHttpContext);
        this.alreadyRegistered = true;
    }

    public void unregister() {
        if (this.alreadyRegistered) {
            this.httpService.unregister(this.alias);
            this.alreadyRegistered = false;
        }
    }
}

