/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.dataformat.soap.name;

import javax.xml.bind.annotation.XmlSchema;
import javax.xml.bind.annotation.XmlType;
import javax.xml.namespace.QName;
import org.apache.camel.dataformat.soap.name.ElementNameStrategy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TypeNameStrategy
implements ElementNameStrategy {
    @Override
    public QName findQNameForSoapActionOrType(String soapAction, Class<?> type) {
        XmlSchema xmlSchema;
        XmlType xmlType = type.getAnnotation(XmlType.class);
        if (xmlType == null || xmlType.name() == null) {
            throw new RuntimeException("The type " + type.getName() + " needs to have an XmlType annotation with name");
        }
        String nameSpace = xmlType.namespace();
        if ("##default".equals(nameSpace) && (xmlSchema = type.getPackage().getAnnotation(XmlSchema.class)) != null) {
            nameSpace = xmlSchema.namespace();
        }
        return new QName(nameSpace, xmlType.name());
    }

    @Override
    public Class<? extends Exception> findExceptionForFaultName(QName faultName) {
        throw new UnsupportedOperationException("Exception lookup is not supported for TypeNameStrategy");
    }
}

