/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.dataformat.soap;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import javax.jws.WebMethod;
import javax.jws.WebParam;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.JAXBIntrospector;
import javax.xml.namespace.QName;
import javax.xml.ws.Holder;
import javax.xml.ws.WebFault;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.component.bean.BeanInvocation;
import org.apache.camel.converter.jaxb.JaxbDataFormat;
import org.apache.camel.dataformat.soap.name.ElementNameStrategy;
import org.apache.camel.dataformat.soap.name.ServiceInterfaceStrategy;
import org.apache.camel.dataformat.soap.name.TypeNameStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xmlsoap.schemas.soap.envelope.Body;
import org.xmlsoap.schemas.soap.envelope.Detail;
import org.xmlsoap.schemas.soap.envelope.Envelope;
import org.xmlsoap.schemas.soap.envelope.Fault;
import org.xmlsoap.schemas.soap.envelope.Header;
import org.xmlsoap.schemas.soap.envelope.ObjectFactory;

public class SoapJaxbDataFormat
extends JaxbDataFormat {
    public static final String SOAP_UNMARSHALLED_HEADER_LIST = "org.apache.camel.dataformat.soap.UNMARSHALLED_HEADER_LIST";
    private static final String SOAP_PACKAGE_NAME = Envelope.class.getPackage().getName();
    private static final QName FAULT_CODE_SERVER = new QName("http://www.w3.org/2003/05/soap-envelope", "Receiver");
    protected final transient Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private ElementNameStrategy elementNameStrategy;
    private String elementNameStrategyRef;
    private boolean ignoreUnmarshalledHeaders;

    public SoapJaxbDataFormat() {
    }

    public SoapJaxbDataFormat(String contextPath) {
        super(contextPath);
    }

    public SoapJaxbDataFormat(String contextPath, ElementNameStrategy elementNameStrategy) {
        this(contextPath);
        this.elementNameStrategy = elementNameStrategy;
    }

    public SoapJaxbDataFormat(String contextPath, String elementNameStrategyRef) {
        this(contextPath);
        this.elementNameStrategyRef = elementNameStrategyRef;
    }

    public void setElementNameStrategy(Object nameStrategy) {
        if (!(nameStrategy instanceof ElementNameStrategy)) {
            throw new IllegalArgumentException("The argument for setElementNameStrategy should be subClass of " + ElementNameStrategy.class.getName());
        }
        this.elementNameStrategy = (ElementNameStrategy)nameStrategy;
    }

    public void setIgnoreUnmarshalledHeaders(boolean ignoreHeaders) {
        this.ignoreUnmarshalledHeaders = ignoreHeaders;
    }

    private boolean isIgnoreUnmarshalledHeaders() {
        return this.ignoreUnmarshalledHeaders;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void checkElementNameStrategy(Exchange exchange) {
        if (this.elementNameStrategy == null) {
            SoapJaxbDataFormat soapJaxbDataFormat = this;
            synchronized (soapJaxbDataFormat) {
                if (this.elementNameStrategy != null) {
                    return;
                }
                this.elementNameStrategy = this.elementNameStrategyRef != null ? (ElementNameStrategy)exchange.getContext().getRegistry().lookup(this.elementNameStrategyRef, ElementNameStrategy.class) : new TypeNameStrategy();
            }
        }
    }

    public void marshal(Exchange exchange, Object inputObject, OutputStream stream) throws IOException {
        List<Object> bodyContent;
        BeanInvocation beanInvocation;
        WebMethod webMethod;
        this.checkElementNameStrategy(exchange);
        String soapAction = this.getSoapActionFromExchange(exchange);
        if (soapAction == null && inputObject instanceof BeanInvocation && (webMethod = (beanInvocation = (BeanInvocation)inputObject).getMethod().getAnnotation(WebMethod.class)) != null && webMethod.action() != null) {
            soapAction = webMethod.action();
        }
        Body body = new Body();
        Header header = new Header();
        Throwable exception = (Throwable)exchange.getProperty("CamelExceptionCaught", Throwable.class);
        if (exception == null) {
            exception = (Throwable)exchange.getIn().getHeader("CamelExceptionCaught", Throwable.class);
        }
        ArrayList headerContent = new ArrayList();
        if (exception != null) {
            bodyContent = new ArrayList<JAXBElement<Fault>>();
            bodyContent.add(this.createFaultFromException(exception));
        } else {
            bodyContent = this.createContentFromObject(inputObject, soapAction, headerContent);
        }
        for (JAXBElement jAXBElement : bodyContent) {
            body.getAny().add(jAXBElement);
        }
        for (JAXBElement jAXBElement : headerContent) {
            header.getAny().add(jAXBElement);
        }
        Envelope envelope = new Envelope();
        if (headerContent.size() > 0) {
            envelope.setHeader(header);
        }
        envelope.setBody(body);
        JAXBElement<Envelope> jAXBElement = new ObjectFactory().createEnvelope(envelope);
        super.marshal(exchange, jAXBElement, stream);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private List<JAXBElement<?>> createContentFromObject(Object inputObject, String soapAction, List<JAXBElement<?>> headerElements) {
        ArrayList<Object> bodyParts = new ArrayList<Object>();
        ArrayList<Object> headerParts = new ArrayList<Object>();
        if (inputObject instanceof BeanInvocation) {
            BeanInvocation bi = (BeanInvocation)inputObject;
            Annotation[][] annotations = bi.getMethod().getParameterAnnotations();
            ArrayList<WebParam> arrayList = new ArrayList<WebParam>();
            for (int i = 0; i < annotations.length; ++i) {
                Annotation[] singleParameterAnnotations = annotations[i];
                for (int j = 0; j < singleParameterAnnotations.length; ++j) {
                    Annotation annotation = singleParameterAnnotations[j];
                    if (!(annotation instanceof WebParam)) continue;
                    arrayList.add((WebParam)annotation);
                }
            }
            if (arrayList.size() > 0) {
                if (arrayList.size() != bi.getArgs().length) throw new RuntimeCamelException("The number of bean invocation parameters does not match the number of parameters annotated with @WebParam for the method [ " + bi.getMethod().getName() + "].");
                int index = -1;
                for (Object o : bi.getArgs()) {
                    if (((WebParam)arrayList.get(++index)).header()) {
                        headerParts.add(o);
                        continue;
                    }
                    bodyParts.add(o);
                }
            } else {
                for (Object o : bi.getArgs()) {
                    bodyParts.add(o);
                }
            }
        } else {
            bodyParts.add(inputObject);
        }
        ArrayList bodyElements = new ArrayList();
        for (Object e : bodyParts) {
            QName name = this.elementNameStrategy.findQNameForSoapActionOrType(soapAction, e.getClass());
            if (name == null) {
                this.log.warn("Could not find QName for class " + e.getClass().getName());
                continue;
            }
            bodyElements.add(this.getElement(e, name));
        }
        for (Object e : headerParts) {
            QName name = this.elementNameStrategy.findQNameForSoapActionOrType(soapAction, e.getClass());
            if (name == null) {
                this.log.warn("Could not find QName for class " + e.getClass().getName());
                continue;
            }
            JAXBElement<?> headerElem = this.getElement(e, name);
            if (null == headerElem) continue;
            headerElements.add(headerElem);
        }
        return bodyElements;
    }

    private JAXBElement<?> getElement(Object fromObj, QName name) {
        Object value = null;
        if (fromObj instanceof Holder) {
            Holder holder = (Holder)fromObj;
            value = holder.value;
            if (null == value) {
                return null;
            }
        } else {
            value = fromObj;
        }
        return new JAXBElement(name, value.getClass(), value);
    }

    private JAXBElement<Fault> createFaultFromException(Throwable exception) {
        WebFault webFault = exception.getClass().getAnnotation(WebFault.class);
        if (webFault == null || webFault.targetNamespace() == null) {
            throw new RuntimeException("The exception " + exception.getClass().getName() + " needs to have an WebFault annotation with name and targetNamespace", exception);
        }
        QName name = new QName(webFault.targetNamespace(), webFault.name());
        Object faultObject = null;
        try {
            Method method = exception.getClass().getMethod("getFaultInfo", new Class[0]);
            faultObject = method.invoke((Object)exception, new Object[0]);
        }
        catch (Exception e) {
            throw new RuntimeCamelException("Exception while trying to get fault details", (Throwable)e);
        }
        Fault fault = new Fault();
        fault.setFaultcode(FAULT_CODE_SERVER);
        fault.setFaultstring(exception.getMessage());
        Detail detailEl = new ObjectFactory().createDetail();
        JAXBElement faultDetailContent = new JAXBElement(name, faultObject.getClass(), faultObject);
        detailEl.getAny().add(faultDetailContent);
        fault.setDetail(detailEl);
        return new ObjectFactory().createFault(fault);
    }

    public Object unmarshal(Exchange exchange, InputStream stream) throws IOException {
        List<Object> anyElement;
        List<Object> anyHeaderElements;
        Object unmarshalledObject;
        Object rootObject;
        this.checkElementNameStrategy(exchange);
        String soapAction = this.getSoapActionFromExchange(exchange);
        if (soapAction != null && this.elementNameStrategy instanceof ServiceInterfaceStrategy) {
            ServiceInterfaceStrategy strategy = (ServiceInterfaceStrategy)this.elementNameStrategy;
            String methodName = strategy.getMethodForSoapAction(soapAction);
            exchange.getOut().setHeader("CamelBeanMethodName", (Object)methodName);
        }
        if (soapAction != null) {
            exchange.setProperty("CamelSoapAction", (Object)soapAction);
        }
        if ((rootObject = JAXBIntrospector.getValue((Object)(unmarshalledObject = super.unmarshal(exchange, stream)))).getClass() != Envelope.class) {
            throw new RuntimeCamelException("Expected Soap Envelope but got " + rootObject.getClass());
        }
        Envelope envelope = (Envelope)rootObject;
        Header header = envelope.getHeader();
        if (header != null && null != (anyHeaderElements = envelope.getHeader().getAny()) && !this.isIgnoreUnmarshalledHeaders()) {
            List<Object> returnHeaders;
            if (this.isIgnoreJAXBElement()) {
                returnHeaders = new ArrayList<Object>();
                for (Object headerEl : anyHeaderElements) {
                    returnHeaders.add(JAXBIntrospector.getValue((Object)headerEl));
                }
            } else {
                returnHeaders = anyHeaderElements;
            }
            exchange.getOut().setHeader(SOAP_UNMARSHALLED_HEADER_LIST, returnHeaders);
        }
        if ((anyElement = envelope.getBody().getAny()).size() == 0) {
            return null;
        }
        Object payloadEl = anyElement.get(0);
        Object payload = JAXBIntrospector.getValue((Object)payloadEl);
        if (payload instanceof Fault) {
            Exception exception = this.createExceptionFromFault((Fault)payload);
            exchange.setException((Throwable)exception);
            return null;
        }
        return this.isIgnoreJAXBElement() ? payload : payloadEl;
    }

    private String getSoapActionFromExchange(Exchange exchange) {
        Message inMessage = exchange.getIn();
        String soapAction = (String)inMessage.getHeader("CamelSoapAction", String.class);
        if (soapAction == null && (soapAction = (String)inMessage.getHeader("SOAPAction", String.class)) != null && soapAction.startsWith("\"")) {
            soapAction = soapAction.substring(1, soapAction.length() - 1);
        }
        if (soapAction == null) {
            soapAction = (String)exchange.getProperty("CamelSoapAction", String.class);
        }
        return soapAction;
    }

    private Exception createExceptionFromFault(Fault fault) {
        List<Object> detailList = fault.getDetail().getAny();
        String message = fault.getFaultstring();
        if (detailList.size() == 0) {
            return new RuntimeCamelException(message);
        }
        JAXBElement detailEl = (JAXBElement)detailList.get(0);
        Class<? extends Exception> exceptionClass = this.elementNameStrategy.findExceptionForFaultName(detailEl.getName());
        try {
            Constructor<? extends Exception> messageContructor = exceptionClass.getConstructor(String.class);
            Object detail = JAXBIntrospector.getValue((Object)detailEl);
            try {
                Constructor<? extends Exception> constructor = exceptionClass.getConstructor(String.class, detail.getClass());
                return constructor.newInstance(message, detail);
            }
            catch (NoSuchMethodException e) {
                return messageContructor.newInstance(message);
            }
        }
        catch (Exception e) {
            throw new RuntimeCamelException((Throwable)e);
        }
    }

    protected JAXBContext createContext() throws JAXBException {
        if (this.getContextPath() != null) {
            return JAXBContext.newInstance((String)(SOAP_PACKAGE_NAME + ":" + this.getContextPath()));
        }
        return JAXBContext.newInstance((Class[])new Class[0]);
    }

    public void setElementNameStrategy(ElementNameStrategy elementNameStrategy) {
        this.elementNameStrategy = elementNameStrategy;
    }

    public void setElementNameStrategyRef(String nameStrategyRef) {
        this.elementNameStrategyRef = nameStrategyRef;
    }
}

