/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.spring.batch;

import java.util.Map;
import org.apache.camel.CamelContext;
import org.apache.camel.Component;
import org.apache.camel.Endpoint;
import org.apache.camel.component.spring.batch.SpringBatchEndpoint;
import org.apache.camel.impl.DefaultComponent;
import org.apache.camel.util.CamelContextHelper;
import org.springframework.batch.core.Job;
import org.springframework.batch.core.launch.JobLauncher;

public class SpringBatchComponent
extends DefaultComponent {
    private static final String DEFAULT_JOB_LAUNCHER_REF_NAME = "jobLauncher";
    private JobLauncher jobLauncher;
    private JobLauncher defaultResolvedJobLauncher;
    private Map<String, JobLauncher> allResolvedJobLaunchers;

    protected Endpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
        Job resolvedJob = (Job)CamelContextHelper.mandatoryLookup((CamelContext)this.getCamelContext(), (String)remaining, Job.class);
        SpringBatchEndpoint endpoint = new SpringBatchEndpoint(uri, (Component)this, this.jobLauncher, this.defaultResolvedJobLauncher, this.allResolvedJobLaunchers, resolvedJob);
        this.setProperties((Object)endpoint, parameters);
        return endpoint;
    }

    protected void doStart() throws Exception {
        this.defaultResolvedJobLauncher = (JobLauncher)this.getCamelContext().getRegistry().lookupByNameAndType(DEFAULT_JOB_LAUNCHER_REF_NAME, JobLauncher.class);
        this.allResolvedJobLaunchers = this.getCamelContext().getRegistry().findByTypeWithName(JobLauncher.class);
    }

    public void setJobLauncher(JobLauncher jobLauncher) {
        this.jobLauncher = jobLauncher;
    }
}

