/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.spring.batch;

import java.util.Map;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Endpoint;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.component.spring.batch.SpringBatchProducer;
import org.apache.camel.impl.DefaultEndpoint;
import org.springframework.batch.core.Job;
import org.springframework.batch.core.launch.JobLauncher;

public class SpringBatchEndpoint
extends DefaultEndpoint {
    private String jobLauncherRef;
    private JobLauncher jobLauncher;
    private JobLauncher defaultResolvedJobLauncher;
    private Map<String, JobLauncher> allResolvedJobLaunchers;
    private final Job job;

    public SpringBatchEndpoint(String endpointUri, Component component, JobLauncher jobLauncher, JobLauncher defaultResolvedJobLauncher, Map<String, JobLauncher> allResolvedJobLaunchers, Job job) {
        super(endpointUri, component);
        this.jobLauncher = jobLauncher;
        this.defaultResolvedJobLauncher = defaultResolvedJobLauncher;
        this.allResolvedJobLaunchers = allResolvedJobLaunchers;
        this.job = job;
    }

    public Producer createProducer() throws Exception {
        return new SpringBatchProducer((Endpoint)this, this.jobLauncher, this.job);
    }

    public Consumer createConsumer(Processor processor) throws Exception {
        throw new UnsupportedOperationException("Not supported");
    }

    public boolean isSingleton() {
        return true;
    }

    protected void doStart() throws Exception {
        if (this.jobLauncher == null) {
            this.jobLauncher = this.resolveJobLauncher();
        }
    }

    private JobLauncher resolveJobLauncher() {
        if (this.jobLauncherRef != null) {
            JobLauncher jobLauncher = (JobLauncher)this.getCamelContext().getRegistry().lookupByNameAndType(this.jobLauncherRef, JobLauncher.class);
            if (jobLauncher == null) {
                throw new IllegalStateException(String.format("No JobLauncher named %s found in the registry.", this.jobLauncherRef));
            }
            return jobLauncher;
        }
        if (this.defaultResolvedJobLauncher != null) {
            return this.defaultResolvedJobLauncher;
        }
        if (this.allResolvedJobLaunchers.size() == 1) {
            return this.allResolvedJobLaunchers.values().iterator().next();
        }
        if (this.allResolvedJobLaunchers.size() > 1) {
            throw new IllegalStateException("Expected single jobLauncher instance. Found: " + this.allResolvedJobLaunchers.size());
        }
        throw new IllegalStateException("Cannot find Spring Batch JobLauncher.");
    }

    public void setJobLauncherRef(String jobLauncherRef) {
        this.jobLauncherRef = jobLauncherRef;
    }

    public void setJobLauncher(JobLauncher jobLauncher) {
        this.jobLauncher = jobLauncher;
    }
}

