/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.spring.batch;

import java.util.Date;
import java.util.Map;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.impl.DefaultProducer;
import org.springframework.batch.core.Job;
import org.springframework.batch.core.JobExecution;
import org.springframework.batch.core.JobParameters;
import org.springframework.batch.core.JobParametersBuilder;
import org.springframework.batch.core.launch.JobLauncher;

public class SpringBatchProducer
extends DefaultProducer {
    private final JobLauncher jobLauncher;
    private final Job job;

    public SpringBatchProducer(Endpoint endpoint, JobLauncher jobLauncher, Job job) {
        super(endpoint);
        this.job = job;
        this.jobLauncher = jobLauncher;
    }

    public void process(Exchange exchange) throws Exception {
        JobParameters jobParameters = this.prepareJobParameters(exchange.getIn().getHeaders());
        JobExecution jobExecution = this.jobLauncher.run(this.job, jobParameters);
        exchange.getOut().getHeaders().putAll(exchange.getIn().getHeaders());
        exchange.getOut().setBody((Object)jobExecution);
    }

    protected JobParameters prepareJobParameters(Map<String, Object> headers) {
        JobParametersBuilder parametersBuilder = new JobParametersBuilder();
        for (Map.Entry<String, Object> headerEntry : headers.entrySet()) {
            String headerKey = headerEntry.getKey();
            Object headerValue = headerEntry.getValue();
            if (headerValue instanceof Date) {
                parametersBuilder.addDate(headerKey, (Date)headerValue);
                continue;
            }
            if (headerValue instanceof Long) {
                parametersBuilder.addLong(headerKey, (Long)headerValue);
                continue;
            }
            if (headerValue instanceof Double) {
                parametersBuilder.addDouble(headerKey, (Double)headerValue);
                continue;
            }
            if (headerValue != null) {
                parametersBuilder.addString(headerKey, headerValue.toString());
                continue;
            }
            parametersBuilder.addString(headerKey, null);
        }
        return parametersBuilder.toJobParameters();
    }
}

