/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.spring.boot;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import org.apache.camel.CamelContext;
import org.apache.camel.ConsumerTemplate;
import org.apache.camel.FluentProducerTemplate;
import org.apache.camel.ProducerTemplate;
import org.apache.camel.TypeConverters;
import org.apache.camel.component.properties.PropertiesComponent;
import org.apache.camel.component.properties.PropertiesParser;
import org.apache.camel.ha.CamelClusterService;
import org.apache.camel.impl.FileWatcherReloadStrategy;
import org.apache.camel.processor.interceptor.BacklogTracer;
import org.apache.camel.processor.interceptor.DefaultTraceFormatter;
import org.apache.camel.processor.interceptor.HandleFault;
import org.apache.camel.processor.interceptor.TraceFormatter;
import org.apache.camel.processor.interceptor.Tracer;
import org.apache.camel.spi.AsyncProcessorAwaitManager;
import org.apache.camel.spi.EndpointStrategy;
import org.apache.camel.spi.EventFactory;
import org.apache.camel.spi.EventNotifier;
import org.apache.camel.spi.InflightRepository;
import org.apache.camel.spi.InterceptStrategy;
import org.apache.camel.spi.LifecycleStrategy;
import org.apache.camel.spi.ManagementNamingStrategy;
import org.apache.camel.spi.ManagementStrategy;
import org.apache.camel.spi.PackageScanClassResolver;
import org.apache.camel.spi.ReloadStrategy;
import org.apache.camel.spi.RouteController;
import org.apache.camel.spi.RoutePolicyFactory;
import org.apache.camel.spi.RuntimeEndpointRegistry;
import org.apache.camel.spi.ShutdownStrategy;
import org.apache.camel.spi.StreamCachingStrategy;
import org.apache.camel.spi.ThreadPoolProfile;
import org.apache.camel.spi.UnitOfWorkFactory;
import org.apache.camel.spring.CamelBeanPostProcessor;
import org.apache.camel.spring.SpringCamelContext;
import org.apache.camel.spring.boot.CamelConfigurationProperties;
import org.apache.camel.spring.boot.CamelContextConfiguration;
import org.apache.camel.spring.boot.CamelSpringBootApplicationController;
import org.apache.camel.spring.boot.FatJarPackageScanClassResolver;
import org.apache.camel.spring.boot.FilePropertySource;
import org.apache.camel.spring.boot.RoutesCollector;
import org.apache.camel.spring.boot.SpringBootXmlCamelContextConfigurer;
import org.apache.camel.spring.boot.SpringPropertiesParser;
import org.apache.camel.spring.boot.TypeConversionConfiguration;
import org.apache.camel.spring.spi.XmlCamelContextConfigurer;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.jsse.GlobalSSLContextParametersSupplier;
import org.apache.camel.util.jsse.SSLContextParameters;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.context.annotation.Lazy;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.Environment;
import org.springframework.core.env.MutablePropertySources;
import org.springframework.core.env.PropertySource;

@Configuration
@EnableConfigurationProperties(value={CamelConfigurationProperties.class})
@Import(value={TypeConversionConfiguration.class})
public class CamelAutoConfiguration {
    private static final Logger LOG = LoggerFactory.getLogger(CamelAutoConfiguration.class);

    @Bean(name={"xmlCamelContextConfigurer"})
    XmlCamelContextConfigurer springBootCamelContextConfigurer() {
        return new SpringBootXmlCamelContextConfigurer();
    }

    @Bean(destroyMethod="")
    @ConditionalOnMissingBean(value={CamelContext.class})
    CamelContext camelContext(ApplicationContext applicationContext, CamelConfigurationProperties config) throws Exception {
        SpringCamelContext camelContext = new SpringCamelContext(applicationContext);
        return CamelAutoConfiguration.doConfigureCamelContext(applicationContext, (CamelContext)camelContext, config);
    }

    static CamelContext doConfigureCamelContext(ApplicationContext applicationContext, CamelContext camelContext, CamelConfigurationProperties config) throws Exception {
        Tracer tracer;
        MutablePropertySources sources;
        Environment env;
        if (ObjectHelper.isNotEmpty((Object)config.getFileConfigurations()) && (env = applicationContext.getEnvironment()) instanceof ConfigurableEnvironment && (sources = ((ConfigurableEnvironment)env).getPropertySources()) != null && !sources.contains("camel-file-configuration")) {
            sources.addFirst((PropertySource)new FilePropertySource("camel-file-configuration", applicationContext, config.getFileConfigurations()));
        }
        if (!config.isJmxEnabled()) {
            camelContext.disableJMX();
        }
        if (config.getName() != null) {
            ((SpringCamelContext)camelContext).setName(config.getName());
        }
        if (config.getShutdownTimeout() > 0) {
            camelContext.getShutdownStrategy().setTimeout((long)config.getShutdownTimeout());
        }
        camelContext.getShutdownStrategy().setSuppressLoggingOnTimeout(config.isShutdownSuppressLoggingOnTimeout());
        camelContext.getShutdownStrategy().setShutdownNowOnTimeout(config.isShutdownNowOnTimeout());
        camelContext.getShutdownStrategy().setShutdownRoutesInReverseOrder(config.isShutdownRoutesInReverseOrder());
        camelContext.getShutdownStrategy().setLogInflightExchangesOnTimeout(config.isShutdownLogInflightExchangesOnTimeout());
        if (config.getLogDebugMaxChars() > 0) {
            camelContext.getGlobalOptions().put("CamelLogDebugBodyMaxChars", "" + config.getLogDebugMaxChars());
        }
        camelContext.setStreamCaching(Boolean.valueOf(config.isStreamCachingEnabled()));
        camelContext.getStreamCachingStrategy().setAnySpoolRules(config.isStreamCachingAnySpoolRules());
        camelContext.getStreamCachingStrategy().setBufferSize(config.getStreamCachingBufferSize());
        camelContext.getStreamCachingStrategy().setRemoveSpoolDirectoryWhenStopping(config.isStreamCachingRemoveSpoolDirectoryWhenStopping());
        camelContext.getStreamCachingStrategy().setSpoolChiper(config.getStreamCachingSpoolChiper());
        if (config.getStreamCachingSpoolDirectory() != null) {
            camelContext.getStreamCachingStrategy().setSpoolDirectory(config.getStreamCachingSpoolDirectory());
        }
        if (config.getStreamCachingSpoolThreshold() != 0L) {
            camelContext.getStreamCachingStrategy().setSpoolThreshold(config.getStreamCachingSpoolThreshold());
        }
        if (config.getStreamCachingSpoolUsedHeapMemoryLimit() != null) {
            StreamCachingStrategy.SpoolUsedHeapMemoryLimit limit;
            if ("Committed".equalsIgnoreCase(config.getStreamCachingSpoolUsedHeapMemoryLimit())) {
                limit = StreamCachingStrategy.SpoolUsedHeapMemoryLimit.Committed;
            } else if ("Max".equalsIgnoreCase(config.getStreamCachingSpoolUsedHeapMemoryLimit())) {
                limit = StreamCachingStrategy.SpoolUsedHeapMemoryLimit.Max;
            } else {
                throw new IllegalArgumentException("Invalid option " + config.getStreamCachingSpoolUsedHeapMemoryLimit() + " must either be Committed or Max");
            }
            camelContext.getStreamCachingStrategy().setSpoolUsedHeapMemoryLimit(limit);
        }
        if (config.getStreamCachingSpoolUsedHeapMemoryThreshold() != 0) {
            camelContext.getStreamCachingStrategy().setSpoolUsedHeapMemoryThreshold(config.getStreamCachingSpoolUsedHeapMemoryThreshold());
        }
        camelContext.setMessageHistory(Boolean.valueOf(config.isMessageHistory()));
        camelContext.setLogMask(Boolean.valueOf(config.isLogMask()));
        camelContext.setLogExhaustedMessageBody(Boolean.valueOf(config.isLogExhaustedMessageBody()));
        camelContext.setHandleFault(Boolean.valueOf(config.isHandleFault()));
        camelContext.setAutoStartup(Boolean.valueOf(config.isAutoStartup()));
        camelContext.setAllowUseOriginalMessage(Boolean.valueOf(config.isAllowUseOriginalMessage()));
        camelContext.setUseBreadcrumb(Boolean.valueOf(config.isUseBreadcrumb()));
        camelContext.setUseDataType(Boolean.valueOf(config.isUseDataType()));
        camelContext.setUseMDCLogging(Boolean.valueOf(config.isUseMDCLogging()));
        camelContext.setLoadTypeConverters(Boolean.valueOf(config.isLoadTypeConverters()));
        if (camelContext.getManagementStrategy().getManagementAgent() != null) {
            camelContext.getManagementStrategy().getManagementAgent().setEndpointRuntimeStatisticsEnabled(Boolean.valueOf(config.isEndpointRuntimeStatisticsEnabled()));
            camelContext.getManagementStrategy().getManagementAgent().setStatisticsLevel(config.getJmxManagementStatisticsLevel());
            camelContext.getManagementStrategy().getManagementAgent().setManagementNamePattern(config.getJmxManagementNamePattern());
            camelContext.getManagementStrategy().getManagementAgent().setCreateConnector(Boolean.valueOf(config.isJmxCreateConnector()));
        }
        camelContext.setPackageScanClassResolver((PackageScanClassResolver)new FatJarPackageScanClassResolver());
        camelContext.setTracing(Boolean.valueOf(config.isTracing()));
        if (camelContext.getDefaultTracer() instanceof Tracer && (tracer = (Tracer)camelContext.getDefaultTracer()).getDefaultTraceFormatter() != null) {
            DefaultTraceFormatter formatter = tracer.getDefaultTraceFormatter();
            if (config.getTracerFormatterBreadCrumbLength() != null) {
                formatter.setBreadCrumbLength(config.getTracerFormatterBreadCrumbLength().intValue());
            }
            if (config.getTracerFormatterMaxChars() != null) {
                formatter.setMaxChars(config.getTracerFormatterMaxChars().intValue());
            }
            if (config.getTracerFormatterNodeLength() != null) {
                formatter.setNodeLength(config.getTracerFormatterNodeLength().intValue());
            }
            formatter.setShowBody(config.isTraceFormatterShowBody());
            formatter.setShowBodyType(config.isTracerFormatterShowBodyType());
            formatter.setShowBreadCrumb(config.isTraceFormatterShowBreadCrumb());
            formatter.setShowException(config.isTraceFormatterShowException());
            formatter.setShowExchangeId(config.isTraceFormatterShowExchangeId());
            formatter.setShowExchangePattern(config.isTraceFormatterShowExchangePattern());
            formatter.setShowHeaders(config.isTraceFormatterShowHeaders());
            formatter.setShowNode(config.isTraceFormatterShowNode());
            formatter.setShowProperties(config.isTraceFormatterShowProperties());
            formatter.setShowRouteId(config.isTraceFormatterShowRouteId());
            formatter.setShowShortExchangeId(config.isTraceFormatterShowShortExchangeId());
        }
        if (config.getXmlRoutesReloadDirectory() != null) {
            FileWatcherReloadStrategy reload = new FileWatcherReloadStrategy(config.getXmlRoutesReloadDirectory());
            camelContext.setReloadStrategy((ReloadStrategy)reload);
        }
        CamelAutoConfiguration.afterPropertiesSet(applicationContext, camelContext);
        return camelContext;
    }

    @Bean
    CamelSpringBootApplicationController applicationController(ApplicationContext applicationContext, CamelContext camelContext) {
        return new CamelSpringBootApplicationController(applicationContext, camelContext);
    }

    @Bean
    @ConditionalOnMissingBean(value={RoutesCollector.class})
    RoutesCollector routesCollector(ApplicationContext applicationContext, CamelConfigurationProperties config) {
        Collection configurations = applicationContext.getBeansOfType(CamelContextConfiguration.class).values();
        return new RoutesCollector(applicationContext, new ArrayList<CamelContextConfiguration>(configurations), config);
    }

    @Bean(destroyMethod="")
    @ConditionalOnMissingBean(value={FluentProducerTemplate.class})
    @Lazy
    FluentProducerTemplate fluentProducerTemplate(CamelContext camelContext, CamelConfigurationProperties config) throws Exception {
        FluentProducerTemplate fluentProducerTemplate = camelContext.createFluentProducerTemplate(config.getProducerTemplateCacheSize());
        camelContext.addService((Object)fluentProducerTemplate);
        return fluentProducerTemplate;
    }

    @Bean(destroyMethod="")
    @ConditionalOnMissingBean(value={ProducerTemplate.class})
    @Lazy
    ProducerTemplate producerTemplate(CamelContext camelContext, CamelConfigurationProperties config) throws Exception {
        ProducerTemplate producerTemplate = camelContext.createProducerTemplate(config.getProducerTemplateCacheSize());
        camelContext.addService((Object)producerTemplate);
        return producerTemplate;
    }

    @Bean(destroyMethod="")
    @ConditionalOnMissingBean(value={ConsumerTemplate.class})
    @Lazy
    ConsumerTemplate consumerTemplate(CamelContext camelContext, CamelConfigurationProperties config) throws Exception {
        ConsumerTemplate consumerTemplate = camelContext.createConsumerTemplate(config.getConsumerTemplateCacheSize());
        camelContext.addService((Object)consumerTemplate);
        return consumerTemplate;
    }

    @Bean
    PropertiesParser propertiesParser() {
        return new SpringPropertiesParser();
    }

    @Bean(destroyMethod="")
    PropertiesComponent properties(CamelContext camelContext, PropertiesParser parser) {
        if (camelContext.hasComponent("properties") != null) {
            return (PropertiesComponent)camelContext.getComponent("properties", PropertiesComponent.class);
        }
        PropertiesComponent pc = new PropertiesComponent();
        pc.setPropertiesParser(parser);
        return pc;
    }

    @Bean
    CamelBeanPostProcessor camelBeanPostProcessor(ApplicationContext applicationContext) {
        CamelBeanPostProcessor processor = new CamelBeanPostProcessor();
        processor.setApplicationContext(applicationContext);
        return processor;
    }

    static void afterPropertiesSet(ApplicationContext applicationContext, CamelContext camelContext) throws Exception {
        RouteController routeController;
        GlobalSSLContextParametersSupplier sslContextParametersSupplier;
        Map map;
        CamelClusterService camelClusterService;
        Map lifecycleStrategies;
        Map map2;
        ShutdownStrategy shutdownStrategy;
        Map map3;
        Map eventNotifiers;
        Map typeConverters;
        RuntimeEndpointRegistry runtimeEndpointRegistry;
        UnitOfWorkFactory unitOfWorkFactory;
        EventFactory eventFactory;
        ManagementNamingStrategy managementNamingStrategy;
        ManagementStrategy managementStrategy;
        AsyncProcessorAwaitManager asyncProcessorAwaitManager;
        InflightRepository inflightRepository;
        HandleFault handleFault;
        BacklogTracer backlogTracer;
        Tracer tracer = CamelAutoConfiguration.getSingleBeanOfType(applicationContext, Tracer.class);
        if (tracer != null) {
            TraceFormatter formatter = CamelAutoConfiguration.getSingleBeanOfType(applicationContext, TraceFormatter.class);
            if (formatter != null) {
                tracer.setFormatter(formatter);
            }
            LOG.info("Using custom Tracer: {}", (Object)tracer);
            camelContext.addInterceptStrategy((InterceptStrategy)tracer);
        }
        if ((backlogTracer = CamelAutoConfiguration.getSingleBeanOfType(applicationContext, BacklogTracer.class)) != null) {
            LOG.info("Using custom BacklogTracer: {}", (Object)backlogTracer);
            camelContext.addInterceptStrategy((InterceptStrategy)backlogTracer);
        }
        if ((handleFault = CamelAutoConfiguration.getSingleBeanOfType(applicationContext, HandleFault.class)) != null) {
            LOG.info("Using custom HandleFault: {}", (Object)handleFault);
            camelContext.addInterceptStrategy((InterceptStrategy)handleFault);
        }
        if ((inflightRepository = CamelAutoConfiguration.getSingleBeanOfType(applicationContext, InflightRepository.class)) != null) {
            LOG.info("Using custom InflightRepository: {}", (Object)inflightRepository);
            camelContext.setInflightRepository(inflightRepository);
        }
        if ((asyncProcessorAwaitManager = CamelAutoConfiguration.getSingleBeanOfType(applicationContext, AsyncProcessorAwaitManager.class)) != null) {
            LOG.info("Using custom AsyncProcessorAwaitManager: {}", (Object)asyncProcessorAwaitManager);
            camelContext.setAsyncProcessorAwaitManager(asyncProcessorAwaitManager);
        }
        if ((managementStrategy = CamelAutoConfiguration.getSingleBeanOfType(applicationContext, ManagementStrategy.class)) != null) {
            LOG.info("Using custom ManagementStrategy: {}", (Object)managementStrategy);
            camelContext.setManagementStrategy(managementStrategy);
        }
        if ((managementNamingStrategy = CamelAutoConfiguration.getSingleBeanOfType(applicationContext, ManagementNamingStrategy.class)) != null) {
            LOG.info("Using custom ManagementNamingStrategy: {}", (Object)managementNamingStrategy);
            camelContext.getManagementStrategy().setManagementNamingStrategy(managementNamingStrategy);
        }
        if ((eventFactory = CamelAutoConfiguration.getSingleBeanOfType(applicationContext, EventFactory.class)) != null) {
            LOG.info("Using custom EventFactory: {}", (Object)eventFactory);
            camelContext.getManagementStrategy().setEventFactory(eventFactory);
        }
        if ((unitOfWorkFactory = CamelAutoConfiguration.getSingleBeanOfType(applicationContext, UnitOfWorkFactory.class)) != null) {
            LOG.info("Using custom UnitOfWorkFactory: {}", (Object)unitOfWorkFactory);
            camelContext.setUnitOfWorkFactory(unitOfWorkFactory);
        }
        if ((runtimeEndpointRegistry = CamelAutoConfiguration.getSingleBeanOfType(applicationContext, RuntimeEndpointRegistry.class)) != null) {
            LOG.info("Using custom RuntimeEndpointRegistry: {}", (Object)runtimeEndpointRegistry);
            camelContext.setRuntimeEndpointRegistry(runtimeEndpointRegistry);
        }
        if ((typeConverters = applicationContext.getBeansOfType(TypeConverters.class)) != null && !typeConverters.isEmpty()) {
            for (Map.Entry entry : typeConverters.entrySet()) {
                TypeConverters typeConverters2 = (TypeConverters)entry.getValue();
                LOG.info("Adding custom TypeConverters with id: {} and implementation: {}", entry.getKey(), (Object)typeConverters2);
                camelContext.getTypeConverterRegistry().addTypeConverters(typeConverters2);
            }
        }
        if ((eventNotifiers = applicationContext.getBeansOfType(EventNotifier.class)) != null && !eventNotifiers.isEmpty()) {
            for (Map.Entry entry : eventNotifiers.entrySet()) {
                EventNotifier eventNotifier = (EventNotifier)entry.getValue();
                if (camelContext.getManagementStrategy().getEventNotifiers().contains(eventNotifier)) continue;
                LOG.info("Using custom EventNotifier with id: {} and implementation: {}", entry.getKey(), (Object)eventNotifier);
                camelContext.getManagementStrategy().addEventNotifier(eventNotifier);
            }
        }
        if ((map3 = applicationContext.getBeansOfType(EndpointStrategy.class)) != null && !map3.isEmpty()) {
            for (Map.Entry entry : map3.entrySet()) {
                EndpointStrategy strategy = (EndpointStrategy)entry.getValue();
                LOG.info("Using custom EndpointStrategy with id: {} and implementation: {}", entry.getKey(), (Object)strategy);
                camelContext.addRegisterEndpointCallback(strategy);
            }
        }
        if ((shutdownStrategy = CamelAutoConfiguration.getSingleBeanOfType(applicationContext, ShutdownStrategy.class)) != null) {
            LOG.info("Using custom ShutdownStrategy: " + shutdownStrategy);
            camelContext.setShutdownStrategy(shutdownStrategy);
        }
        if ((map2 = applicationContext.getBeansOfType(InterceptStrategy.class)) != null && !map2.isEmpty()) {
            for (Map.Entry entry : map2.entrySet()) {
                InterceptStrategy interceptStrategy = (InterceptStrategy)entry.getValue();
                if (camelContext.getInterceptStrategies().contains(interceptStrategy)) continue;
                LOG.info("Using custom InterceptStrategy with id: {} and implementation: {}", entry.getKey(), (Object)interceptStrategy);
                camelContext.addInterceptStrategy(interceptStrategy);
            }
        }
        if ((lifecycleStrategies = applicationContext.getBeansOfType(LifecycleStrategy.class)) != null && !lifecycleStrategies.isEmpty()) {
            for (Map.Entry entry : lifecycleStrategies.entrySet()) {
                LifecycleStrategy strategy = (LifecycleStrategy)entry.getValue();
                if (camelContext.getLifecycleStrategies().contains(strategy)) continue;
                LOG.info("Using custom LifecycleStrategy with id: {} and implementation: {}", entry.getKey(), (Object)strategy);
                camelContext.addLifecycleStrategy(strategy);
            }
        }
        if ((camelClusterService = CamelAutoConfiguration.getSingleBeanOfType(applicationContext, CamelClusterService.class)) != null) {
            LOG.info("Using CamelClusterService: " + camelClusterService);
            camelContext.addService((Object)camelClusterService);
        }
        if ((map = applicationContext.getBeansOfType(RoutePolicyFactory.class)) != null && !map.isEmpty()) {
            for (Map.Entry entry : map.entrySet()) {
                RoutePolicyFactory factory = (RoutePolicyFactory)entry.getValue();
                LOG.info("Using custom RoutePolicyFactory with id: {} and implementation: {}", entry.getKey(), (Object)factory);
                camelContext.addRoutePolicyFactory(factory);
            }
        }
        if ((sslContextParametersSupplier = CamelAutoConfiguration.getSingleBeanOfType(applicationContext, GlobalSSLContextParametersSupplier.class)) != null) {
            camelContext.setSSLContextParameters((SSLContextParameters)sslContextParametersSupplier.get());
        }
        if ((routeController = CamelAutoConfiguration.getSingleBeanOfType(applicationContext, RouteController.class)) != null) {
            LOG.info("Using RouteController: " + routeController);
            camelContext.setRouteController(routeController);
        }
        CamelAutoConfiguration.initThreadPoolProfiles(applicationContext, camelContext);
    }

    private static void initThreadPoolProfiles(ApplicationContext applicationContext, CamelContext camelContext) {
        HashSet defaultIds = new HashSet();
        Map profiles = applicationContext.getBeansOfType(ThreadPoolProfile.class);
        if (profiles != null && !profiles.isEmpty()) {
            for (Map.Entry entry : profiles.entrySet()) {
                ThreadPoolProfile profile = (ThreadPoolProfile)entry.getValue();
                if (profile.isDefaultProfile().booleanValue()) {
                    LOG.info("Using custom default ThreadPoolProfile with id: {} and implementation: {}", entry.getKey(), (Object)profile);
                    camelContext.getExecutorServiceManager().setDefaultThreadPoolProfile(profile);
                    defaultIds.add(entry.getKey());
                    continue;
                }
                camelContext.getExecutorServiceManager().registerThreadPoolProfile(profile);
            }
        }
        if (defaultIds.size() > 1) {
            throw new IllegalArgumentException("Only exactly one default ThreadPoolProfile is allowed, was " + defaultIds.size() + " ids: " + defaultIds);
        }
    }

    private static <T> T getSingleBeanOfType(ApplicationContext applicationContext, Class<T> type) {
        Map beans = applicationContext.getBeansOfType(type);
        if (beans.size() == 1) {
            return (T)beans.values().iterator().next();
        }
        return null;
    }
}

