/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.spring.boot.actuate.endpoint;

import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.camel.CamelContext;
import org.apache.camel.Route;
import org.apache.camel.spi.RouteController;
import org.springframework.boot.actuate.endpoint.AbstractEndpoint;
import org.springframework.boot.context.properties.ConfigurationProperties;

@ConfigurationProperties(prefix="endpoints.camelroutecontroller")
public class CamelRouteControllerEndpoint
extends AbstractEndpoint<List<String>> {
    public static final String ENDPOINT_ID = "camelroutecontroller";
    private CamelContext camelContext;

    public CamelRouteControllerEndpoint(CamelContext camelContext) {
        super(ENDPOINT_ID);
        this.camelContext = camelContext;
        this.setEnabled(true);
    }

    public List<String> invoke() {
        RouteController controller = this.camelContext.getRouteController();
        if (controller != null) {
            return controller.getControlledRoutes().stream().map(Route::getId).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }
}

