/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.spring.boot.actuate.endpoint;

import java.util.function.Supplier;
import org.apache.camel.spring.boot.actuate.endpoint.CamelRouteControllerEndpoint;
import org.springframework.boot.actuate.endpoint.Endpoint;
import org.springframework.boot.actuate.endpoint.mvc.EndpointMvcAdapter;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.ResponseStatus;

@ConfigurationProperties(prefix="endpoints.camelroutecontroller")
public class CamelRouteControllerMvcEndpoint
extends EndpointMvcAdapter {
    public static final String PATH = "/camel/route-controller";
    private final CamelRouteControllerEndpoint delegate;

    public CamelRouteControllerMvcEndpoint(CamelRouteControllerEndpoint delegate) {
        super((Endpoint)delegate);
        this.setPath(PATH);
        this.delegate = delegate;
    }

    private Object doIfEnabled(Supplier<Object> supplier) {
        if (!this.delegate.isEnabled()) {
            return this.getDisabledResponse();
        }
        return supplier.get();
    }

    @ResponseStatus(value=HttpStatus.NOT_FOUND, reason="No such route")
    public static class NoSuchRouteException
    extends RuntimeException {
        public NoSuchRouteException(String message) {
            super(message);
        }
    }

    @ResponseStatus(value=HttpStatus.INTERNAL_SERVER_ERROR)
    public static class GenericException
    extends RuntimeException {
        public GenericException(String message, Throwable cause) {
            super(message, cause);
        }
    }
}

