/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.spring.boot.actuate.endpoint;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.camel.CamelContext;
import org.apache.camel.Route;
import org.apache.camel.StatefulService;
import org.apache.camel.api.management.mbean.ManagedRouteMBean;
import org.apache.camel.spi.RouteError;
import org.springframework.boot.actuate.endpoint.AbstractEndpoint;
import org.springframework.boot.context.properties.ConfigurationProperties;

@ConfigurationProperties(prefix="endpoints.camelroutes")
public class CamelRoutesEndpoint
extends AbstractEndpoint<List<RouteEndpointInfo>> {
    public static final String ENDPOINT_ID = "camelroutes";
    private CamelContext camelContext;

    public CamelRoutesEndpoint(CamelContext camelContext) {
        super(ENDPOINT_ID);
        this.camelContext = camelContext;
        this.setEnabled(true);
    }

    public List<RouteEndpointInfo> invoke() {
        return this.getRoutesInfo();
    }

    public RouteEndpointInfo getRouteInfo(String id) {
        Route route = this.camelContext.getRoute(id);
        if (route != null) {
            return new RouteEndpointInfo(route);
        }
        return null;
    }

    public List<RouteEndpointInfo> getRoutesInfo() {
        return this.camelContext.getRoutes().stream().map(RouteEndpointInfo::new).collect(Collectors.toList());
    }

    public RouteDetailsEndpointInfo getRouteDetailsInfo(String id) {
        Route route = this.camelContext.getRoute(id);
        if (route != null) {
            return new RouteDetailsEndpointInfo(this.camelContext, route);
        }
        return null;
    }

    public void startRoute(String id) throws Exception {
        this.camelContext.getRouteController().startRoute(id);
    }

    public void resetRoute(String id) throws Exception {
        ManagedRouteMBean managedRouteMBean = this.camelContext.getManagedRoute(id, ManagedRouteMBean.class);
        if (managedRouteMBean != null) {
            managedRouteMBean.reset(true);
        }
    }

    public void stopRoute(String id, Optional<Long> timeout, Optional<TimeUnit> timeUnit, Optional<Boolean> abortAfterTimeout) throws Exception {
        if (timeout.isPresent()) {
            this.camelContext.getRouteController().stopRoute(id, timeout.get().longValue(), timeUnit.orElse(TimeUnit.SECONDS), abortAfterTimeout.orElse(Boolean.TRUE).booleanValue());
        } else {
            this.camelContext.getRouteController().stopRoute(id);
        }
    }

    public void suspendRoute(String id, Optional<Long> timeout, Optional<TimeUnit> timeUnit) throws Exception {
        if (timeout.isPresent()) {
            this.camelContext.getRouteController().suspendRoute(id, timeout.get().longValue(), timeUnit.orElse(TimeUnit.SECONDS));
        } else {
            this.camelContext.getRouteController().suspendRoute(id);
        }
    }

    public void resumeRoute(String id) throws Exception {
        this.camelContext.getRouteController().resumeRoute(id);
    }

    public static class RouteDetailsEndpointInfo
    extends RouteEndpointInfo {
        @JsonProperty(value="details")
        private RouteDetails routeDetails;

        public RouteDetailsEndpointInfo(CamelContext camelContext, Route route) {
            super(route);
            if (camelContext.getManagementStrategy().getManagementAgent() != null) {
                this.routeDetails = new RouteDetails(camelContext.getManagedRoute(route.getId(), ManagedRouteMBean.class));
            }
        }

        @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
        static class RouteDetails {
            private long deltaProcessingTime;
            private long exchangesInflight;
            private long exchangesTotal;
            private long externalRedeliveries;
            private long failuresHandled;
            private String firstExchangeCompletedExchangeId;
            private Date firstExchangeCompletedTimestamp;
            private String firstExchangeFailureExchangeId;
            private Date firstExchangeFailureTimestamp;
            private String lastExchangeCompletedExchangeId;
            private Date lastExchangeCompletedTimestamp;
            private String lastExchangeFailureExchangeId;
            private Date lastExchangeFailureTimestamp;
            private long lastProcessingTime;
            private String load01;
            private String load05;
            private String load15;
            private long maxProcessingTime;
            private long meanProcessingTime;
            private long minProcessingTime;
            private Long oldestInflightDuration;
            private String oldestInflightExchangeId;
            private long redeliveries;
            private long totalProcessingTime;
            private RouteError lastError;
            private boolean hasRouteController;

            RouteDetails(ManagedRouteMBean managedRoute) {
                try {
                    this.deltaProcessingTime = managedRoute.getDeltaProcessingTime();
                    this.exchangesInflight = managedRoute.getExchangesInflight();
                    this.exchangesTotal = managedRoute.getExchangesTotal();
                    this.externalRedeliveries = managedRoute.getExternalRedeliveries();
                    this.failuresHandled = managedRoute.getFailuresHandled();
                    this.firstExchangeCompletedExchangeId = managedRoute.getFirstExchangeCompletedExchangeId();
                    this.firstExchangeCompletedTimestamp = managedRoute.getFirstExchangeCompletedTimestamp();
                    this.firstExchangeFailureExchangeId = managedRoute.getFirstExchangeFailureExchangeId();
                    this.firstExchangeFailureTimestamp = managedRoute.getFirstExchangeFailureTimestamp();
                    this.lastExchangeCompletedExchangeId = managedRoute.getLastExchangeCompletedExchangeId();
                    this.lastExchangeCompletedTimestamp = managedRoute.getLastExchangeCompletedTimestamp();
                    this.lastExchangeFailureExchangeId = managedRoute.getLastExchangeFailureExchangeId();
                    this.lastExchangeFailureTimestamp = managedRoute.getLastExchangeFailureTimestamp();
                    this.lastProcessingTime = managedRoute.getLastProcessingTime();
                    this.load01 = managedRoute.getLoad01();
                    this.load05 = managedRoute.getLoad05();
                    this.load15 = managedRoute.getLoad15();
                    this.maxProcessingTime = managedRoute.getMaxProcessingTime();
                    this.meanProcessingTime = managedRoute.getMeanProcessingTime();
                    this.minProcessingTime = managedRoute.getMinProcessingTime();
                    this.oldestInflightDuration = managedRoute.getOldestInflightDuration();
                    this.oldestInflightExchangeId = managedRoute.getOldestInflightExchangeId();
                    this.redeliveries = managedRoute.getRedeliveries();
                    this.totalProcessingTime = managedRoute.getTotalProcessingTime();
                    this.lastError = managedRoute.getLastError();
                    this.hasRouteController = managedRoute.getHasRouteController();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }

            public long getDeltaProcessingTime() {
                return this.deltaProcessingTime;
            }

            public long getExchangesInflight() {
                return this.exchangesInflight;
            }

            public long getExchangesTotal() {
                return this.exchangesTotal;
            }

            public long getExternalRedeliveries() {
                return this.externalRedeliveries;
            }

            public long getFailuresHandled() {
                return this.failuresHandled;
            }

            public String getFirstExchangeCompletedExchangeId() {
                return this.firstExchangeCompletedExchangeId;
            }

            public Date getFirstExchangeCompletedTimestamp() {
                return this.firstExchangeCompletedTimestamp;
            }

            public String getFirstExchangeFailureExchangeId() {
                return this.firstExchangeFailureExchangeId;
            }

            public Date getFirstExchangeFailureTimestamp() {
                return this.firstExchangeFailureTimestamp;
            }

            public String getLastExchangeCompletedExchangeId() {
                return this.lastExchangeCompletedExchangeId;
            }

            public Date getLastExchangeCompletedTimestamp() {
                return this.lastExchangeCompletedTimestamp;
            }

            public String getLastExchangeFailureExchangeId() {
                return this.lastExchangeFailureExchangeId;
            }

            public Date getLastExchangeFailureTimestamp() {
                return this.lastExchangeFailureTimestamp;
            }

            public long getLastProcessingTime() {
                return this.lastProcessingTime;
            }

            public String getLoad01() {
                return this.load01;
            }

            public String getLoad05() {
                return this.load05;
            }

            public String getLoad15() {
                return this.load15;
            }

            public long getMaxProcessingTime() {
                return this.maxProcessingTime;
            }

            public long getMeanProcessingTime() {
                return this.meanProcessingTime;
            }

            public long getMinProcessingTime() {
                return this.minProcessingTime;
            }

            public Long getOldestInflightDuration() {
                return this.oldestInflightDuration;
            }

            public String getOldestInflightExchangeId() {
                return this.oldestInflightExchangeId;
            }

            public long getRedeliveries() {
                return this.redeliveries;
            }

            public long getTotalProcessingTime() {
                return this.totalProcessingTime;
            }

            public RouteError getLastError() {
                return this.lastError;
            }

            public boolean getHasRouteController() {
                return this.hasRouteController;
            }
        }
    }

    @JsonPropertyOrder(value={"id", "description", "uptime", "uptimeMillis"})
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    public static class RouteEndpointInfo {
        private final String id;
        private final String description;
        private final String uptime;
        private final long uptimeMillis;
        private final String status;

        public RouteEndpointInfo(Route route) {
            this.id = route.getId();
            this.description = route.getDescription();
            this.uptime = route.getUptime();
            this.uptimeMillis = route.getUptimeMillis();
            this.status = route instanceof StatefulService ? ((StatefulService)route).getStatus().name() : null;
        }

        public String getId() {
            return this.id;
        }

        public String getDescription() {
            return this.description;
        }

        public String getUptime() {
            return this.uptime;
        }

        public long getUptimeMillis() {
            return this.uptimeMillis;
        }

        public String getStatus() {
            return this.status;
        }
    }
}

