/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.spring.javaconfig;

import java.lang.reflect.Modifier;
import org.apache.camel.CamelContext;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.spring.javaconfig.CamelConfiguration;
import org.apache.camel.spring.javaconfig.CamelSpringJavaconfigInitializationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.core.Ordered;

public class RoutesCollector
implements ApplicationListener<ContextRefreshedEvent>,
Ordered {
    private static final Logger LOG = LoggerFactory.getLogger(RoutesCollector.class);
    private final ApplicationContext applicationContext;
    private final CamelConfiguration configuration;

    public RoutesCollector(ApplicationContext applicationContext, CamelConfiguration configuration) {
        this.applicationContext = applicationContext;
        this.configuration = configuration;
    }

    public void onApplicationEvent(ContextRefreshedEvent event) {
        ApplicationContext applicationContext = event.getApplicationContext();
        if (this.applicationContext.equals(applicationContext)) {
            CamelContext camelContext = (CamelContext)event.getApplicationContext().getBean(CamelContext.class);
            if (camelContext.getStatus().isStopped()) {
                LOG.debug("Post-processing CamelContext bean: {}", (Object)camelContext.getName());
                for (RoutesBuilder routesBuilder : this.configuration.routes()) {
                    boolean abs = Modifier.isAbstract(routesBuilder.getClass().getModifiers());
                    if (abs) continue;
                    try {
                        LOG.debug("Injecting following route into the CamelContext: {}", (Object)routesBuilder);
                        camelContext.addRoutes(routesBuilder);
                    }
                    catch (Exception e) {
                        throw new CamelSpringJavaconfigInitializationException(e);
                    }
                }
                try {
                    boolean skip = "true".equalsIgnoreCase(System.getProperty("skipStartingCamelContext"));
                    if (skip) {
                        LOG.info("Skipping starting CamelContext(s) as system property skipStartingCamelContext is set to be true.");
                    }
                    camelContext.start();
                }
                catch (Exception e) {
                    throw new CamelSpringJavaconfigInitializationException(e);
                }
            }
        } else {
            LOG.debug("Ignore ContextRefreshedEvent: {}", (Object)event);
        }
    }

    public int getOrder() {
        return 0x7FFFFFFE;
    }
}

