/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.core.osgi;

import java.util.concurrent.atomic.AtomicInteger;
import org.apache.camel.CamelContext;
import org.apache.camel.spi.CamelContextNameStrategy;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OsgiCamelContextNameStrategy
implements CamelContextNameStrategy {
    private static final Logger LOG = LoggerFactory.getLogger(OsgiCamelContextNameStrategy.class);
    private static final AtomicInteger CONTEXT_COUNTER = new AtomicInteger(0);
    private final BundleContext context;
    private final String prefix = "camel";
    private volatile String name;

    public OsgiCamelContextNameStrategy(BundleContext context) {
        this.context = context;
    }

    public String getName() {
        if (this.name == null) {
            this.name = this.getNextName();
        }
        return this.name;
    }

    public synchronized String getNextName() {
        String candidate = null;
        boolean clash = false;
        block2: do {
            try {
                clash = false;
                candidate = "camel-" + OsgiCamelContextNameStrategy.getNextCounter();
                LOG.trace("Checking OSGi Service Registry for existence of existing CamelContext with name: {}", (Object)candidate);
                ServiceReference[] refs = this.context.getServiceReferences(CamelContext.class.getName(), "(camel.context.name=" + candidate + ")");
                if (refs == null || refs.length <= 0) continue;
                for (ServiceReference ref : refs) {
                    Object id = ref.getProperty("camel.context.name");
                    if (id == null || !candidate.equals(id)) continue;
                    clash = true;
                    continue block2;
                }
            }
            catch (InvalidSyntaxException e) {
                LOG.debug("Error finding free Camel name in OSGi Service Registry due " + e.getMessage() + ". This exception is ignored.", (Throwable)e);
                break;
            }
        } while (clash);
        LOG.debug("Generated CamelContext name for bundle id: {}, clash: {} -> {}", new Object[]{this.context.getBundle().getBundleId(), clash, candidate});
        return candidate;
    }

    public boolean isFixedName() {
        return false;
    }

    public static int getNextCounter() {
        return CONTEXT_COUNTER.incrementAndGet();
    }
}

