/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.spring;

import org.apache.camel.CamelContext;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.spring.SpringCamelContext;
import org.apache.camel.spring.spi.SpringTransactionPolicy;
import org.apache.camel.spring.spi.TransactionErrorHandlerBuilder;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.support.TransactionTemplate;

public abstract class SpringRouteBuilder
extends RouteBuilder
implements ApplicationContextAware {
    private ApplicationContext applicationContext;

    public <T> T lookup(String beanName, Class<T> type) {
        ApplicationContext context = this.getApplicationContext();
        return (T)context.getBean(beanName, type);
    }

    public <T> T lookup(Class<T> type) {
        ApplicationContext context = this.getApplicationContext();
        String[] names = context.getBeanNamesForType(type, true, true);
        if (names != null) {
            int count = names.length;
            if (count == 1) {
                return (T)context.getBean(names[0]);
            }
            if (count > 1) {
                throw new IllegalArgumentException("Too many beans in the application context of type: " + type + ". Found: " + count);
            }
        }
        throw new IllegalArgumentException("No bean available in the application context of type: " + type);
    }

    public ApplicationContext getApplicationContext() {
        if (this.applicationContext == null) {
            CamelContext camelContext = this.getContext();
            if (camelContext instanceof SpringCamelContext) {
                SpringCamelContext springCamelContext = (SpringCamelContext)camelContext;
                return springCamelContext.getApplicationContext();
            }
            throw new IllegalArgumentException("This SpringBuilder is not being used with a SpringCamelContext and there is no applicationContext property configured");
        }
        return this.applicationContext;
    }

    public void setApplicationContext(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    public TransactionErrorHandlerBuilder transactionErrorHandler() {
        return new TransactionErrorHandlerBuilder();
    }

    public TransactionErrorHandlerBuilder transactionErrorHandler(SpringTransactionPolicy policy) {
        return this.transactionErrorHandler(policy.getTransactionTemplate());
    }

    public TransactionErrorHandlerBuilder transactionErrorHandler(TransactionTemplate template) {
        TransactionErrorHandlerBuilder answer = new TransactionErrorHandlerBuilder();
        answer.setTransactionTemplate(template);
        return answer;
    }

    public TransactionErrorHandlerBuilder transactionErrorHandler(PlatformTransactionManager transactionManager) {
        TransactionTemplate template = new TransactionTemplate(transactionManager);
        return this.transactionErrorHandler(template);
    }
}

