/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.spring.spi;

import java.util.Map;
import java.util.Properties;
import java.util.function.Predicate;
import org.apache.camel.component.properties.PropertiesLookup;
import org.apache.camel.component.properties.PropertiesParser;
import org.apache.camel.spi.LoadablePropertiesSource;
import org.apache.camel.spi.PropertiesSource;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.config.PropertyPlaceholderConfigurer;
import org.springframework.core.Constants;
import org.springframework.util.PropertyPlaceholderHelper;

public class BridgePropertyPlaceholderConfigurer
extends PropertyPlaceholderConfigurer
implements PropertiesParser,
PropertiesSource,
LoadablePropertiesSource {
    private final Properties properties = new Properties();
    private PropertiesParser parser;
    private PropertyPlaceholderHelper helper;
    private int systemPropertiesMode = 1;

    protected void processProperties(ConfigurableListableBeanFactory beanFactoryToProcess, Properties props) throws BeansException {
        super.processProperties(beanFactoryToProcess, props);
        this.properties.putAll((Map<?, ?>)props);
        this.helper = new PropertyPlaceholderHelper(this.placeholderPrefix, this.placeholderSuffix, this.valueSeparator, this.ignoreUnresolvablePlaceholders);
    }

    public int getSystemPropertiesMode() {
        return this.systemPropertiesMode;
    }

    public void setSystemPropertiesModeName(String constantName) throws IllegalArgumentException {
        super.setSystemPropertiesModeName(constantName);
        Constants constants = new Constants(PropertyPlaceholderConfigurer.class);
        this.systemPropertiesMode = constants.asNumber(constantName).intValue();
    }

    public void setSystemPropertiesMode(int systemPropertiesMode) {
        super.setSystemPropertiesMode(systemPropertiesMode);
        this.systemPropertiesMode = systemPropertiesMode;
    }

    protected String resolvePlaceholder(String placeholder, Properties props) {
        String value = props.getProperty(placeholder);
        if (this.parser != null) {
            return this.parser.parseProperty(placeholder, value, props::getProperty);
        }
        return value;
    }

    public String parseUri(String text, PropertiesLookup properties, boolean fallback, boolean keepUnresolvedOptional, boolean nestedPlaceholder) throws IllegalArgumentException {
        String answer = this.parser.parseUri(text, properties, fallback, keepUnresolvedOptional, nestedPlaceholder);
        answer = answer != null ? this.springResolvePlaceholders(answer, properties) : this.springResolvePlaceholders(text, properties);
        return answer;
    }

    public String parseProperty(String key, String value, PropertiesLookup properties) {
        String answer = this.parser.parseProperty(key, value, properties);
        answer = answer != null ? this.springResolvePlaceholders(answer, properties) : this.springResolvePlaceholders(value, properties);
        return answer;
    }

    protected String springResolvePlaceholders(String text, PropertiesLookup properties) {
        return this.helper.replacePlaceholders(text, (PropertyPlaceholderHelper.PlaceholderResolver)new BridgePropertyPlaceholderResolver(properties));
    }

    public void setParser(PropertiesParser parser) {
        this.parser = this.parser != null ? new BridgePropertiesParser(this.parser, parser) : parser;
    }

    public String getName() {
        return "BridgePropertyPlaceholderConfigurer";
    }

    public String getProperty(String name) {
        return this.properties.getProperty(name);
    }

    public Properties loadProperties() {
        return this.properties;
    }

    public Properties loadProperties(Predicate<String> filter) {
        Properties props = new Properties();
        for (String name : this.properties.stringPropertyNames()) {
            if (!filter.test(name)) continue;
            props.put(name, this.properties.get(name));
        }
        return props;
    }

    public void reloadProperties(String location) {
    }

    private class BridgePropertyPlaceholderResolver
    implements PropertyPlaceholderHelper.PlaceholderResolver {
        private final PropertiesLookup properties;

        BridgePropertyPlaceholderResolver(PropertiesLookup properties) {
            this.properties = properties;
        }

        public String resolvePlaceholder(String placeholderName) {
            String propVal = null;
            if (BridgePropertyPlaceholderConfigurer.this.systemPropertiesMode == 2) {
                propVal = BridgePropertyPlaceholderConfigurer.this.resolveSystemProperty(placeholderName);
            }
            if (propVal == null) {
                propVal = this.properties.lookup(placeholderName);
            }
            if (propVal == null && BridgePropertyPlaceholderConfigurer.this.systemPropertiesMode == 1) {
                propVal = BridgePropertyPlaceholderConfigurer.this.resolveSystemProperty(placeholderName);
            }
            return propVal;
        }
    }

    private static final class BridgePropertiesParser
    implements PropertiesParser {
        private final PropertiesParser delegate;
        private final PropertiesParser parser;

        private BridgePropertiesParser(PropertiesParser delegate, PropertiesParser parser) {
            this.delegate = delegate;
            this.parser = parser;
        }

        public String parseUri(String text, PropertiesLookup properties, boolean fallback, boolean keepUnresolvedOptional, boolean nestedPlaceholder) throws IllegalArgumentException {
            String answer = null;
            if (this.delegate != null) {
                answer = this.delegate.parseUri(text, properties, fallback, keepUnresolvedOptional, nestedPlaceholder);
            }
            if (answer != null) {
                text = answer;
            }
            return this.parser.parseUri(text, properties, fallback, keepUnresolvedOptional, nestedPlaceholder);
        }

        public String parseProperty(String key, String value, PropertiesLookup properties) {
            String answer = null;
            if (this.delegate != null) {
                answer = this.delegate.parseProperty(key, value, properties);
            }
            if (answer != null) {
                value = answer;
            }
            return this.parser.parseProperty(key, value, properties);
        }
    }
}

