/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.support.processor;

import java.text.NumberFormat;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.camel.AsyncCallback;
import org.apache.camel.AsyncProcessor;
import org.apache.camel.CamelContext;
import org.apache.camel.Exchange;
import org.apache.camel.spi.CamelLogger;
import org.apache.camel.spi.IdAware;
import org.apache.camel.spi.RouteIdAware;
import org.apache.camel.support.AsyncProcessorSupport;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ThroughputLogger
extends AsyncProcessorSupport
implements AsyncProcessor,
IdAware,
RouteIdAware {
    private static final Logger LOG = LoggerFactory.getLogger(ThroughputLogger.class);
    private String id;
    private String routeId;
    private final AtomicLong receivedCounter = new AtomicLong();
    private NumberFormat numberFormat = NumberFormat.getNumberInstance();
    private long groupReceivedCount;
    private boolean groupActiveOnly;
    private Integer groupSize;
    private long groupDelay = 1000L;
    private Long groupInterval;
    private long startTime;
    private long groupStartTime;
    private String action = "Received";
    private CamelContext camelContext;
    private ScheduledExecutorService logSchedulerService;
    private CamelLogger logger;
    private String lastLogMessage;
    private double rate;
    private double average;

    public ThroughputLogger(CamelLogger logger) {
        this.logger = logger;
    }

    public ThroughputLogger(CamelLogger logger, Integer groupSize) {
        this(logger);
        this.setGroupSize(groupSize);
    }

    public ThroughputLogger(CamelLogger logger, CamelContext camelContext, Long groupInterval, Long groupDelay, Boolean groupActiveOnly) {
        this(logger);
        this.camelContext = camelContext;
        this.setGroupInterval(groupInterval);
        this.setGroupActiveOnly(groupActiveOnly);
        if (groupDelay != null) {
            this.setGroupDelay(groupDelay);
        }
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getRouteId() {
        return this.routeId;
    }

    public void setRouteId(String routeId) {
        this.routeId = routeId;
    }

    @Override
    public void process(Exchange exchange) throws Exception {
        if (this.startTime == 0L) {
            this.startTime = System.currentTimeMillis();
        }
        long receivedCount = this.receivedCounter.incrementAndGet();
        if (this.groupSize != null && receivedCount % (long)this.groupSize.intValue() == 0L) {
            this.lastLogMessage = this.createLogMessage(exchange, receivedCount);
            this.logger.log(this.lastLogMessage);
        }
    }

    public boolean process(Exchange exchange, AsyncCallback callback) {
        try {
            this.process(exchange);
        }
        catch (Exception e) {
            exchange.setException((Throwable)e);
        }
        callback.done(true);
        return true;
    }

    public Integer getGroupSize() {
        return this.groupSize;
    }

    public void setGroupSize(Integer groupSize) {
        if (groupSize == null || groupSize <= 0) {
            throw new IllegalArgumentException("groupSize must be positive, was: " + groupSize);
        }
        this.groupSize = groupSize;
    }

    public Long getGroupInterval() {
        return this.groupInterval;
    }

    public void setGroupInterval(Long groupInterval) {
        if (groupInterval == null || groupInterval <= 0L) {
            throw new IllegalArgumentException("groupInterval must be positive, was: " + groupInterval);
        }
        this.groupInterval = groupInterval;
    }

    public long getGroupDelay() {
        return this.groupDelay;
    }

    public void setGroupDelay(long groupDelay) {
        this.groupDelay = groupDelay;
    }

    public boolean getGroupActiveOnly() {
        return this.groupActiveOnly;
    }

    private void setGroupActiveOnly(boolean groupActiveOnly) {
        this.groupActiveOnly = groupActiveOnly;
    }

    public NumberFormat getNumberFormat() {
        return this.numberFormat;
    }

    public void setNumberFormat(NumberFormat numberFormat) {
        this.numberFormat = numberFormat;
    }

    public String getAction() {
        return this.action;
    }

    public void setAction(String action) {
        this.action = action;
    }

    public void reset() {
        this.startTime = 0L;
        this.receivedCounter.set(0L);
        this.groupStartTime = 0L;
        this.groupReceivedCount = 0L;
        this.average = 0.0;
        this.rate = 0.0;
        this.lastLogMessage = null;
    }

    public double getRate() {
        return this.rate;
    }

    public double getAverage() {
        return this.average;
    }

    public long getReceivedCounter() {
        return this.receivedCounter.get();
    }

    public String getLastLogMessage() {
        return this.lastLogMessage;
    }

    @Override
    public void doStart() throws Exception {
        if (this.groupInterval != null) {
            ObjectHelper.notNull((Object)this.camelContext, (String)"CamelContext", (Object)((Object)this));
            this.logSchedulerService = this.camelContext.getExecutorServiceManager().newSingleThreadScheduledExecutor((Object)this, "ThroughputLogger");
            ScheduledLogTask scheduledLogTask = new ScheduledLogTask();
            LOG.info("Scheduling throughput logger to run every {} millis.", (Object)this.groupInterval);
            this.logSchedulerService.scheduleAtFixedRate(scheduledLogTask, this.groupDelay, this.groupInterval, TimeUnit.MILLISECONDS);
        }
    }

    @Override
    public void doStop() throws Exception {
        if (this.logSchedulerService != null) {
            this.camelContext.getExecutorServiceManager().shutdown((ExecutorService)this.logSchedulerService);
            this.logSchedulerService = null;
        }
    }

    protected String createLogMessage(Exchange exchange, long receivedCount) {
        long time = System.currentTimeMillis();
        if (this.groupStartTime == 0L) {
            this.groupStartTime = this.startTime;
        }
        this.rate = this.messagesPerSecond(this.groupSize.intValue(), this.groupStartTime, time);
        this.average = this.messagesPerSecond(receivedCount, this.startTime, time);
        long duration = time - this.groupStartTime;
        this.groupStartTime = time;
        return this.getAction() + ": " + receivedCount + " messages so far. Last group took: " + duration + " millis which is: " + this.numberFormat.format(this.rate) + " messages per second. average: " + this.numberFormat.format(this.average);
    }

    protected void createGroupIntervalLogMessage() {
        if (this.startTime == 0L) {
            return;
        }
        long receivedCount = this.receivedCounter.get();
        if (this.groupActiveOnly && receivedCount == this.groupReceivedCount) {
            return;
        }
        long time = System.currentTimeMillis();
        if (this.groupStartTime == 0L) {
            this.groupStartTime = this.startTime;
        }
        long duration = time - this.groupStartTime;
        long currentCount = receivedCount - this.groupReceivedCount;
        this.rate = this.messagesPerSecond(currentCount, this.groupStartTime, time);
        this.average = this.messagesPerSecond(receivedCount, this.startTime, time);
        this.groupStartTime = time;
        this.groupReceivedCount = receivedCount;
        this.lastLogMessage = this.getAction() + ": " + currentCount + " new messages, with total " + receivedCount + " so far. Last group took: " + duration + " millis which is: " + this.numberFormat.format(this.rate) + " messages per second. average: " + this.numberFormat.format(this.average);
        this.logger.log(this.lastLogMessage);
    }

    protected double messagesPerSecond(long messageCount, long startTime, long endTime) {
        double rate = (double)messageCount * 1000.0;
        return rate /= (double)(endTime - startTime);
    }

    private final class ScheduledLogTask
    implements Runnable {
        private ScheduledLogTask() {
        }

        @Override
        public void run() {
            if (!ThroughputLogger.this.camelContext.getStatus().isStarted()) {
                LOG.trace("ThroughputLogger cannot start because CamelContext({}) has not been started yet", (Object)ThroughputLogger.this.camelContext.getName());
                return;
            }
            ThroughputLogger.this.createGroupIntervalLogMessage();
        }
    }
}

