/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.support;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.channels.ReadableByteChannel;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelExecutionException;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.ExchangePattern;
import org.apache.camel.ExchangePropertyKey;
import org.apache.camel.ExtendedExchange;
import org.apache.camel.Message;
import org.apache.camel.NoSuchBeanException;
import org.apache.camel.NoSuchEndpointException;
import org.apache.camel.NoSuchHeaderException;
import org.apache.camel.NoSuchPropertyException;
import org.apache.camel.NoTypeConversionAvailableException;
import org.apache.camel.Route;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.TypeConversionException;
import org.apache.camel.WrappedFile;
import org.apache.camel.spi.NormalizedEndpointUri;
import org.apache.camel.spi.UnitOfWork;
import org.apache.camel.spi.annotations.EagerClassloaded;
import org.apache.camel.support.CamelContextHelper;
import org.apache.camel.support.DefaultExchange;
import org.apache.camel.support.MessageHelper;
import org.apache.camel.support.MessageSupport;
import org.apache.camel.util.IOHelper;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.Scanner;
import org.apache.camel.util.StringHelper;
import org.slf4j.Logger;

@EagerClassloaded
public final class ExchangeHelper {
    private static String defaultCharsetName = ObjectHelper.getSystemProperty((String)"org.apache.camel.default.charset", (String)"UTF-8");
    private static Charset defaultCharset = Charset.forName(defaultCharsetName);

    private ExchangeHelper() {
    }

    public static void onClassloaded(Logger log) {
        log.trace("Loaded ExchangeHelper");
    }

    public static <T> T getBinding(Exchange exchange, Class<T> type) {
        return (T)(exchange != null ? exchange.getProperty("CamelBinding", type) : null);
    }

    public static Endpoint resolveEndpoint(Exchange exchange, Object value) throws NoSuchEndpointException {
        return ExchangeHelper.resolveEndpoint(exchange.getContext(), value);
    }

    public static Endpoint resolveEndpoint(CamelContext context, Object value) throws NoSuchEndpointException {
        Endpoint endpoint;
        if (value == null) {
            throw new NoSuchEndpointException("null");
        }
        if (value instanceof Endpoint) {
            endpoint = (Endpoint)value;
        } else if (value instanceof NormalizedEndpointUri) {
            NormalizedEndpointUri nu = (NormalizedEndpointUri)value;
            endpoint = CamelContextHelper.getMandatoryEndpoint(context, nu);
        } else {
            String uri = value.toString().trim();
            endpoint = CamelContextHelper.getMandatoryEndpoint(context, uri);
        }
        return endpoint;
    }

    public static Endpoint resolvePrototypeEndpoint(Exchange exchange, Object value) throws NoSuchEndpointException {
        return ExchangeHelper.resolvePrototypeEndpoint(exchange.getContext(), value);
    }

    public static Endpoint resolvePrototypeEndpoint(CamelContext context, Object value) throws NoSuchEndpointException {
        Endpoint endpoint;
        if (value == null) {
            throw new NoSuchEndpointException("null");
        }
        if (value instanceof Endpoint) {
            endpoint = (Endpoint)value;
        } else if (value instanceof NormalizedEndpointUri) {
            NormalizedEndpointUri nu = (NormalizedEndpointUri)value;
            endpoint = CamelContextHelper.getMandatoryPrototypeEndpoint(context, nu);
        } else {
            String uri = value.toString().trim();
            endpoint = CamelContextHelper.getMandatoryPrototypeEndpoint(context, uri);
        }
        return endpoint;
    }

    public static <T> T getMandatoryProperty(Exchange exchange, String propertyName, Class<T> type) throws NoSuchPropertyException {
        Object result = exchange.getProperty(propertyName, type);
        if (result != null) {
            return (T)result;
        }
        throw new NoSuchPropertyException(exchange, propertyName, type);
    }

    public static <T> T getMandatoryHeader(Exchange exchange, String headerName, Class<T> type) throws TypeConversionException, NoSuchHeaderException {
        Object answer = exchange.getIn().getHeader(headerName, type);
        if (answer == null) {
            throw new NoSuchHeaderException(exchange, headerName, type);
        }
        return (T)answer;
    }

    public static <T> T getMandatoryHeader(Message message, String headerName, Class<T> type) throws TypeConversionException, NoSuchHeaderException {
        Object answer = message.getHeader(headerName, type);
        if (answer == null) {
            throw new NoSuchHeaderException(message.getExchange(), headerName, type);
        }
        return (T)answer;
    }

    public static <T> T getHeaderOrProperty(Exchange exchange, String name, Class<T> type) throws TypeConversionException {
        Object answer = exchange.getIn().getHeader(name, type);
        if (answer == null) {
            answer = exchange.getProperty(name, type);
        }
        return (T)answer;
    }

    public static <T> T convertToMandatoryType(Exchange exchange, Class<T> type, Object value) throws TypeConversionException, NoTypeConversionAvailableException {
        return (T)exchange.getContext().getTypeConverter().mandatoryConvertTo(type, exchange, value);
    }

    public static <T> T convertToType(Exchange exchange, Class<T> type, Object value) throws TypeConversionException {
        return (T)exchange.getContext().getTypeConverter().convertTo(type, exchange, value);
    }

    public static Exchange createCorrelatedCopy(Exchange exchange, boolean handover) {
        return ExchangeHelper.createCorrelatedCopy(exchange, handover, false);
    }

    public static Exchange createCorrelatedCopy(Exchange exchange, boolean handover, boolean useSameMessageId) {
        String id = exchange.getExchangeId();
        Exchange copy = exchange.copy();
        if (!useSameMessageId) {
            if (copy.hasOut()) {
                copy.getOut().setMessageId(null);
            }
            copy.getIn().setMessageId(null);
        }
        ExtendedExchange ce = (ExtendedExchange)copy;
        ce.setUnitOfWork(null);
        if (handover) {
            ((ExtendedExchange)exchange.adapt(ExtendedExchange.class)).handoverCompletions((Exchange)ce);
        }
        copy.setProperty(ExchangePropertyKey.CORRELATION_ID, (Object)id);
        return copy;
    }

    public static Exchange createCopy(Exchange exchange, boolean preserveExchangeId) {
        Exchange copy = exchange.copy();
        if (preserveExchangeId) {
            copy.setExchangeId(exchange.getExchangeId());
        }
        return copy;
    }

    public static void copyResults(Exchange target, Exchange source) {
        ExchangeHelper.doCopyResults((ExtendedExchange)target, (ExtendedExchange)source, false);
    }

    public static void copyResultsPreservePattern(Exchange target, Exchange source) {
        ExchangeHelper.doCopyResults((ExtendedExchange)target, (ExtendedExchange)source, true);
    }

    private static void doCopyResults(ExtendedExchange result, ExtendedExchange source, boolean preserverPattern) {
        if (result == source) {
            if (result.getPattern() != ExchangePattern.InOptionalOut && result.getPattern().isOutCapable() && !result.hasOut() && !result.isFailed()) {
                result.getOut().copyFrom(source.getIn());
            }
            return;
        }
        if (source.hasOut()) {
            if (preserverPattern) {
                Message resultMessage = ExchangeHelper.getResultMessage((Exchange)result);
                resultMessage.copyFrom(source.getOut());
            } else {
                result.getOut().copyFrom(source.getOut());
            }
        } else if (result.getPattern() == ExchangePattern.InOptionalOut) {
            result.setOut(null);
        } else if (!preserverPattern && result.getPattern().isOutCapable()) {
            result.getOut().copyFrom(source.getIn());
        } else {
            result.getIn().copyFrom(source.getIn());
            if (result.hasOut()) {
                result.setOut(null);
            }
        }
        if (source.hasProperties()) {
            result.getProperties().putAll(source.getProperties());
        }
        ((ExtendedExchange)source.adapt(ExtendedExchange.class)).copyInternalProperties((Exchange)result);
        result.setRouteStop(source.isRouteStop());
        result.setRollbackOnly(source.isRollbackOnly());
        result.setRollbackOnlyLast(source.isRollbackOnlyLast());
        result.setNotifyEvent(source.isNotifyEvent());
        result.setRedeliveryExhausted(source.isRedeliveryExhausted());
        result.setErrorHandlerHandled(source.getErrorHandlerHandled());
        result.setException((Throwable)source.getException());
    }

    public static Message getResultMessage(Exchange exchange) {
        if (exchange.getPattern().isOutCapable()) {
            return exchange.getOut();
        }
        return exchange.getIn();
    }

    public static boolean isOutCapable(Exchange exchange) {
        ExchangePattern pattern = exchange.getPattern();
        return pattern != null && pattern.isOutCapable();
    }

    public static <T> T newInstance(Exchange exchange, Class<T> type) {
        return (T)exchange.getContext().getInjector().newInstance(type);
    }

    public static Map<String, Object> createVariableMap(Exchange exchange, boolean allowContextMapAll) {
        HashMap<String, Object> answer = new HashMap<String, Object>();
        ExchangeHelper.populateVariableMap(exchange, answer, allowContextMapAll);
        return answer;
    }

    public static void populateVariableMap(Exchange exchange, Map<String, Object> map, boolean allowContextMapAll) {
        Message in = exchange.getIn();
        map.put("headers", in.getHeaders());
        map.put("body", in.getBody());
        if (allowContextMapAll) {
            map.put("in", in);
            map.put("request", in);
            map.put("exchange", exchange);
            if (ExchangeHelper.isOutCapable(exchange)) {
                Message msg = exchange.getMessage();
                map.put("out", msg);
                map.put("response", msg);
            }
            map.put("camelContext", exchange.getContext());
        }
    }

    public static String getContentType(Exchange exchange) {
        return MessageHelper.getContentType(exchange.getIn());
    }

    public static String getContentEncoding(Exchange exchange) {
        return MessageHelper.getContentEncoding(exchange.getIn());
    }

    public static Object lookupMandatoryBean(Exchange exchange, String name) throws NoSuchBeanException {
        Object value = ExchangeHelper.lookupBean(exchange, name);
        if (value == null) {
            throw new NoSuchBeanException(name);
        }
        return value;
    }

    public static <T> T lookupMandatoryBean(Exchange exchange, String name, Class<T> type) {
        T value = ExchangeHelper.lookupBean(exchange, name, type);
        if (value == null) {
            throw new NoSuchBeanException(name);
        }
        return value;
    }

    public static Object lookupBean(Exchange exchange, String name) {
        return exchange.getContext().getRegistry().lookupByName(name);
    }

    public static <T> T lookupBean(Exchange exchange, String name, Class<T> type) {
        return (T)exchange.getContext().getRegistry().lookupByNameAndType(name, type);
    }

    public static void prepareAggregation(Exchange oldExchange, Exchange newExchange) {
        if (oldExchange != null) {
            ExchangeHelper.prepareOutToIn(oldExchange);
        }
        if (newExchange != null) {
            ExchangeHelper.prepareOutToIn(newExchange);
        }
    }

    public static boolean isFailureHandled(Exchange exchange) {
        return (Boolean)exchange.getProperty(ExchangePropertyKey.FAILURE_HANDLED, (Object)false, Boolean.class);
    }

    public static boolean isErrorHandlerBridge(Exchange exchange) {
        return (Boolean)exchange.getProperty(ExchangePropertyKey.ERRORHANDLER_BRIDGE, (Object)false, Boolean.class);
    }

    public static boolean isUnitOfWorkExhausted(Exchange exchange) {
        return (Boolean)exchange.getProperty(ExchangePropertyKey.UNIT_OF_WORK_EXHAUSTED, (Object)false, Boolean.class);
    }

    public static void setFailureHandled(Exchange exchange) {
        exchange.setProperty(ExchangePropertyKey.FAILURE_HANDLED, (Object)Boolean.TRUE);
        exchange.setException(null);
    }

    public static boolean isRedelivered(Exchange exchange) {
        return exchange.getIn().hasHeaders() && (Boolean)exchange.getIn().getHeader("CamelRedelivered", (Object)false, Boolean.class) != false;
    }

    public static boolean isStreamCachingEnabled(Exchange exchange) {
        Route route = exchange.getContext().getRoute(exchange.getFromRouteId());
        if (route != null) {
            return route.isStreamCaching();
        }
        return exchange.getContext().getStreamCachingStrategy().isEnabled();
    }

    public static Object extractResultBody(Exchange exchange, ExchangePattern pattern) {
        Object answer = null;
        if (exchange != null) {
            if (exchange.getException() != null) {
                throw CamelExecutionException.wrapCamelExecutionException((Exchange)exchange, (Throwable)exchange.getException());
            }
            boolean notOut = pattern != null && !pattern.isOutCapable();
            boolean hasOut = exchange.hasOut();
            answer = hasOut && !notOut ? exchange.getOut().getBody() : (!hasOut && exchange.getPattern() == ExchangePattern.InOptionalOut ? null : exchange.getIn().getBody());
            if (exchange.getException() != null) {
                throw CamelExecutionException.wrapCamelExecutionException((Exchange)exchange, (Throwable)exchange.getException());
            }
        }
        return answer;
    }

    public static <T> T extractFutureBody(CamelContext context, Future<?> future, Class<T> type) {
        try {
            T t = ExchangeHelper.doExtractFutureBody(context, future.get(), type);
            return t;
        }
        catch (InterruptedException e) {
            throw RuntimeCamelException.wrapRuntimeCamelException((Throwable)e);
        }
        catch (ExecutionException e) {
            throw CamelExecutionException.wrapCamelExecutionException(null, (Throwable)e.getCause());
        }
        finally {
            future.cancel(true);
        }
    }

    public static <T> T extractFutureBody(CamelContext context, Future<?> future, long timeout, TimeUnit unit, Class<T> type) throws TimeoutException {
        try {
            if (timeout > 0L) {
                T t = ExchangeHelper.doExtractFutureBody(context, future.get(timeout, unit), type);
                return t;
            }
            T t = ExchangeHelper.doExtractFutureBody(context, future.get(), type);
            return t;
        }
        catch (InterruptedException e) {
            throw CamelExecutionException.wrapCamelExecutionException(null, (Throwable)e);
        }
        catch (ExecutionException e) {
            throw CamelExecutionException.wrapCamelExecutionException(null, (Throwable)e.getCause());
        }
        finally {
            future.cancel(true);
        }
    }

    private static <T> T doExtractFutureBody(CamelContext context, Object result, Class<T> type) {
        if (result == null) {
            return null;
        }
        if (type.isAssignableFrom(result.getClass())) {
            return type.cast(result);
        }
        if (result instanceof Exchange) {
            Exchange exchange = (Exchange)result;
            Object answer = ExchangeHelper.extractResultBody(exchange, exchange.getPattern());
            return (T)context.getTypeConverter().convertTo(type, exchange, answer);
        }
        return (T)context.getTypeConverter().convertTo(type, result);
    }

    public static void prepareOutToIn(Exchange exchange) {
        if (exchange.hasOut()) {
            exchange.setIn(exchange.getOut());
            exchange.setOut(null);
        }
    }

    public static String logIds(Exchange exchange) {
        String msgId = exchange.getMessage().getMessageId();
        return "(MessageId: " + msgId + " on ExchangeId: " + exchange.getExchangeId() + ")";
    }

    public static Exchange copyExchangeAndSetCamelContext(Exchange exchange, CamelContext context) {
        return ExchangeHelper.copyExchangeAndSetCamelContext(exchange, context, true);
    }

    public static Exchange copyExchangeAndSetCamelContext(Exchange exchange, CamelContext context, boolean handover) {
        DefaultExchange answer = new DefaultExchange(context, exchange.getPattern());
        if (exchange.hasProperties()) {
            answer.setProperties((Map)ExchangeHelper.safeCopyProperties(exchange.getProperties()));
        }
        ((ExtendedExchange)exchange.adapt(ExtendedExchange.class)).copyInternalProperties((Exchange)answer);
        List history = (List)exchange.getProperty(ExchangePropertyKey.MESSAGE_HISTORY);
        if (history != null) {
            answer.setProperty(ExchangePropertyKey.MESSAGE_HISTORY, new CopyOnWriteArrayList(history));
        }
        if (handover) {
            ((ExtendedExchange)exchange.adapt(ExtendedExchange.class)).handoverCompletions((Exchange)answer);
        }
        answer.setIn(exchange.getIn().copy());
        if (exchange.hasOut()) {
            answer.setOut(exchange.getOut().copy());
        }
        answer.setException(exchange.getException());
        return answer;
    }

    public static void replaceMessage(Exchange exchange, Message newMessage, boolean outOnly) {
        Message old = exchange.getMessage();
        if (outOnly || exchange.hasOut()) {
            exchange.setOut(newMessage);
        } else {
            exchange.setIn(newMessage);
        }
        if (old instanceof MessageSupport) {
            ((MessageSupport)old).setExchange(null);
        }
    }

    public static Message getOriginalInMessage(Exchange exchange) {
        Message answer = null;
        UnitOfWork uow = (UnitOfWork)exchange.getProperty(ExchangePropertyKey.PARENT_UNIT_OF_WORK, UnitOfWork.class);
        if (uow != null) {
            answer = uow.getOriginalInMessage();
        }
        if (answer == null && (uow = exchange.getUnitOfWork()) != null) {
            answer = uow.getOriginalInMessage();
        }
        return answer;
    }

    public static String resolveScheme(String uri) {
        return StringHelper.before((String)uri, (String)":");
    }

    private static Map<String, Object> safeCopyProperties(Map<String, Object> properties) {
        if (properties == null) {
            return null;
        }
        return new ConcurrentHashMap<String, Object>(properties);
    }

    public static String getCharsetName(Exchange exchange) {
        return ExchangeHelper.getCharsetName(exchange, true);
    }

    public static Charset getCharset(Exchange exchange) {
        return ExchangeHelper.getCharset(exchange, true);
    }

    public static String getCharsetName(Exchange exchange, boolean useDefault) {
        if (exchange != null) {
            String charsetName = (String)exchange.getIn().getHeader("CamelCharsetName", String.class);
            if (charsetName == null) {
                charsetName = (String)exchange.getProperty(ExchangePropertyKey.CHARSET_NAME, String.class);
            }
            if (charsetName != null) {
                return IOHelper.normalizeCharset((String)charsetName);
            }
        }
        if (useDefault) {
            return ExchangeHelper.getDefaultCharsetName();
        }
        return null;
    }

    public static Charset getCharset(Exchange exchange, boolean useDefault) {
        if (exchange != null) {
            String charsetName = (String)exchange.getIn().getHeader("CamelCharsetName", String.class);
            if (charsetName == null) {
                charsetName = (String)exchange.getProperty(ExchangePropertyKey.CHARSET_NAME, String.class);
            }
            if (charsetName != null) {
                charsetName = IOHelper.normalizeCharset((String)charsetName);
                return Charset.forName(charsetName);
            }
        }
        if (useDefault) {
            return ExchangeHelper.getDefaultCharset();
        }
        return null;
    }

    private static String getDefaultCharsetName() {
        return defaultCharsetName;
    }

    private static Charset getDefaultCharset() {
        return defaultCharset;
    }

    public static Scanner getScanner(Exchange exchange, Object value, String delimiter) {
        Scanner scanner;
        if (value instanceof WrappedFile) {
            WrappedFile gf = (WrappedFile)value;
            Object body = gf.getBody();
            if (body != null) {
                value = body;
            } else {
                return ExchangeHelper.getScanner(exchange, gf.getFile(), delimiter);
            }
        }
        if (value instanceof Readable) {
            scanner = new Scanner((Readable)value, delimiter);
        } else if (value instanceof String) {
            scanner = new Scanner((String)value, delimiter);
        } else {
            String charset = (String)exchange.getProperty(ExchangePropertyKey.CHARSET_NAME, String.class);
            if (value instanceof File) {
                try {
                    scanner = new Scanner((File)value, charset, delimiter);
                }
                catch (IOException e) {
                    throw new RuntimeCamelException((Throwable)e);
                }
            } else if (value instanceof InputStream) {
                scanner = new Scanner((InputStream)value, charset, delimiter);
            } else if (value instanceof ReadableByteChannel) {
                scanner = new Scanner((ReadableByteChannel)value, charset, delimiter);
            } else {
                String text = (String)exchange.getContext().getTypeConverter().convertTo(String.class, exchange, value);
                scanner = new Scanner(text, delimiter);
            }
        }
        return scanner;
    }

    public static String getRouteId(Exchange exchange) {
        String answer = ExchangeHelper.getAtRouteId(exchange);
        if (answer == null) {
            answer = exchange.getFromRouteId();
        }
        return answer;
    }

    public static String getAtRouteId(Exchange exchange) {
        String answer = null;
        Route rc = ExchangeHelper.getRoute(exchange);
        if (rc != null) {
            answer = rc.getRouteId();
        }
        return answer;
    }

    public static Route getRoute(Exchange exchange) {
        UnitOfWork uow = exchange.getUnitOfWork();
        return uow != null ? uow.getRoute() : null;
    }

    public static void setInOutBodyPatternAware(Exchange exchange, Object body) {
        if (exchange.getPattern().isOutCapable()) {
            exchange.getOut().copyFrom(exchange.getIn());
            exchange.getOut().setBody(body);
        } else {
            exchange.getIn().setBody(body);
        }
    }

    public static void setOutBodyPatternAware(Exchange exchange, Object body) {
        if (exchange.getPattern().isOutCapable()) {
            exchange.getOut().copyFrom(exchange.getIn());
            exchange.getOut().setBody(body);
        }
    }
}

