/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.saga;

import java.util.Map;
import java.util.Optional;
import org.apache.camel.Endpoint;
import org.apache.camel.Expression;
import org.apache.camel.util.ObjectHelper;

public class CamelSagaStep {
    private Optional<Endpoint> compensation;
    private Optional<Endpoint> completion;
    private Map<String, Expression> options;
    private Optional<Long> timeoutInMilliseconds;

    public CamelSagaStep(Optional<Endpoint> compensation, Optional<Endpoint> completion, Map<String, Expression> options, Optional<Long> timeoutInMilliseconds) {
        this.compensation = (Optional)ObjectHelper.notNull(compensation, (String)"compensation");
        this.completion = (Optional)ObjectHelper.notNull(completion, (String)"completionCallbacks");
        this.options = (Map)ObjectHelper.notNull(options, (String)"options");
        this.timeoutInMilliseconds = (Optional)ObjectHelper.notNull(timeoutInMilliseconds, (String)"timeoutInMilliseconds");
    }

    public Optional<Endpoint> getCompensation() {
        return this.compensation;
    }

    public Optional<Endpoint> getCompletion() {
        return this.completion;
    }

    public Map<String, Expression> getOptions() {
        return this.options;
    }

    public Optional<Long> getTimeoutInMilliseconds() {
        return this.timeoutInMilliseconds;
    }

    public boolean isEmpty() {
        return !this.compensation.isPresent() && !this.completion.isPresent() && this.options.isEmpty() && !this.timeoutInMilliseconds.isPresent();
    }
}

