/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.support;

import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Stream;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelContextAware;
import org.apache.camel.StreamCache;
import org.apache.camel.StreamCacheException;
import org.apache.camel.spi.BrowsableVariableRepository;
import org.apache.camel.spi.StreamCachingStrategy;
import org.apache.camel.support.service.ServiceSupport;
import org.apache.camel.util.StringHelper;

public final class RouteVariableRepository
extends ServiceSupport
implements BrowsableVariableRepository,
CamelContextAware {
    private final Map<String, Map<String, Object>> routes = new ConcurrentHashMap<String, Map<String, Object>>();
    private CamelContext camelContext;
    private StreamCachingStrategy strategy;

    public CamelContext getCamelContext() {
        return this.camelContext;
    }

    public void setCamelContext(CamelContext camelContext) {
        this.camelContext = camelContext;
    }

    public Object getVariable(String name) {
        String id = StringHelper.before((String)name, (String)":");
        String key = StringHelper.after((String)name, (String)":");
        if (id == null || key == null) {
            throw new IllegalArgumentException("Name must be routeId:name syntax");
        }
        Object answer = null;
        Map<String, Object> variables = this.routes.get(id);
        if (variables != null) {
            answer = variables.get(key);
        }
        if (answer instanceof StreamCache) {
            StreamCache sc = (StreamCache)answer;
            sc.reset();
        }
        return answer;
    }

    public void setVariable(String name, Object value) {
        StreamCache sc;
        String id = StringHelper.before((String)name, (String)":");
        String key = StringHelper.after((String)name, (String)":");
        if (id == null || key == null) {
            throw new IllegalArgumentException("Name must be routeId:name syntax");
        }
        if (value != null && this.strategy != null && (sc = this.convertToStreamCache(value)) != null) {
            value = sc;
        }
        if (value != null) {
            variables = this.routes.computeIfAbsent(id, s -> new ConcurrentHashMap(8));
            variables.put(key, value);
        } else {
            variables = this.routes.get(id);
            if (variables != null) {
                variables.remove(key);
            }
        }
    }

    public boolean hasVariables() {
        for (Map<String, Object> vars : this.routes.values()) {
            if (vars.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public int size() {
        int size = 0;
        for (Map<String, Object> vars : this.routes.values()) {
            size += vars.size();
        }
        return size;
    }

    public Stream<String> names() {
        ArrayList<CallSite> answer = new ArrayList<CallSite>();
        for (String id : this.routes.keySet()) {
            Map<String, Object> values = this.routes.get(id);
            for (Map.Entry<String, Object> e : values.entrySet()) {
                answer.add((CallSite)((Object)(id + ":" + e.getKey())));
            }
        }
        return answer.stream();
    }

    public Map<String, Object> getVariables() {
        ConcurrentHashMap<String, Object> answer = new ConcurrentHashMap<String, Object>();
        for (String id : this.routes.keySet()) {
            Map<String, Object> values = this.routes.get(id);
            for (Map.Entry<String, Object> e : values.entrySet()) {
                answer.put(id + ":" + e.getKey(), e.getValue());
            }
        }
        return answer;
    }

    public void clear() {
        this.routes.clear();
    }

    public String getId() {
        return "route";
    }

    public Object removeVariable(String name) {
        String id = StringHelper.before((String)name, (String)":");
        String key = StringHelper.after((String)name, (String)":");
        if (id == null || key == null) {
            throw new IllegalArgumentException("Name must be routeId:name syntax");
        }
        Map<String, Object> variables = this.routes.get(id);
        if (variables != null) {
            if ("*".equals(key)) {
                variables.clear();
                this.routes.remove(id);
                return null;
            }
            return variables.remove(key);
        }
        return null;
    }

    protected void doInit() throws Exception {
        super.doInit();
        if (this.camelContext != null && this.camelContext.isStreamCaching().booleanValue()) {
            this.strategy = this.camelContext.getStreamCachingStrategy();
        }
    }

    private StreamCache convertToStreamCache(Object body) {
        if (body == null) {
            return null;
        }
        if (body instanceof StreamCache) {
            StreamCache sc = (StreamCache)body;
            sc.reset();
            return sc;
        }
        return this.tryStreamCache(body);
    }

    private StreamCache tryStreamCache(Object body) {
        try {
            return this.strategy.cache(body);
        }
        catch (Exception e) {
            throw new StreamCacheException(body, (Throwable)e);
        }
    }
}

