/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.test;

import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import org.apache.camel.Route;
import org.apache.camel.api.management.ManagedCamelContext;
import org.apache.camel.api.management.mbean.ManagedCamelContextMBean;
import org.apache.camel.api.management.mbean.ManagedProcessorMBean;
import org.apache.camel.api.management.mbean.ManagedRouteMBean;
import org.apache.camel.model.ModelCamelContext;
import org.apache.camel.util.IOHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CamelRouteCoverageDumper {
    private static final Logger LOG = LoggerFactory.getLogger(CamelRouteCoverageDumper.class);

    public void dump(ManagedCamelContextMBean managedCamelContext, ModelCamelContext context, String dumpDir, String dumpFilename, String testClass, String testName, long testTimeTaken) throws Exception {
        this.logCoverageSummary(managedCamelContext, context);
        String routeCoverageAsXml = managedCamelContext.dumpRoutesCoverageAsXml();
        String combined = "<camelRouteCoverage>\n" + this.gatherTestDetailsAsXml(testClass, testName, testTimeTaken) + routeCoverageAsXml + "\n</camelRouteCoverage>";
        File dumpFile = new File(dumpDir);
        dumpFile.mkdirs();
        dumpFile = new File(dumpDir, dumpFilename);
        LOG.info("Dumping route coverage to file: {}", (Object)dumpFile);
        ByteArrayInputStream is = new ByteArrayInputStream(combined.getBytes());
        FileOutputStream os = new FileOutputStream(dumpFile, false);
        IOHelper.copyAndCloseInput((InputStream)is, (OutputStream)os);
        IOHelper.close((Closeable)os);
    }

    private Map<String, List<ManagedProcessorMBean>> findProcessorsForEachRoute(MBeanServer server, ModelCamelContext context) throws MalformedObjectNameException, MBeanException, AttributeNotFoundException, InstanceNotFoundException, ReflectionException {
        String domain = context.getManagementStrategy().getManagementAgent().getMBeanServerDefaultDomain();
        HashMap<String, List<ManagedProcessorMBean>> processorsForRoute = new HashMap<String, List<ManagedProcessorMBean>>();
        ObjectName processorsObjectName = new ObjectName(domain + ":context=" + context.getManagementName() + ",type=processors,name=*");
        Set<ObjectName> objectNames = server.queryNames(processorsObjectName, null);
        for (ObjectName objectName : objectNames) {
            String routeId = server.getAttribute(objectName, "RouteId").toString();
            String name = objectName.getKeyProperty("name");
            name = ObjectName.unquote(name);
            ManagedProcessorMBean managedProcessor = ((ManagedCamelContext)context.getCamelContextExtension().getContextPlugin(ManagedCamelContext.class)).getManagedProcessor(name);
            if (managedProcessor == null) continue;
            if (processorsForRoute.get(routeId) == null) {
                ArrayList<ManagedProcessorMBean> processorsList = new ArrayList<ManagedProcessorMBean>();
                processorsList.add(managedProcessor);
                processorsForRoute.put(routeId, processorsList);
                continue;
            }
            ((List)processorsForRoute.get(routeId)).add(managedProcessor);
        }
        for (Map.Entry entry : processorsForRoute.entrySet()) {
            Collections.sort((List)entry.getValue(), Comparator.comparing(ManagedProcessorMBean::getIndex));
        }
        return processorsForRoute;
    }

    private String gatherTestDetailsAsXml(String testClass, String testName, long timeTaken) {
        StringBuilder sb = new StringBuilder();
        sb.append("<test>\n");
        sb.append("  <class>").append(testClass).append("</class>\n");
        sb.append("  <method>").append(testName).append("</method>\n");
        sb.append("  <time>").append(timeTaken).append("</time>\n");
        sb.append("</test>\n");
        return sb.toString();
    }

    private void logCoverageSummary(ManagedCamelContextMBean managedCamelContext, ModelCamelContext context) throws Exception {
        StringBuilder builder = new StringBuilder("\nCoverage summary\n");
        int routes = managedCamelContext.getTotalRoutes();
        long contextExchangesTotal = managedCamelContext.getExchangesTotal();
        ArrayList<String> uncoveredRoutes = new ArrayList<String>();
        StringBuilder routesSummary = new StringBuilder();
        routesSummary.append("\tProcessor coverage\n");
        MBeanServer server = context.getManagementStrategy().getManagementAgent().getMBeanServer();
        Map<String, List<ManagedProcessorMBean>> processorsForRoute = this.findProcessorsForEachRoute(server, context);
        for (Route route : context.getRoutes()) {
            List<ManagedProcessorMBean> processors;
            ManagedRouteMBean managedRoute = ((ManagedCamelContext)context.getCamelContextExtension().getContextPlugin(ManagedCamelContext.class)).getManagedRoute(route.getId());
            if (managedRoute.getExchangesTotal() == 0L) {
                uncoveredRoutes.add(route.getId());
            }
            long routeCoveragePercentage = Math.round((double)managedRoute.getExchangesTotal() / (double)contextExchangesTotal * 100.0);
            routesSummary.append("\t\tRoute ").append(route.getId()).append(" total: ").append(managedRoute.getExchangesTotal()).append(" (").append(routeCoveragePercentage).append("%)\n");
            if (server == null || (processors = processorsForRoute.get(route.getId())) == null) continue;
            for (ManagedProcessorMBean managedProcessor : processors) {
                String processorId = managedProcessor.getProcessorId();
                long processorExchangesTotal = managedProcessor.getExchangesTotal();
                long processorCoveragePercentage = Math.round((double)processorExchangesTotal / (double)contextExchangesTotal * 100.0);
                routesSummary.append("\t\t\tProcessor ").append(processorId).append(" total: ").append(processorExchangesTotal).append(" (").append(processorCoveragePercentage).append("%)\n");
            }
        }
        int used = routes - uncoveredRoutes.size();
        long contextPercentage = Math.round((double)used / (double)routes * 100.0);
        builder.append("\tRoute coverage: ").append(used).append(" out of ").append(routes).append(" routes used (").append(contextPercentage).append("%)\n");
        builder.append("\t\tCamelContext (").append(managedCamelContext.getCamelId()).append(") total: ").append(contextExchangesTotal).append("\n");
        if (!uncoveredRoutes.isEmpty()) {
            builder.append("\t\tUncovered routes: ").append(String.join((CharSequence)", ", uncoveredRoutes)).append("\n");
        }
        builder.append((CharSequence)routesSummary);
        LOG.info(builder.toString());
    }
}

