/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.test.spring.junit5;

import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.camel.CamelContext;
import org.apache.camel.spring.SpringCamelContext;
import org.apache.camel.test.ExcludingPackageScanClassResolver;
import org.apache.camel.test.junit5.CamelTestSupport;
import org.apache.camel.util.IOHelper;
import org.apache.camel.util.ObjectHelper;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.AbstractApplicationContext;
import org.springframework.context.support.AbstractXmlApplicationContext;
import org.springframework.context.support.GenericApplicationContext;
import org.springframework.core.io.AbstractResource;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;

public abstract class CamelSpringTestSupport
extends CamelTestSupport {
    public static final String TEST_CLASS_NAME_PROPERTY = "testClassName";
    public static final String TEST_CLASS_SIMPLE_NAME_PROPERTY = "testClassSimpleName";
    public static final String TEST_DIRECTORY_PROPERTY = "testDirectory";
    protected static final ThreadLocal<AbstractApplicationContext> THREAD_APP_CONTEXT = new ThreadLocal();
    protected static final Object LOCK = new Object();
    private static final Logger LOG = LoggerFactory.getLogger(CamelSpringTestSupport.class);
    protected AbstractApplicationContext applicationContext;

    protected abstract AbstractApplicationContext createApplicationContext();

    public void postProcessTest() throws Exception {
        if (this.isCreateCamelContextPerClass()) {
            this.applicationContext = THREAD_APP_CONTEXT.get();
        }
        super.postProcessTest();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doPreSetup() throws Exception {
        if (!"true".equalsIgnoreCase(System.getProperty("skipStartingCamelContext"))) {
            Object object = LOCK;
            synchronized (object) {
                SpringCamelContext.setNoStart((boolean)true);
                if (this.isCreateCamelContextPerClass()) {
                    this.applicationContext = THREAD_APP_CONTEXT.get();
                    if (this.applicationContext == null) {
                        this.applicationContext = this.doCreateApplicationContext();
                        THREAD_APP_CONTEXT.set(this.applicationContext);
                    }
                } else {
                    this.applicationContext = this.doCreateApplicationContext();
                }
                SpringCamelContext.setNoStart((boolean)false);
            }
        } else {
            LOG.info("Skipping starting CamelContext as system property skipStartingCamelContext is set to be true.");
        }
    }

    private AbstractApplicationContext doCreateApplicationContext() {
        AbstractApplicationContext context = this.createApplicationContext();
        Assertions.assertNotNull((Object)context, (String)"Should have created a valid Spring application context");
        String[] profiles = this.activeProfiles();
        if (profiles != null && profiles.length > 0) {
            if (context.isActive()) {
                throw new IllegalStateException("Cannot active profiles: " + Arrays.asList(profiles) + " on active Spring application context: " + context + ". The code in your createApplicationContext() method should be adjusted to create the application context with refresh = false as parameter");
            }
            LOG.info("Spring activating profiles: {}", Arrays.asList(profiles));
            context.getEnvironment().setActiveProfiles(profiles);
        }
        if (!context.isActive()) {
            context.refresh();
        }
        return context;
    }

    @AfterEach
    public void tearDown() throws Exception {
        super.tearDown();
        if (!this.isCreateCamelContextPerClass()) {
            IOHelper.close((Closeable)this.applicationContext);
            this.applicationContext = null;
        }
    }

    public void doPostTearDown() throws Exception {
        super.doPostTearDown();
        if (THREAD_APP_CONTEXT.get() != null) {
            IOHelper.close((Closeable)((Closeable)THREAD_APP_CONTEXT.get()));
            THREAD_APP_CONTEXT.remove();
        }
    }

    protected ApplicationContext getRouteExcludingApplicationContext() {
        GenericApplicationContext routeExcludingContext = new GenericApplicationContext();
        routeExcludingContext.registerBeanDefinition("excludingResolver", (BeanDefinition)new RootBeanDefinition(ExcludingPackageScanClassResolver.class));
        routeExcludingContext.refresh();
        ExcludingPackageScanClassResolver excludingResolver = (ExcludingPackageScanClassResolver)routeExcludingContext.getBean("excludingResolver", ExcludingPackageScanClassResolver.class);
        List<Class<?>> excluded = Arrays.asList(this.excludeRoutes());
        excludingResolver.setExcludedClasses(new HashSet(excluded));
        return routeExcludingContext;
    }

    protected Class<?>[] excludeRoutes() {
        Class[] classArray;
        Class<?> excludedRoute = this.excludeRoute();
        if (excludedRoute != null) {
            Class[] classArray2 = new Class[1];
            classArray = classArray2;
            classArray2[0] = excludedRoute;
        } else {
            classArray = new Class[]{};
        }
        return classArray;
    }

    protected Class<?> excludeRoute() {
        return null;
    }

    public <T> T getMandatoryBean(Class<T> type, String name) {
        Object value = this.applicationContext.getBean(name);
        Assertions.assertNotNull((Object)value, (String)("No spring bean found for name <" + name + ">"));
        if (type.isInstance(value)) {
            return type.cast(value);
        }
        Assertions.fail((String)("Spring bean <" + name + "> is not an instanceof " + type.getName() + " but is of type " + ObjectHelper.className((Object)value)));
        return null;
    }

    protected String[] activeProfiles() {
        return null;
    }

    protected CamelContext createCamelContext() throws Exception {
        return SpringCamelContext.springCamelContext((ApplicationContext)this.applicationContext, (boolean)false);
    }

    public AbstractXmlApplicationContext newAppContext(String configLocation) throws BeansException {
        return CamelSpringTestSupport.newAppContext(configLocation, ((Object)((Object)this)).getClass(), this.getTranslationProperties());
    }

    public AbstractXmlApplicationContext newAppContext(String ... configLocations) throws BeansException {
        return CamelSpringTestSupport.newAppContext(configLocations, ((Object)((Object)this)).getClass(), this.getTranslationProperties());
    }

    protected Map<String, String> getTranslationProperties() {
        return CamelSpringTestSupport.getTranslationProperties(((Object)((Object)this)).getClass());
    }

    static Map<String, String> getTranslationProperties(Class<?> testClass) {
        HashMap<String, String> props = new HashMap<String, String>();
        props.put(TEST_CLASS_NAME_PROPERTY, testClass.getName());
        props.put(TEST_CLASS_SIMPLE_NAME_PROPERTY, testClass.getSimpleName());
        Path testDir = Paths.get("target", "data", testClass.getSimpleName());
        props.put(TEST_DIRECTORY_PROPERTY, testDir.toString());
        return props;
    }

    public static AbstractXmlApplicationContext newAppContext(String configLocation, Class<?> clazz) {
        Map<String, String> props = CamelSpringTestSupport.getTranslationProperties(clazz);
        return CamelSpringTestSupport.newAppContext(configLocation, clazz, props);
    }

    public static MyXmlApplicationContext newAppContext(String configLocation, Class<?> clazz, Map<String, String> props) {
        return new MyXmlApplicationContext(configLocation, clazz, props);
    }

    public static MyXmlApplicationContext newAppContext(String[] configLocations, Class<?> clazz, Map<String, String> props) {
        return new MyXmlApplicationContext(configLocations, clazz, props);
    }

    public static class MyXmlApplicationContext
    extends AbstractXmlApplicationContext {
        private final Resource[] configResources;

        public MyXmlApplicationContext(String configLocation, Class<?> clazz, Map<String, String> properties) {
            this(new String[]{configLocation}, clazz, properties);
        }

        public MyXmlApplicationContext(String[] configLocations, Class<?> clazz, Map<String, String> properties) {
            super(null);
            this.configResources = (Resource[])Stream.of(configLocations).map(loc -> new TranslatedResource((Resource)new ClassPathResource(loc, clazz), properties)).toArray(Resource[]::new);
            this.refresh();
        }

        protected Resource[] getConfigResources() {
            return this.configResources;
        }
    }

    public static class TranslatedResource
    extends AbstractResource {
        private final Resource delegate;
        private final Map<String, String> properties;

        public TranslatedResource(Resource delegate, Map<String, String> properties) {
            this.delegate = delegate;
            this.properties = properties;
        }

        public String getDescription() {
            return this.delegate.getDescription();
        }

        public InputStream getInputStream() throws IOException {
            if (this.properties.size() > 0) {
                StringWriter sw = new StringWriter();
                try (InputStreamReader r = new InputStreamReader(this.delegate.getInputStream(), StandardCharsets.UTF_8);){
                    int l;
                    char[] buf = new char[32768];
                    while ((l = r.read(buf)) > 0) {
                        sw.write(buf, 0, l);
                    }
                }
                String before = sw.toString();
                String p = this.properties.keySet().stream().map(Pattern::quote).collect(Collectors.joining("|", Pattern.quote("{{") + "(", ")" + Pattern.quote("}}")));
                Matcher m = Pattern.compile(p).matcher(before);
                StringBuilder sb = new StringBuilder(before.length());
                while (m.find()) {
                    m.appendReplacement(sb, this.properties.get(m.group(1)));
                }
                m.appendTail(sb);
                String after = sb.toString();
                return new ByteArrayInputStream(after.getBytes(StandardCharsets.UTF_8));
            }
            return this.delegate.getInputStream();
        }
    }
}

