/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.test.spring;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.LinkedList;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import org.apache.camel.component.properties.PropertiesComponent;
import org.apache.camel.impl.DefaultDebugger;
import org.apache.camel.impl.InterceptSendToMockEndpointStrategy;
import org.apache.camel.spi.Breakpoint;
import org.apache.camel.spi.Debugger;
import org.apache.camel.spi.EndpointStrategy;
import org.apache.camel.spring.SpringCamelContext;
import org.apache.camel.test.spring.CamelSpringTestHelper;
import org.apache.camel.test.spring.DisableJmx;
import org.apache.camel.test.spring.MockEndpoints;
import org.apache.camel.test.spring.MockEndpointsAndSkip;
import org.apache.camel.test.spring.ProvidesBreakpoint;
import org.apache.camel.test.spring.ShutdownTimeout;
import org.apache.camel.test.spring.UseAdviceWith;
import org.apache.camel.test.spring.UseOverridePropertiesWithPropertiesComponent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.AnnotationConfigUtils;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.test.context.MergedContextConfiguration;
import org.springframework.test.context.support.DelegatingSmartContextLoader;

public class CamelSpringDelegatingTestContextLoader
extends DelegatingSmartContextLoader {
    protected final Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ApplicationContext loadContext(MergedContextConfiguration mergedConfig) throws Exception {
        Class<?> testClass = this.getTestClass();
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Loading ApplicationContext for merged context configuration [{}].", (Object)mergedConfig);
        }
        this.handleDisableJmx(null, testClass);
        try {
            SpringCamelContext.setNoStart((boolean)true);
            ConfigurableApplicationContext context = (ConfigurableApplicationContext)super.loadContext(mergedConfig);
            SpringCamelContext.setNoStart((boolean)false);
            ApplicationContext applicationContext = this.loadContext(context, testClass);
            return applicationContext;
        }
        finally {
            this.cleanup(testClass);
        }
    }

    public ApplicationContext loadContext(ConfigurableApplicationContext context, Class<?> testClass) throws Exception {
        AnnotationConfigUtils.registerAnnotationConfigProcessors((BeanDefinitionRegistry)((BeanDefinitionRegistry)context));
        this.logger.info(">>>> I was here <<<<<");
        this.handleProvidesBreakpoint(context, testClass);
        this.handleShutdownTimeout(context, testClass);
        this.handleMockEndpoints(context, testClass);
        this.handleMockEndpointsAndSkip(context, testClass);
        this.handleUseOverridePropertiesWithPropertiesComponent(context, testClass);
        this.handleCamelContextStartup(context, testClass);
        return context;
    }

    protected void cleanup(Class<?> testClass) {
        SpringCamelContext.setNoStart((boolean)false);
        if (testClass.isAnnotationPresent(DisableJmx.class)) {
            if (CamelSpringTestHelper.getOriginalJmxDisabled() == null) {
                System.clearProperty("org.apache.camel.jmx.disabled");
            } else {
                System.setProperty("org.apache.camel.jmx.disabled", CamelSpringTestHelper.getOriginalJmxDisabled());
            }
        }
    }

    protected void handleDisableJmx(ConfigurableApplicationContext context, Class<?> testClass) {
        CamelSpringTestHelper.setOriginalJmxDisabledValue(System.getProperty("org.apache.camel.jmx.disabled"));
        if (testClass.isAnnotationPresent(DisableJmx.class)) {
            if (testClass.getAnnotation(DisableJmx.class).value()) {
                this.logger.info("Disabling Camel JMX globally as DisableJmx annotation was found and disableJmx is set to true.");
                System.setProperty("org.apache.camel.jmx.disabled", "true");
            } else {
                this.logger.info("Enabling Camel JMX as DisableJmx annotation was found and disableJmx is set to false.");
                System.clearProperty("org.apache.camel.jmx.disabled");
            }
        } else {
            this.logger.info("Disabling Camel JMX globally for tests by default. Use the DisableJMX annotation to override the default setting.");
            System.setProperty("org.apache.camel.jmx.disabled", "true");
        }
    }

    protected void handleProvidesBreakpoint(ConfigurableApplicationContext context, Class<?> testClass) throws Exception {
        Collection<Method> methods = CamelSpringTestHelper.getAllMethods(testClass);
        final LinkedList<Breakpoint> breakpoints = new LinkedList<Breakpoint>();
        for (Method method : methods) {
            if (AnnotationUtils.findAnnotation((Method)method, ProvidesBreakpoint.class) == null) continue;
            Class<?>[] argTypes = method.getParameterTypes();
            if (argTypes.length != 0) {
                throw new IllegalArgumentException("Method [" + method.getName() + "] is annotated with ProvidesBreakpoint but is not a no-argument method.");
            }
            if (!Breakpoint.class.isAssignableFrom(method.getReturnType())) {
                throw new IllegalArgumentException("Method [" + method.getName() + "] is annotated with ProvidesBreakpoint but does not return a Breakpoint.");
            }
            if (!Modifier.isStatic(method.getModifiers())) {
                throw new IllegalArgumentException("Method [" + method.getName() + "] is annotated with ProvidesBreakpoint but is not static.");
            }
            if (!Modifier.isPublic(method.getModifiers())) {
                throw new IllegalArgumentException("Method [" + method.getName() + "] is annotated with ProvidesBreakpoint but is not public.");
            }
            try {
                breakpoints.add((Breakpoint)method.invoke(null, new Object[0]));
            }
            catch (Exception e) {
                throw new RuntimeException("Method [" + method.getName() + "] threw exception during evaluation.", e);
            }
        }
        if (breakpoints.size() != 0) {
            CamelSpringTestHelper.doToSpringCamelContexts((ApplicationContext)context, new CamelSpringTestHelper.DoToSpringCamelContextsStrategy(){

                @Override
                public void execute(String contextName, SpringCamelContext camelContext) throws Exception {
                    Debugger debugger = camelContext.getDebugger();
                    if (debugger == null) {
                        debugger = new DefaultDebugger();
                        camelContext.setDebugger(debugger);
                    }
                    for (Breakpoint breakpoint : breakpoints) {
                        CamelSpringDelegatingTestContextLoader.this.logger.info("Adding Breakpoint [{}] to CamelContext with name [{}].", (Object)breakpoint, (Object)contextName);
                        debugger.addBreakpoint(breakpoint);
                    }
                }
            });
        }
    }

    protected void handleShutdownTimeout(ConfigurableApplicationContext context, Class<?> testClass) throws Exception {
        TimeUnit shutdownTimeUnit;
        int shutdownTimeout;
        if (testClass.isAnnotationPresent(ShutdownTimeout.class)) {
            shutdownTimeout = testClass.getAnnotation(ShutdownTimeout.class).value();
            shutdownTimeUnit = testClass.getAnnotation(ShutdownTimeout.class).timeUnit();
        } else {
            shutdownTimeout = 10;
            shutdownTimeUnit = TimeUnit.SECONDS;
        }
        CamelSpringTestHelper.doToSpringCamelContexts((ApplicationContext)context, new CamelSpringTestHelper.DoToSpringCamelContextsStrategy(){

            @Override
            public void execute(String contextName, SpringCamelContext camelContext) throws Exception {
                CamelSpringDelegatingTestContextLoader.this.logger.info("Setting shutdown timeout to [{} {}] on CamelContext with name [{}].", new Object[]{shutdownTimeout, shutdownTimeUnit, contextName});
                camelContext.getShutdownStrategy().setTimeout((long)shutdownTimeout);
                camelContext.getShutdownStrategy().setTimeUnit(shutdownTimeUnit);
            }
        });
    }

    protected void handleMockEndpoints(ConfigurableApplicationContext context, Class<?> testClass) throws Exception {
        if (testClass.isAnnotationPresent(MockEndpoints.class)) {
            final String mockEndpoints = testClass.getAnnotation(MockEndpoints.class).value();
            CamelSpringTestHelper.doToSpringCamelContexts((ApplicationContext)context, new CamelSpringTestHelper.DoToSpringCamelContextsStrategy(){

                @Override
                public void execute(String contextName, SpringCamelContext camelContext) throws Exception {
                    CamelSpringDelegatingTestContextLoader.this.logger.info("Enabling auto mocking of endpoints matching pattern [{}] on CamelContext with name [{}].", (Object)mockEndpoints, (Object)contextName);
                    camelContext.addRegisterEndpointCallback((EndpointStrategy)new InterceptSendToMockEndpointStrategy(mockEndpoints));
                }
            });
        }
    }

    protected void handleMockEndpointsAndSkip(ConfigurableApplicationContext context, Class<?> testClass) throws Exception {
        if (testClass.isAnnotationPresent(MockEndpointsAndSkip.class)) {
            final String mockEndpoints = testClass.getAnnotation(MockEndpointsAndSkip.class).value();
            CamelSpringTestHelper.doToSpringCamelContexts((ApplicationContext)context, new CamelSpringTestHelper.DoToSpringCamelContextsStrategy(){

                @Override
                public void execute(String contextName, SpringCamelContext camelContext) throws Exception {
                    String mockEndpointsValue = camelContext.resolvePropertyPlaceholders(mockEndpoints);
                    CamelSpringDelegatingTestContextLoader.this.logger.info("Enabling auto mocking and skipping of endpoints matching pattern [{}] on CamelContext with name [{}].", (Object)mockEndpointsValue, (Object)contextName);
                    camelContext.addRegisterEndpointCallback((EndpointStrategy)new InterceptSendToMockEndpointStrategy(mockEndpointsValue, true));
                }
            });
        }
    }

    protected void handleUseOverridePropertiesWithPropertiesComponent(ConfigurableApplicationContext context, Class<?> testClass) throws Exception {
        Collection<Method> methods = CamelSpringTestHelper.getAllMethods(testClass);
        final LinkedList<Properties> properties = new LinkedList<Properties>();
        for (Method method : methods) {
            if (AnnotationUtils.findAnnotation((Method)method, UseOverridePropertiesWithPropertiesComponent.class) == null) continue;
            Class<?>[] argTypes = method.getParameterTypes();
            if (argTypes.length > 0) {
                throw new IllegalArgumentException("Method [" + method.getName() + "] is annotated with UseOverridePropertiesWithPropertiesComponent but is not a no-argument method.");
            }
            if (!Properties.class.isAssignableFrom(method.getReturnType())) {
                throw new IllegalArgumentException("Method [" + method.getName() + "] is annotated with UseOverridePropertiesWithPropertiesComponent but does not return a java.util.Properties.");
            }
            if (!Modifier.isStatic(method.getModifiers())) {
                throw new IllegalArgumentException("Method [" + method.getName() + "] is annotated with UseOverridePropertiesWithPropertiesComponent but is not static.");
            }
            if (!Modifier.isPublic(method.getModifiers())) {
                throw new IllegalArgumentException("Method [" + method.getName() + "] is annotated with UseOverridePropertiesWithPropertiesComponent but is not public.");
            }
            try {
                properties.add((Properties)method.invoke(null, new Object[0]));
            }
            catch (Exception e) {
                throw new RuntimeException("Method [" + method.getName() + "] threw exception during evaluation.", e);
            }
        }
        if (properties.size() != 0) {
            CamelSpringTestHelper.doToSpringCamelContexts((ApplicationContext)context, new CamelSpringTestHelper.DoToSpringCamelContextsStrategy(){

                @Override
                public void execute(String contextName, SpringCamelContext camelContext) throws Exception {
                    PropertiesComponent pc = (PropertiesComponent)camelContext.getComponent("properties", PropertiesComponent.class);
                    Properties extra = new Properties();
                    for (Properties prop : properties) {
                        extra.putAll((Map<?, ?>)prop);
                    }
                    if (!extra.isEmpty()) {
                        CamelSpringDelegatingTestContextLoader.this.logger.info("Using {} properties to override any existing properties on the PropertiesComponent on CamelContext with name [{}].", (Object)extra.size(), (Object)contextName);
                        pc.setOverrideProperties(extra);
                    }
                }
            });
        }
    }

    protected void handleCamelContextStartup(ConfigurableApplicationContext context, Class<?> testClass) throws Exception {
        boolean skip = "true".equalsIgnoreCase(System.getProperty("skipStartingCamelContext"));
        if (skip) {
            this.logger.info("Skipping starting CamelContext(s) as system property skipStartingCamelContext is set to be true.");
        } else if (testClass.isAnnotationPresent(UseAdviceWith.class)) {
            if (testClass.getAnnotation(UseAdviceWith.class).value()) {
                this.logger.info("Skipping starting CamelContext(s) as UseAdviceWith annotation was found and isUseAdviceWith is set to true.");
                skip = true;
            } else {
                this.logger.info("Starting CamelContext(s) as UseAdviceWith annotation was found, but isUseAdviceWith is set to false.");
                skip = false;
            }
        }
        if (!skip) {
            CamelSpringTestHelper.doToSpringCamelContexts((ApplicationContext)context, new CamelSpringTestHelper.DoToSpringCamelContextsStrategy(){

                @Override
                public void execute(String contextName, SpringCamelContext camelContext) throws Exception {
                    CamelSpringDelegatingTestContextLoader.this.logger.info("Starting CamelContext with name [{}].", (Object)contextName);
                    camelContext.start();
                }
            });
        }
    }

    protected Class<?> getTestClass() {
        return CamelSpringTestHelper.getTestClass();
    }
}

