/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.test.spring;

import org.apache.camel.util.StopWatch;
import org.apache.camel.util.TimeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.test.context.TestContext;
import org.springframework.test.context.support.AbstractTestExecutionListener;

public class StopWatchTestExecutionListener
extends AbstractTestExecutionListener {
    protected static ThreadLocal<StopWatch> threadStopWatch = new ThreadLocal();

    public static StopWatch getStopWatch() {
        return threadStopWatch.get();
    }

    public void beforeTestMethod(TestContext testContext) throws Exception {
        StopWatch stopWatch = new StopWatch();
        threadStopWatch.set(stopWatch);
    }

    public void afterTestMethod(TestContext testContext) throws Exception {
        StopWatch watch = threadStopWatch.get();
        if (watch != null) {
            long time = watch.taken();
            Logger log = LoggerFactory.getLogger((Class)testContext.getTestClass());
            log.info("********************************************************************************");
            log.info("Testing done: " + testContext.getTestMethod().getName() + "(" + testContext.getTestClass().getName() + ")");
            log.info("Took: " + TimeUtils.printDuration((double)time) + " (" + time + " millis)");
            log.info("********************************************************************************");
            threadStopWatch.remove();
        }
    }
}

