/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.test.spring;

import java.io.Closeable;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import org.apache.camel.CamelContext;
import org.apache.camel.spring.SpringCamelContext;
import org.apache.camel.test.ExcludingPackageScanClassResolver;
import org.apache.camel.test.junit4.CamelTestSupport;
import org.apache.camel.util.IOHelper;
import org.apache.camel.util.ObjectHelper;
import org.junit.After;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.AbstractApplicationContext;
import org.springframework.context.support.GenericApplicationContext;

public abstract class CamelSpringTestSupport
extends CamelTestSupport {
    protected static ThreadLocal<AbstractApplicationContext> threadAppContext = new ThreadLocal();
    protected static Object lock = new Object();
    protected AbstractApplicationContext applicationContext;

    protected abstract AbstractApplicationContext createApplicationContext();

    public void postProcessTest() throws Exception {
        if (this.isCreateCamelContextPerClass()) {
            this.applicationContext = threadAppContext.get();
        }
        super.postProcessTest();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doPreSetup() throws Exception {
        if (!"true".equalsIgnoreCase(System.getProperty("skipStartingCamelContext"))) {
            Object object = lock;
            synchronized (object) {
                SpringCamelContext.setNoStart((boolean)true);
                if (this.isCreateCamelContextPerClass()) {
                    this.applicationContext = threadAppContext.get();
                    if (this.applicationContext == null) {
                        this.applicationContext = this.doCreateApplicationContext();
                        threadAppContext.set(this.applicationContext);
                    }
                } else {
                    this.applicationContext = this.doCreateApplicationContext();
                }
                SpringCamelContext.setNoStart((boolean)false);
            }
        } else {
            this.log.info("Skipping starting CamelContext as system property skipStartingCamelContext is set to be true.");
        }
    }

    private AbstractApplicationContext doCreateApplicationContext() {
        AbstractApplicationContext context = this.createApplicationContext();
        CamelSpringTestSupport.assertNotNull((String)"Should have created a valid Spring application context", (Object)context);
        String[] profiles = this.activeProfiles();
        if (profiles != null && profiles.length > 0) {
            if (context.isActive()) {
                throw new IllegalStateException("Cannot active profiles: " + Arrays.asList(profiles) + " on active Spring application context: " + context + ". The code in your createApplicationContext() method should be adjusted to create the application context with refresh = false as parameter");
            }
            this.log.info("Spring activating profiles: {}", Arrays.asList(profiles));
            context.getEnvironment().setActiveProfiles(profiles);
        }
        if (!context.isActive()) {
            context.refresh();
        }
        return context;
    }

    @After
    public void tearDown() throws Exception {
        super.tearDown();
        if (!this.isCreateCamelContextPerClass()) {
            IOHelper.close((Closeable)this.applicationContext);
            this.applicationContext = null;
        }
    }

    public void doPostTearDown() throws Exception {
        super.doPostTearDown();
        if (threadAppContext.get() != null) {
            IOHelper.close((Closeable)((Closeable)threadAppContext.get()));
            threadAppContext.remove();
        }
    }

    protected ApplicationContext getRouteExcludingApplicationContext() {
        GenericApplicationContext routeExcludingContext = new GenericApplicationContext();
        routeExcludingContext.registerBeanDefinition("excludingResolver", (BeanDefinition)new RootBeanDefinition(ExcludingPackageScanClassResolver.class));
        routeExcludingContext.refresh();
        ExcludingPackageScanClassResolver excludingResolver = (ExcludingPackageScanClassResolver)routeExcludingContext.getBean("excludingResolver", ExcludingPackageScanClassResolver.class);
        List<Class<?>> excluded = Arrays.asList(this.excludeRoutes());
        excludingResolver.setExcludedClasses(new HashSet(excluded));
        return routeExcludingContext;
    }

    protected Class<?>[] excludeRoutes() {
        Class[] classArray;
        Class<?> excludedRoute = this.excludeRoute();
        if (excludedRoute != null) {
            Class[] classArray2 = new Class[1];
            classArray = classArray2;
            classArray2[0] = excludedRoute;
        } else {
            classArray = new Class[]{};
        }
        return classArray;
    }

    protected Class<?> excludeRoute() {
        return null;
    }

    public <T> T getMandatoryBean(Class<T> type, String name) {
        Object value = this.applicationContext.getBean(name);
        CamelSpringTestSupport.assertNotNull((String)("No spring bean found for name <" + name + ">"), (Object)value);
        if (type.isInstance(value)) {
            return type.cast(value);
        }
        CamelSpringTestSupport.fail((String)("Spring bean <" + name + "> is not an instanceof " + type.getName() + " but is of type " + ObjectHelper.className((Object)value)));
        return null;
    }

    protected String[] activeProfiles() {
        return null;
    }

    protected CamelContext createCamelContext() throws Exception {
        return SpringCamelContext.springCamelContext((ApplicationContext)this.applicationContext, (boolean)false);
    }
}

