/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.test.junit4;

import java.io.InputStream;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import javax.naming.Context;
import javax.naming.InitialContext;
import org.apache.camel.CamelContext;
import org.apache.camel.ConsumerTemplate;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.Message;
import org.apache.camel.Predicate;
import org.apache.camel.Processor;
import org.apache.camel.ProducerTemplate;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.Service;
import org.apache.camel.ServiceStatus;
import org.apache.camel.builder.AdviceWithRouteBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.component.properties.PropertiesComponent;
import org.apache.camel.impl.BreakpointSupport;
import org.apache.camel.impl.DefaultCamelBeanPostProcessor;
import org.apache.camel.impl.DefaultCamelContext;
import org.apache.camel.impl.DefaultDebugger;
import org.apache.camel.impl.InterceptSendToMockEndpointStrategy;
import org.apache.camel.impl.JndiRegistry;
import org.apache.camel.model.ModelCamelContext;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.spi.Breakpoint;
import org.apache.camel.spi.Debugger;
import org.apache.camel.spi.EndpointStrategy;
import org.apache.camel.spi.Language;
import org.apache.camel.spi.Registry;
import org.apache.camel.test.junit4.TestSupport;
import org.apache.camel.util.StopWatch;
import org.apache.camel.util.TimeUtils;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Before;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class CamelTestSupport
extends TestSupport {
    private static final Logger LOG = LoggerFactory.getLogger(CamelTestSupport.class);
    private static final ThreadLocal<Boolean> INIT = new ThreadLocal();
    private static ThreadLocal<ModelCamelContext> threadCamelContext = new ThreadLocal();
    private static ThreadLocal<ProducerTemplate> threadTemplate = new ThreadLocal();
    private static ThreadLocal<ConsumerTemplate> threadConsumer = new ThreadLocal();
    private static ThreadLocal<Service> threadService = new ThreadLocal();
    protected volatile ModelCamelContext context;
    protected volatile ProducerTemplate template;
    protected volatile ConsumerTemplate consumer;
    protected volatile Service camelContextService;
    private boolean useRouteBuilder = true;
    private final DebugBreakpoint breakpoint = new DebugBreakpoint();
    private final StopWatch watch = new StopWatch();
    private final Map<String, String> fromEndpoints = new HashMap<String, String>();

    public boolean isUseRouteBuilder() {
        return this.useRouteBuilder;
    }

    public void setUseRouteBuilder(boolean useRouteBuilder) {
        this.useRouteBuilder = useRouteBuilder;
    }

    public boolean isUseAdviceWith() {
        return false;
    }

    public boolean isCreateCamelContextPerClass() {
        return false;
    }

    public String isMockEndpoints() {
        return null;
    }

    public String isMockEndpointsAndSkip() {
        return null;
    }

    public void replaceRouteFromWith(String routeId, String fromEndpoint) {
        this.fromEndpoints.put(routeId, fromEndpoint);
    }

    public boolean isUseDebugger() {
        return false;
    }

    public Service getCamelContextService() {
        return this.camelContextService;
    }

    public Service camelContextService() {
        return this.camelContextService;
    }

    public CamelContext context() {
        return this.context;
    }

    public ProducerTemplate template() {
        return this.template;
    }

    public ConsumerTemplate consumer() {
        return this.consumer;
    }

    public void setCamelContextService(Service service) {
        this.camelContextService = service;
        threadService.set(this.camelContextService);
    }

    @Before
    public void setUp() throws Exception {
        this.log.info("********************************************************************************");
        this.log.info("Testing: " + this.getTestMethodName() + "(" + ((Object)((Object)this)).getClass().getName() + ")");
        this.log.info("********************************************************************************");
        if (this.isCreateCamelContextPerClass()) {
            boolean first;
            boolean bl = first = INIT.get() == null;
            if (first) {
                this.doPreSetup();
                this.doSetUp();
                this.doPostSetup();
            } else {
                this.postProcessTest();
                this.resetMocks();
            }
        } else {
            this.doPreSetup();
            this.doSetUp();
            this.doPostSetup();
        }
        this.watch.restart();
    }

    protected void doPreSetup() throws Exception {
    }

    protected void doPostSetup() throws Exception {
    }

    private void doSetUp() throws Exception {
        Boolean ignore;
        this.log.debug("setUp test");
        if (!this.useJmx()) {
            this.disableJMX();
        } else {
            this.enableJMX();
        }
        this.context = (ModelCamelContext)this.createCamelContext();
        threadCamelContext.set(this.context);
        CamelTestSupport.assertNotNull((String)"No context found!", (Object)this.context);
        this.context.getShutdownStrategy().setTimeout((long)this.getShutdownTimeout());
        if (this.isUseDebugger()) {
            if (this.context.getStatus().equals((Object)ServiceStatus.Started)) {
                this.log.info("Cannot setting the Debugger to the starting CamelContext, stop the CamelContext now.");
                this.context.stop();
            }
            this.context.setDebugger((Debugger)new DefaultDebugger());
            this.context.getDebugger().addBreakpoint((Breakpoint)this.breakpoint);
        }
        this.template = this.context.createProducerTemplate();
        this.template.start();
        this.consumer = this.context.createConsumerTemplate();
        this.consumer.start();
        threadTemplate.set(this.template);
        threadConsumer.set(this.consumer);
        String pattern = this.isMockEndpoints();
        if (pattern != null) {
            this.context.addRegisterEndpointCallback((EndpointStrategy)new InterceptSendToMockEndpointStrategy(pattern));
        }
        if ((pattern = this.isMockEndpointsAndSkip()) != null) {
            this.context.addRegisterEndpointCallback((EndpointStrategy)new InterceptSendToMockEndpointStrategy(pattern, true));
        }
        PropertiesComponent pc = (PropertiesComponent)this.context.getComponent("properties", PropertiesComponent.class);
        Properties extra = this.useOverridePropertiesWithPropertiesComponent();
        if (extra != null && !extra.isEmpty()) {
            pc.setOverrideProperties(extra);
        }
        if ((ignore = this.ignoreMissingLocationWithPropertiesComponent()) != null) {
            pc.setIgnoreMissingLocation(ignore.booleanValue());
        }
        this.postProcessTest();
        if (this.isUseRouteBuilder()) {
            RouteBuilder[] builders;
            for (RouteBuilder builder : builders = this.createRouteBuilders()) {
                this.log.debug("Using created route builder: " + builder);
                this.context.addRoutes((RoutesBuilder)builder);
            }
            this.replaceFromEndpoints();
            boolean skip = "true".equalsIgnoreCase(System.getProperty("skipStartingCamelContext"));
            if (skip) {
                this.log.info("Skipping starting CamelContext as system property skipStartingCamelContext is set to be true.");
            } else if (this.isUseAdviceWith()) {
                this.log.info("Skipping starting CamelContext as isUseAdviceWith is set to true.");
            } else {
                this.startCamelContext();
            }
        } else {
            this.replaceFromEndpoints();
            this.log.debug("Using route builder from the created context: " + this.context);
        }
        this.log.debug("Routing Rules are: " + this.context.getRoutes());
        this.assertValidContext((CamelContext)this.context);
        INIT.set(true);
    }

    private void replaceFromEndpoints() throws Exception {
        for (final Map.Entry<String, String> entry : this.fromEndpoints.entrySet()) {
            this.context.getRouteDefinition(entry.getKey()).adviceWith(this.context, (RouteBuilder)new AdviceWithRouteBuilder(){

                public void configure() throws Exception {
                    this.replaceFromWith((String)entry.getValue());
                }
            });
        }
    }

    @After
    public void tearDown() throws Exception {
        long time = this.watch.stop();
        this.log.info("********************************************************************************");
        this.log.info("Testing done: " + this.getTestMethodName() + "(" + ((Object)((Object)this)).getClass().getName() + ")");
        this.log.info("Took: " + TimeUtils.printDuration((double)time) + " (" + time + " millis)");
        this.log.info("********************************************************************************");
        if (this.isCreateCamelContextPerClass()) {
            return;
        }
        LOG.debug("tearDown test");
        CamelTestSupport.doStopTemplates(this.consumer, this.template);
        CamelTestSupport.doStopCamelContext((CamelContext)this.context, this.camelContextService);
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        INIT.remove();
        LOG.debug("tearDownAfterClass test");
        CamelTestSupport.doStopTemplates(threadConsumer.get(), threadTemplate.get());
        CamelTestSupport.doStopCamelContext((CamelContext)threadCamelContext.get(), threadService.get());
    }

    protected int getShutdownTimeout() {
        return 10;
    }

    protected boolean useJmx() {
        return false;
    }

    @Deprecated
    protected boolean isLazyLoadingTypeConverter() {
        return false;
    }

    protected Properties useOverridePropertiesWithPropertiesComponent() {
        return null;
    }

    protected Boolean ignoreMissingLocationWithPropertiesComponent() {
        return null;
    }

    protected void postProcessTest() throws Exception {
        this.context = threadCamelContext.get();
        this.template = threadTemplate.get();
        this.consumer = threadConsumer.get();
        this.camelContextService = threadService.get();
        this.applyCamelPostProcessor();
    }

    protected void applyCamelPostProcessor() throws Exception {
        DefaultCamelBeanPostProcessor processor = new DefaultCamelBeanPostProcessor((CamelContext)this.context);
        processor.postProcessBeforeInitialization((Object)this, ((Object)((Object)this)).getClass().getName());
        processor.postProcessAfterInitialization((Object)this, ((Object)((Object)this)).getClass().getName());
    }

    protected void stopCamelContext() throws Exception {
        CamelTestSupport.doStopCamelContext((CamelContext)this.context, this.camelContextService);
    }

    private static void doStopCamelContext(CamelContext context, Service camelContextService) throws Exception {
        if (camelContextService != null) {
            if (camelContextService == threadService.get()) {
                threadService.remove();
            }
            camelContextService.stop();
        } else if (context != null) {
            if (context == threadCamelContext.get()) {
                threadCamelContext.remove();
            }
            context.stop();
        }
    }

    private static void doStopTemplates(ConsumerTemplate consumer, ProducerTemplate template) throws Exception {
        if (consumer != null) {
            if (consumer == threadConsumer.get()) {
                threadConsumer.remove();
            }
            consumer.stop();
        }
        if (template != null) {
            if (template == threadTemplate.get()) {
                threadTemplate.remove();
            }
            template.stop();
        }
    }

    protected void startCamelContext() throws Exception {
        if (this.camelContextService != null) {
            this.camelContextService.start();
        } else if (this.context instanceof DefaultCamelContext) {
            DefaultCamelContext defaultCamelContext = (DefaultCamelContext)this.context;
            if (!defaultCamelContext.isStarted()) {
                defaultCamelContext.start();
            }
        } else {
            this.context.start();
        }
    }

    protected CamelContext createCamelContext() throws Exception {
        DefaultCamelContext context = new DefaultCamelContext((Registry)this.createRegistry());
        context.setLazyLoadTypeConverters(Boolean.valueOf(this.isLazyLoadingTypeConverter()));
        return context;
    }

    protected JndiRegistry createRegistry() throws Exception {
        return new JndiRegistry(this.createJndiContext());
    }

    protected Context createJndiContext() throws Exception {
        Properties properties = new Properties();
        InputStream in = ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream("jndi.properties");
        if (in != null) {
            this.log.debug("Using jndi.properties from classpath root");
            properties.load(in);
        } else {
            properties.put("java.naming.factory.initial", "org.apache.camel.util.jndi.CamelInitialContextFactory");
        }
        return new InitialContext(new Hashtable<Object, Object>(properties));
    }

    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() {
            }
        };
    }

    protected RouteBuilder[] createRouteBuilders() throws Exception {
        return new RouteBuilder[]{this.createRouteBuilder()};
    }

    protected Endpoint resolveMandatoryEndpoint(String uri) {
        return CamelTestSupport.resolveMandatoryEndpoint((CamelContext)this.context, uri);
    }

    protected <T extends Endpoint> T resolveMandatoryEndpoint(String uri, Class<T> endpointType) {
        return CamelTestSupport.resolveMandatoryEndpoint((CamelContext)this.context, uri, endpointType);
    }

    protected MockEndpoint getMockEndpoint(String uri) {
        return this.resolveMandatoryEndpoint(uri, MockEndpoint.class);
    }

    protected void sendBody(String endpointUri, final Object body) {
        this.template.send(endpointUri, new Processor(){

            public void process(Exchange exchange) {
                Message in = exchange.getIn();
                in.setBody(body);
            }
        });
    }

    protected void sendBody(String endpointUri, final Object body, final Map<String, Object> headers) {
        this.template.send(endpointUri, new Processor(){

            public void process(Exchange exchange) {
                Message in = exchange.getIn();
                in.setBody(body);
                for (Map.Entry entry : headers.entrySet()) {
                    in.setHeader((String)entry.getKey(), entry.getValue());
                }
            }
        });
    }

    protected void sendBodies(String endpointUri, Object ... bodies) {
        for (Object body : bodies) {
            this.sendBody(endpointUri, body);
        }
    }

    protected Exchange createExchangeWithBody(Object body) {
        return this.createExchangeWithBody((CamelContext)this.context, body);
    }

    protected void assertExpression(Exchange exchange, String languageName, String expressionText, Object expectedValue) {
        Language language = this.assertResolveLanguage(languageName);
        Expression expression = language.createExpression(expressionText);
        CamelTestSupport.assertNotNull((String)("No Expression could be created for text: " + expressionText + " language: " + language), (Object)expression);
        CamelTestSupport.assertExpression(expression, exchange, expectedValue);
    }

    protected void assertPredicate(String languageName, String expressionText, Exchange exchange, boolean expected) {
        Language language = this.assertResolveLanguage(languageName);
        Predicate predicate = language.createPredicate(expressionText);
        CamelTestSupport.assertNotNull((String)("No Predicate could be created for text: " + expressionText + " language: " + language), (Object)predicate);
        CamelTestSupport.assertPredicate(predicate, exchange, expected);
    }

    protected Language assertResolveLanguage(String languageName) {
        Language language = this.context.resolveLanguage(languageName);
        CamelTestSupport.assertNotNull((String)("No language found for name: " + languageName), (Object)language);
        return language;
    }

    protected void assertMockEndpointsSatisfied() throws InterruptedException {
        MockEndpoint.assertIsSatisfied((CamelContext)this.context);
    }

    protected void assertMockEndpointsSatisfied(long timeout, TimeUnit unit) throws InterruptedException {
        MockEndpoint.assertIsSatisfied((CamelContext)this.context, (long)timeout, (TimeUnit)unit);
    }

    protected void resetMocks() {
        MockEndpoint.resetMocks((CamelContext)this.context);
    }

    protected void assertValidContext(CamelContext context) {
        CamelTestSupport.assertNotNull((String)"No context found!", (Object)context);
    }

    protected <T extends Endpoint> T getMandatoryEndpoint(String uri, Class<T> type) {
        Endpoint endpoint = this.context.getEndpoint(uri, type);
        CamelTestSupport.assertNotNull((String)("No endpoint found for uri: " + uri), (Object)endpoint);
        return (T)endpoint;
    }

    protected Endpoint getMandatoryEndpoint(String uri) {
        Endpoint endpoint = this.context.getEndpoint(uri);
        CamelTestSupport.assertNotNull((String)("No endpoint found for uri: " + uri), (Object)endpoint);
        return endpoint;
    }

    protected void disableJMX() {
        System.setProperty("org.apache.camel.jmx.disabled", "true");
    }

    protected void enableJMX() {
        System.setProperty("org.apache.camel.jmx.disabled", "false");
    }

    protected void debugBefore(Exchange exchange, Processor processor, ProcessorDefinition<?> definition, String id, String label) {
    }

    protected void debugAfter(Exchange exchange, Processor processor, ProcessorDefinition<?> definition, String id, String label, long timeTaken) {
    }

    private class DebugBreakpoint
    extends BreakpointSupport {
        private DebugBreakpoint() {
        }

        public void beforeProcess(Exchange exchange, Processor processor, ProcessorDefinition<?> definition) {
            CamelTestSupport.this.debugBefore(exchange, processor, definition, definition.getId(), definition.getLabel());
        }

        public void afterProcess(Exchange exchange, Processor processor, ProcessorDefinition<?> definition, long timeTaken) {
            CamelTestSupport.this.debugAfter(exchange, processor, definition, definition.getId(), definition.getLabel(), timeTaken);
        }
    }
}

