/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.undertow.handlers;

import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.util.MimeMappings;
import java.util.HashMap;
import java.util.Map;
import org.apache.camel.component.undertow.ExchangeHeaders;

public class CamelMethodHandler
implements HttpHandler {
    private Map<String, HttpHandler> methodMap = new HashMap<String, HttpHandler>();
    private HttpHandler defaultHandler;
    private String handlerString;

    public void handleRequest(HttpServerExchange exchange) throws Exception {
        HttpHandler handler = this.methodMap.get(exchange.getRequestMethod().toString());
        if (handler != null) {
            handler.handleRequest(exchange);
        } else if (this.defaultHandler != null) {
            this.defaultHandler.handleRequest(exchange);
        } else {
            exchange.setStatusCode(405);
            exchange.getResponseHeaders().put(ExchangeHeaders.CONTENT_TYPE, (String)MimeMappings.DEFAULT_MIME_MAPPINGS.get("txt"));
            exchange.getResponseHeaders().put(ExchangeHeaders.CONTENT_LENGTH, 0L);
            exchange.endExchange();
        }
    }

    public synchronized void add(String[] methods, HttpHandler handler) {
        HashMap<String, HttpHandler> adding = new HashMap<String, HttpHandler>();
        for (String method : methods) {
            adding.put(method, handler);
        }
        this.methodMap.putAll(adding);
        this.handlerString = null;
    }

    public synchronized void remove(String[] methods) {
        for (String method : methods) {
            this.methodMap.remove(method);
        }
        this.handlerString = null;
    }

    public synchronized void addDefault(HttpHandler handler) {
        if (this.defaultHandler != null) {
            throw new IllegalArgumentException(String.format("Duplicate default handler: '%s', '%s'", this.defaultHandler, handler));
        }
        this.defaultHandler = handler;
        this.handlerString = null;
    }

    public synchronized void removeDefault() {
        this.defaultHandler = null;
        this.handlerString = null;
    }

    public boolean isEmpty() {
        return this.defaultHandler == null && this.methodMap.isEmpty();
    }

    public String toString() {
        if (this.handlerString == null) {
            this.handlerString = "CamelMethodHandler[default=" + this.defaultHandler + ", " + this.methodMap + "]";
        }
        return this.handlerString;
    }
}

