/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.zookeeper;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import java.util.Map;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelException;
import org.apache.camel.Endpoint;
import org.apache.camel.component.zookeeper.ZooKeeperConfiguration;
import org.apache.camel.component.zookeeper.ZooKeeperEndpoint;
import org.apache.camel.impl.UriEndpointComponent;

public class ZooKeeperComponent
extends UriEndpointComponent {
    private ZooKeeperConfiguration configuration;

    public ZooKeeperComponent() {
        super(ZooKeeperEndpoint.class);
    }

    public ZooKeeperComponent(CamelContext context) {
        super(context, ZooKeeperEndpoint.class);
    }

    public ZooKeeperComponent(ZooKeeperConfiguration configuration) {
        super(ZooKeeperEndpoint.class);
        this.configuration = configuration;
    }

    protected Endpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
        if (this.getCamelContext() == null) {
            throw new CamelException("No Camel context has been provided to this zookeeper component");
        }
        ZooKeeperConfiguration config = this.getConfiguration().copy();
        this.extractConfigFromUri(uri, config);
        this.setProperties(config, parameters);
        return new ZooKeeperEndpoint(uri, this, config);
    }

    private void extractConfigFromUri(String remaining, ZooKeeperConfiguration config) throws URISyntaxException {
        String[] hosts;
        URI fullUri = new URI(remaining);
        for (String host : hosts = fullUri.getAuthority().split(",")) {
            config.addZookeeperServer(host.trim());
        }
        config.setPath(fullUri.getPath());
    }

    public ZooKeeperConfiguration getConfiguration() {
        if (this.configuration == null) {
            this.configuration = new ZooKeeperConfiguration();
        }
        return this.configuration;
    }

    public void setConfiguration(ZooKeeperConfiguration configuration) {
        this.configuration = configuration;
    }

    private ZooKeeperConfiguration getConfigurationOrCreate() {
        if (this.getConfiguration() == null) {
            this.setConfiguration(new ZooKeeperConfiguration());
        }
        return this.getConfiguration();
    }

    public List<String> getServers() {
        return this.getConfigurationOrCreate().getServers();
    }

    public void setServers(List<String> servers) {
        this.getConfigurationOrCreate().setServers(servers);
    }

    public int getTimeout() {
        return this.getConfigurationOrCreate().getTimeout();
    }

    public void setTimeout(int timeout) {
        this.getConfigurationOrCreate().setTimeout(timeout);
    }

    public boolean isListChildren() {
        return this.getConfigurationOrCreate().isListChildren();
    }

    public void setListChildren(boolean listChildren) {
        this.getConfigurationOrCreate().setListChildren(listChildren);
    }

    public String getConnectString() {
        return this.getConfigurationOrCreate().getConnectString();
    }

    public void setPath(String path) {
        this.getConfigurationOrCreate().setPath(path);
    }

    public String getPath() {
        return this.getConfigurationOrCreate().getPath();
    }

    public boolean isRepeat() {
        return this.getConfigurationOrCreate().isRepeat();
    }

    public void setRepeat(boolean repeat) {
        this.getConfigurationOrCreate().setRepeat(repeat);
    }

    public long getBackoff() {
        return this.getConfigurationOrCreate().getBackoff();
    }

    public void setBackoff(long backoff) {
        this.getConfigurationOrCreate().setBackoff(backoff);
    }

    public boolean isCreate() {
        return this.getConfigurationOrCreate().isCreate();
    }

    public void setCreate(boolean shouldCreate) {
        this.getConfigurationOrCreate().setCreate(shouldCreate);
    }

    public String getCreateMode() {
        return this.getConfigurationOrCreate().getCreateMode();
    }

    public void setCreateMode(String createMode) {
        this.getConfigurationOrCreate().setCreateMode(createMode);
    }

    public boolean isSendEmptyMessageOnDelete() {
        return this.getConfigurationOrCreate().isSendEmptyMessageOnDelete();
    }

    public void setSendEmptyMessageOnDelete(boolean sendEmptyMessageOnDelete) {
        this.getConfigurationOrCreate().setSendEmptyMessageOnDelete(sendEmptyMessageOnDelete);
    }
}

