/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.main;

import io.quarkus.runtime.Quarkus;
import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.camel.CamelContext;
import org.apache.camel.ExtendedCamelContext;
import org.apache.camel.ProducerTemplate;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.main.MainCommandLineSupport;
import org.apache.camel.main.MainConfigurationProperties;
import org.apache.camel.main.MainListener;
import org.apache.camel.main.MainShutdownStrategy;
import org.apache.camel.main.SimpleMainShutdownStrategy;
import org.apache.camel.spi.CamelBeanPostProcessor;
import org.apache.camel.spi.HasCamelContext;
import org.apache.camel.support.service.ServiceHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CamelMain
extends MainCommandLineSupport
implements HasCamelContext {
    private static final Logger LOGGER = LoggerFactory.getLogger(CamelMain.class);
    private final AtomicBoolean engineStarted;

    public CamelMain(CamelContext camelContext) {
        this.camelContext = camelContext;
        this.engineStarted = new AtomicBoolean();
    }

    protected void loadRouteBuilders(CamelContext camelContext) throws Exception {
        CamelBeanPostProcessor postProcessor = ((ExtendedCamelContext)camelContext.adapt(ExtendedCamelContext.class)).getBeanPostProcessor();
        for (RoutesBuilder builder : this.mainConfigurationProperties.getRoutesBuilders()) {
            postProcessor.postProcessBeforeInitialization((Object)builder, builder.getClass().getName());
            postProcessor.postProcessAfterInitialization((Object)builder, builder.getClass().getName());
        }
    }

    protected void doInit() throws Exception {
        SimpleMainShutdownStrategy shutdownStrategy = new SimpleMainShutdownStrategy();
        shutdownStrategy.addShutdownListener(() -> Quarkus.asyncExit((int)this.getExitCode()));
        this.setShutdownStrategy((MainShutdownStrategy)shutdownStrategy);
        super.doInit();
        this.initCamelContext();
    }

    protected void doStart() throws Exception {
        super.doStart();
        try {
            this.camelContext.start();
        }
        finally {
            if (this.getCamelContext().isVetoStarted()) {
                this.completed();
            }
        }
    }

    protected void doStop() throws Exception {
        super.doStop();
        this.camelContext.stop();
        this.engineStarted.set(false);
    }

    protected ProducerTemplate findOrCreateCamelTemplate() {
        return this.camelContext.createProducerTemplate();
    }

    protected void initCamelContext() throws Exception {
        this.postProcessCamelContext(this.camelContext);
    }

    protected CamelContext createCamelContext() {
        throw new IllegalStateException("Should not be invoked");
    }

    Collection<MainListener> getMainListeners() {
        return Collections.unmodifiableCollection(this.listeners);
    }

    MainConfigurationProperties getMainConfigurationProperties() {
        return this.mainConfigurationProperties;
    }

    public void startEngine() throws Exception {
        if (this.shutdownStrategy.isRunAllowed() && this.engineStarted.compareAndSet(false, true)) {
            this.init();
            this.beforeStart();
            this.start();
            this.afterStart();
        }
    }

    public void runEngine() throws Exception {
        if (this.shutdownStrategy.isRunAllowed()) {
            this.startEngine();
            this.waitUntilCompleted();
            try {
                if (this.camelTemplate != null) {
                    ServiceHelper.stopService((Object)this.camelTemplate);
                    this.camelTemplate = null;
                }
            }
            catch (Exception e) {
                LOG.debug("Error stopping camelTemplate due " + e.getMessage() + ". This exception is ignored.", (Throwable)e);
            }
            this.beforeStop();
            this.stop();
            this.afterStop();
        }
    }

    public void run(String[] args) throws Exception {
        this.parseArguments(args);
        this.runEngine();
    }
}

