/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.springboot.catalog;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import org.apache.camel.catalog.CamelCatalog;
import org.apache.camel.catalog.RuntimeProvider;
import org.apache.camel.catalog.impl.CatalogHelper;

public class SpringBootRuntimeProvider
implements RuntimeProvider {
    private static final String COMPONENT_DIR = "org/apache/camel/springboot/catalog/components";
    private static final String DATAFORMAT_DIR = "org/apache/camel/springboot/catalog/dataformats";
    private static final String LANGUAGE_DIR = "org/apache/camel/springboot/catalog/languages";
    private static final String TRANSFORMER_DIR = "org/apache/camel/springboot/catalog/transformers";
    private static final String CONSOLE_DIR = "org/apache/camel/springboot/catalog/dev-consoles";
    private static final String OTHER_DIR = "org/apache/camel/springboot/catalog/others";
    private static final String BEAN_DIR = "org/apache/camel/springboot/catalog/beans";
    private static final String COMPONENTS_CATALOG = "org/apache/camel/springboot/catalog/components.properties";
    private static final String DATA_FORMATS_CATALOG = "org/apache/camel/springboot/catalog/dataformats.properties";
    private static final String LANGUAGE_CATALOG = "org/apache/camel/springboot/catalog/languages.properties";
    private static final String TRANSFORMER_CATALOG = "org/apache/camel/springboot/catalog/transformers.properties";
    private static final String CONSOLES_CATALOG = "org/apache/camel/springboot/catalog/dev-consoles.properties";
    private static final String OTHER_CATALOG = "org/apache/camel/springboot/catalog/others.properties";
    private static final String BEAN_CATALOG = "org/apache/camel/springboot/catalog/beans.properties";
    private static final String CAPABILITIES_CATALOG = "org/apache/camel/springboot/catalog/capabilities.properties";
    private CamelCatalog camelCatalog;

    public CamelCatalog getCamelCatalog() {
        return this.camelCatalog;
    }

    public void setCamelCatalog(CamelCatalog camelCatalog) {
        this.camelCatalog = camelCatalog;
    }

    public String getProviderName() {
        return "springboot";
    }

    public String getProviderGroupId() {
        return "org.apache.camel";
    }

    public String getProviderArtifactId() {
        return "camel-catalog-provider-springboot";
    }

    public String getComponentJSonSchemaDirectory() {
        return COMPONENT_DIR;
    }

    public String getDataFormatJSonSchemaDirectory() {
        return DATAFORMAT_DIR;
    }

    public String getLanguageJSonSchemaDirectory() {
        return LANGUAGE_DIR;
    }

    public String getTransformerJSonSchemaDirectory() {
        return TRANSFORMER_DIR;
    }

    public String getDevConsoleJSonSchemaDirectory() {
        return CONSOLE_DIR;
    }

    public String getOtherJSonSchemaDirectory() {
        return OTHER_DIR;
    }

    public String getPojoBeanJSonSchemaDirectory() {
        return BEAN_DIR;
    }

    public List<String> findComponentNames() {
        return this.findNames(COMPONENTS_CATALOG);
    }

    public List<String> findDataFormatNames() {
        return this.findNames(DATA_FORMATS_CATALOG);
    }

    public List<String> findLanguageNames() {
        return this.findNames(LANGUAGE_CATALOG);
    }

    public List<String> findTransformerNames() {
        return this.findNames(TRANSFORMER_CATALOG);
    }

    public List<String> findDevConsoleNames() {
        return this.findNames(CONSOLES_CATALOG);
    }

    public List<String> findOtherNames() {
        return this.findNames(OTHER_CATALOG);
    }

    public List<String> findBeansNames() {
        return this.findNames(BEAN_CATALOG);
    }

    public Map<String, String> findCapabilities() {
        Properties properties = new Properties();
        try (InputStream is = this.getCamelCatalog().getVersionManager().getResourceAsStream(CAPABILITIES_CATALOG);){
            if (is != null) {
                properties.load(is);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return new TreeMap<Object, Object>(properties);
    }

    private List<String> findNames(String pathToPropertyCatalogDescriptor) {
        ArrayList<String> names = new ArrayList<String>();
        try (InputStream is = this.camelCatalog.getVersionManager().getResourceAsStream(pathToPropertyCatalogDescriptor);){
            if (is != null) {
                try {
                    CatalogHelper.loadLines((InputStream)is, names);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return names;
    }
}

