/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.spring.boot.actuate.health;

import java.time.Duration;
import java.time.ZonedDateTime;
import org.apache.camel.spring.boot.actuate.health.CamelHealthCheckConfigurationProperties;
import org.apache.camel.spring.boot.actuate.health.CamelHealthCheckIndicator;
import org.apache.camel.spring.boot.actuate.health.liveness.CamelLivenessStateHealthIndicator;
import org.apache.camel.spring.boot.actuate.health.readiness.CamelReadinessStateHealthIndicator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.boot.actuate.health.Health;
import org.springframework.boot.actuate.health.HealthContributorRegistry;
import org.springframework.boot.actuate.health.HealthIndicator;
import org.springframework.boot.actuate.health.NamedContributor;
import org.springframework.boot.actuate.health.Status;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Configuration;
import org.springframework.scheduling.TaskScheduler;
import org.springframework.scheduling.concurrent.ThreadPoolTaskScheduler;

@Configuration
@ConditionalOnProperty(prefix="camel.health", name={"async-camel-health-check"}, havingValue="true")
public class AsyncHealthIndicatorAutoConfiguration
implements InitializingBean {
    private static final Logger log = LoggerFactory.getLogger(AsyncHealthIndicatorAutoConfiguration.class);
    private HealthContributorRegistry healthContributorRegistry;
    private TaskScheduler taskScheduler;
    private CamelHealthCheckConfigurationProperties config;

    public AsyncHealthIndicatorAutoConfiguration(HealthContributorRegistry healthContributorRegistry, CamelHealthCheckConfigurationProperties config) {
        this.healthContributorRegistry = healthContributorRegistry;
        this.config = config;
        ThreadPoolTaskScheduler threadPoolTaskScheduler = new ThreadPoolTaskScheduler();
        threadPoolTaskScheduler.setPoolSize(config.getHealthCheckPoolSize());
        threadPoolTaskScheduler.setThreadNamePrefix(config.getHealthCheckThreadNamePrefix());
        threadPoolTaskScheduler.initialize();
        this.taskScheduler = threadPoolTaskScheduler;
    }

    public void afterPropertiesSet() throws Exception {
        for (NamedContributor namedContributor : this.healthContributorRegistry) {
            String name = namedContributor.getName();
            Object contributor = namedContributor.getContributor();
            if (!(contributor instanceof CamelHealthCheckIndicator) && !(contributor instanceof CamelLivenessStateHealthIndicator) && !(contributor instanceof CamelReadinessStateHealthIndicator)) continue;
            HealthIndicator camelHealthCheckIndicator = (HealthIndicator)contributor;
            this.healthContributorRegistry.unregisterContributor(name);
            log.debug("Wrapping " + contributor.getClass().getSimpleName() + " for async health scheduling");
            WrappedHealthIndicator wrappedHealthIndicator = new WrappedHealthIndicator(camelHealthCheckIndicator);
            this.healthContributorRegistry.registerContributor(name, (Object)wrappedHealthIndicator);
            this.taskScheduler.scheduleWithFixedDelay((Runnable)wrappedHealthIndicator, Duration.ofSeconds(this.config.getHealthCheckFrequency()));
        }
    }

    private static class WrappedHealthIndicator
    implements HealthIndicator,
    Runnable {
        private static final String LAST_CHECKED_KEY = "lastChecked";
        private static final String LAST_DURATION_KEY = "lastDuration";
        private HealthIndicator wrappedHealthIndicator;
        private Health lastHealth;

        public WrappedHealthIndicator(HealthIndicator wrappedHealthIndicator) {
            this.wrappedHealthIndicator = wrappedHealthIndicator;
        }

        public Health health() {
            Health lastHealth = this.getLastHealth();
            if (lastHealth == null) {
                this.setLastHealth(this.getAndWrapHealth());
                lastHealth = this.getLastHealth();
            }
            return lastHealth;
        }

        private Health getAndWrapHealth() {
            ZonedDateTime startTime = ZonedDateTime.now();
            Health baseHealth = this.getWrappedHealthIndicator().health();
            ZonedDateTime endTime = ZonedDateTime.now();
            Duration duration = Duration.between(startTime, endTime);
            return Health.status((Status)baseHealth.getStatus()).withDetails(baseHealth.getDetails()).withDetail(LAST_CHECKED_KEY, (Object)startTime).withDetail(LAST_DURATION_KEY, (Object)duration).build();
        }

        @Override
        public void run() {
            this.setLastHealth(this.getAndWrapHealth());
        }

        public HealthIndicator getWrappedHealthIndicator() {
            return this.wrappedHealthIndicator;
        }

        public Health getLastHealth() {
            return this.lastHealth;
        }

        public void setLastHealth(Health lastHealth) {
            this.lastHealth = lastHealth;
        }
    }
}

