/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.stress.operations;

import com.yammer.metrics.core.TimerContext;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.List;
import org.apache.cassandra.db.ColumnFamilyType;
import org.apache.cassandra.stress.Session;
import org.apache.cassandra.stress.util.CassandraClient;
import org.apache.cassandra.stress.util.Operation;
import org.apache.cassandra.thrift.Cassandra;
import org.apache.cassandra.thrift.ColumnParent;
import org.apache.cassandra.thrift.SlicePredicate;
import org.apache.cassandra.thrift.SliceRange;

public class CounterGetter
extends Operation {
    public CounterGetter(Session client, int index) {
        super(client, index);
    }

    @Override
    public void run(CassandraClient client) throws IOException {
        SliceRange sliceRange = new SliceRange();
        sliceRange.setStart(new byte[0]).setFinish(new byte[0]);
        sliceRange.setReversed(false).setCount(this.session.getColumnsPerKey());
        SlicePredicate predicate = new SlicePredicate().setSlice_range(sliceRange);
        if (this.session.getColumnFamilyType() == ColumnFamilyType.Super) {
            this.runSuperCounterGetter(predicate, client);
        } else {
            this.runCounterGetter(predicate, client);
        }
    }

    private void runSuperCounterGetter(SlicePredicate predicate, Cassandra.Client client) throws IOException {
        byte[] rawKey = this.generateKey();
        ByteBuffer key = ByteBuffer.wrap(rawKey);
        for (int j = 0; j < this.session.getSuperColumns(); ++j) {
            String superColumn = 'S' + Integer.toString(j);
            ColumnParent parent = new ColumnParent("SuperCounter1").setSuper_column(superColumn.getBytes());
            TimerContext context = this.session.latency.time();
            boolean success = false;
            String exceptionMessage = null;
            for (int t = 0; t < this.session.getRetryTimes() && !success; ++t) {
                try {
                    List counters = client.get_slice(key, parent, predicate, this.session.getConsistencyLevel());
                    success = counters.size() != 0;
                    continue;
                }
                catch (Exception e) {
                    exceptionMessage = this.getExceptionMessage(e);
                    success = false;
                }
            }
            if (!success) {
                this.error(String.format("Operation [%d] retried %d times - error reading counter key %s %s%n", this.index, this.session.getRetryTimes(), new String(rawKey), exceptionMessage == null ? "" : "(" + exceptionMessage + ")"));
            }
            this.session.operations.getAndIncrement();
            this.session.keys.getAndIncrement();
            context.stop();
        }
    }

    private void runCounterGetter(SlicePredicate predicate, Cassandra.Client client) throws IOException {
        ColumnParent parent = new ColumnParent("Counter1");
        byte[] key = this.generateKey();
        ByteBuffer keyBuffer = ByteBuffer.wrap(key);
        TimerContext context = this.session.latency.time();
        boolean success = false;
        String exceptionMessage = null;
        for (int t = 0; t < this.session.getRetryTimes() && !success; ++t) {
            try {
                List counters = client.get_slice(keyBuffer, parent, predicate, this.session.getConsistencyLevel());
                success = counters.size() != 0;
                continue;
            }
            catch (Exception e) {
                exceptionMessage = this.getExceptionMessage(e);
                success = false;
            }
        }
        if (!success) {
            this.error(String.format("Operation [%d] retried %d times - error reading counter key %s %s%n", this.index, this.session.getRetryTimes(), new String(key), exceptionMessage == null ? "" : "(" + exceptionMessage + ")"));
        }
        this.session.operations.getAndIncrement();
        this.session.keys.getAndIncrement();
        context.stop();
    }
}

