/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.stress.operations;

import com.yammer.metrics.core.TimerContext;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.cassandra.db.ColumnFamilyType;
import org.apache.cassandra.stress.Session;
import org.apache.cassandra.stress.util.CassandraClient;
import org.apache.cassandra.stress.util.Operation;
import org.apache.cassandra.thrift.Column;
import org.apache.cassandra.thrift.ColumnOrSuperColumn;
import org.apache.cassandra.thrift.Mutation;
import org.apache.cassandra.thrift.SuperColumn;
import org.apache.cassandra.utils.ByteBufferUtil;
import org.apache.cassandra.utils.FBUtilities;

public class Inserter
extends Operation {
    private static List<ByteBuffer> values;

    public Inserter(Session client, int index) {
        super(client, index);
    }

    @Override
    public void run(CassandraClient client) throws IOException {
        int i;
        if (values == null) {
            values = this.generateValues();
        }
        ArrayList<Column> columns = new ArrayList<Column>(this.session.getColumnsPerKey());
        ArrayList<SuperColumn> superColumns = null;
        String format = "%0" + this.session.getTotalKeysLength() + "d";
        for (i = 0; i < this.session.getColumnsPerKey(); ++i) {
            columns.add(new Column(this.columnName(i, this.session.timeUUIDComparator)).setValue(values.get(i % values.size())).setTimestamp(FBUtilities.timestampMicros()));
        }
        if (this.session.getColumnFamilyType() == ColumnFamilyType.Super) {
            superColumns = new ArrayList<SuperColumn>();
            for (i = 0; i < this.session.getSuperColumns(); ++i) {
                String superColumnName = "S" + Integer.toString(i);
                superColumns.add(new SuperColumn(ByteBufferUtil.bytes((String)superColumnName), columns));
            }
        }
        String rawKey = String.format(format, this.index);
        Map<String, List<Mutation>> row = this.session.getColumnFamilyType() == ColumnFamilyType.Super ? this.getSuperColumnsMutationMap(superColumns) : this.getColumnsMutationMap(columns);
        Map<ByteBuffer, Map<String, List<Mutation>>> record = Collections.singletonMap(ByteBufferUtil.bytes((String)rawKey), row);
        TimerContext context = this.session.latency.time();
        boolean success = false;
        String exceptionMessage = null;
        for (int t = 0; t < this.session.getRetryTimes() && !success; ++t) {
            try {
                client.batch_mutate(record, this.session.getConsistencyLevel());
                success = true;
                continue;
            }
            catch (Exception e) {
                exceptionMessage = this.getExceptionMessage(e);
                success = false;
            }
        }
        if (!success) {
            this.error(String.format("Operation [%d] retried %d times - error inserting key %s %s%n", this.index, this.session.getRetryTimes(), rawKey, exceptionMessage == null ? "" : "(" + exceptionMessage + ")"));
        }
        this.session.operations.getAndIncrement();
        this.session.keys.getAndIncrement();
        context.stop();
    }

    private Map<String, List<Mutation>> getSuperColumnsMutationMap(List<SuperColumn> superColumns) {
        ArrayList<Mutation> mutations = new ArrayList<Mutation>(superColumns.size());
        for (SuperColumn s : superColumns) {
            ColumnOrSuperColumn superColumn = new ColumnOrSuperColumn().setSuper_column(s);
            mutations.add(new Mutation().setColumn_or_supercolumn(superColumn));
        }
        return Collections.singletonMap("Super1", mutations);
    }

    private Map<String, List<Mutation>> getColumnsMutationMap(List<Column> columns) {
        ArrayList<Mutation> mutations = new ArrayList<Mutation>(columns.size());
        for (Column c : columns) {
            ColumnOrSuperColumn column = new ColumnOrSuperColumn().setColumn(c);
            mutations.add(new Mutation().setColumn_or_supercolumn(column));
        }
        return Collections.singletonMap("Standard1", mutations);
    }
}

