/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.stress.operations;

import com.google.common.base.Charsets;
import com.yammer.metrics.core.TimerContext;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.List;
import org.apache.cassandra.db.ColumnFamilyType;
import org.apache.cassandra.stress.Session;
import org.apache.cassandra.stress.util.CassandraClient;
import org.apache.cassandra.stress.util.Operation;
import org.apache.cassandra.thrift.Cassandra;
import org.apache.cassandra.thrift.ColumnParent;
import org.apache.cassandra.thrift.SlicePredicate;
import org.apache.cassandra.thrift.SliceRange;

public class Reader
extends Operation {
    public Reader(Session client, int index) {
        super(client, index);
    }

    @Override
    public void run(CassandraClient client) throws IOException {
        SlicePredicate predicate = new SlicePredicate();
        if (this.session.columnNames == null) {
            predicate.setSlice_range(this.getSliceRange());
        } else {
            predicate.setColumn_names(this.session.columnNames);
        }
        if (this.session.getColumnFamilyType() == ColumnFamilyType.Super) {
            this.runSuperColumnReader(predicate, client);
        } else {
            this.runColumnReader(predicate, client);
        }
    }

    private void runSuperColumnReader(SlicePredicate predicate, Cassandra.Client client) throws IOException {
        byte[] rawKey = this.generateKey();
        ByteBuffer key = ByteBuffer.wrap(rawKey);
        for (int j = 0; j < this.session.getSuperColumns(); ++j) {
            String superColumn = 'S' + Integer.toString(j);
            ColumnParent parent = new ColumnParent("Super1").setSuper_column(superColumn.getBytes(Charsets.UTF_8));
            TimerContext context = this.session.latency.time();
            boolean success = false;
            String exceptionMessage = null;
            for (int t = 0; t < this.session.getRetryTimes() && !success; ++t) {
                try {
                    List columns = client.get_slice(key, parent, predicate, this.session.getConsistencyLevel());
                    success = columns.size() != 0;
                    continue;
                }
                catch (Exception e) {
                    exceptionMessage = this.getExceptionMessage(e);
                    success = false;
                }
            }
            if (!success) {
                this.error(String.format("Operation [%d] retried %d times - error reading key %s %s%n", this.index, this.session.getRetryTimes(), new String(rawKey), exceptionMessage == null ? "" : "(" + exceptionMessage + ")"));
            }
            this.session.operations.getAndIncrement();
            this.session.keys.getAndIncrement();
            context.stop();
        }
    }

    private void runColumnReader(SlicePredicate predicate, Cassandra.Client client) throws IOException {
        ColumnParent parent = new ColumnParent("Standard1");
        byte[] key = this.generateKey();
        ByteBuffer keyBuffer = ByteBuffer.wrap(key);
        TimerContext context = this.session.latency.time();
        boolean success = false;
        String exceptionMessage = null;
        for (int t = 0; t < this.session.getRetryTimes() && !success; ++t) {
            try {
                List columns = client.get_slice(keyBuffer, parent, predicate, this.session.getConsistencyLevel());
                success = columns.size() != 0;
                continue;
            }
            catch (Exception e) {
                exceptionMessage = this.getExceptionMessage(e);
                success = false;
            }
        }
        if (!success) {
            this.error(String.format("Operation [%d] retried %d times - error reading key %s %s%n", this.index, this.session.getRetryTimes(), new String(key), exceptionMessage == null ? "" : "(" + exceptionMessage + ")"));
        }
        this.session.operations.getAndIncrement();
        this.session.keys.getAndIncrement();
        context.stop();
    }

    private SliceRange getSliceRange() {
        return new SliceRange().setStart(new byte[0]).setFinish(new byte[0]).setReversed(false).setCount(this.session.getColumnsPerKey());
    }
}

