/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cql3.statements;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import org.apache.cassandra.cql3.AssignementTestable;
import org.apache.cassandra.cql3.CFDefinition;
import org.apache.cassandra.cql3.CQL3Type;
import org.apache.cassandra.cql3.ColumnIdentifier;
import org.apache.cassandra.cql3.ColumnSpecification;
import org.apache.cassandra.cql3.ResultSet;
import org.apache.cassandra.cql3.functions.Function;
import org.apache.cassandra.cql3.functions.Functions;
import org.apache.cassandra.cql3.statements.RawSelector;
import org.apache.cassandra.db.CounterColumn;
import org.apache.cassandra.db.ExpiringColumn;
import org.apache.cassandra.db.IColumn;
import org.apache.cassandra.db.context.CounterContext;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.db.marshal.Int32Type;
import org.apache.cassandra.db.marshal.LongType;
import org.apache.cassandra.exceptions.InvalidRequestException;
import org.apache.cassandra.utils.ByteBufferUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Selection {
    private static final Logger logger = LoggerFactory.getLogger(Selection.class);
    private final List<CFDefinition.Name> columnsList;
    private final List<ColumnSpecification> metadata;
    private final boolean collectTimestamps;
    private final boolean collectTTLs;

    protected Selection(List<CFDefinition.Name> columnsList, List<ColumnSpecification> metadata, boolean collectTimestamps, boolean collectTTLs) {
        this.columnsList = columnsList;
        this.metadata = metadata;
        this.collectTimestamps = collectTimestamps;
        this.collectTTLs = collectTTLs;
    }

    public static Selection wildcard(CFDefinition cfDef) {
        ArrayList<CFDefinition.Name> all = new ArrayList<CFDefinition.Name>();
        for (CFDefinition.Name name : cfDef) {
            all.add(name);
        }
        return new SimpleSelection(all);
    }

    private static boolean isUsingFunction(List<RawSelector> rawSelectors) {
        for (RawSelector rawSelector : rawSelectors) {
            if (rawSelector instanceof ColumnIdentifier) continue;
            return true;
        }
        return false;
    }

    private static int addAndGetIndex(CFDefinition.Name name, List<CFDefinition.Name> l) {
        int idx = l.indexOf(name);
        if (idx < 0) {
            idx = l.size();
            l.add(name);
        }
        return idx;
    }

    private static Selector makeSelector(CFDefinition cfDef, RawSelector raw, List<CFDefinition.Name> names, List<ColumnSpecification> metadata) throws InvalidRequestException {
        if (raw instanceof ColumnIdentifier) {
            CFDefinition.Name name = cfDef.get((ColumnIdentifier)raw);
            if (name == null) {
                throw new InvalidRequestException(String.format("Undefined name %s in selection clause", raw));
            }
            if (metadata != null) {
                metadata.add(name);
            }
            return new SimpleSelector(Selection.addAndGetIndex(name, names), name.type);
        }
        if (raw instanceof RawSelector.WritetimeOrTTL) {
            RawSelector.WritetimeOrTTL tot = (RawSelector.WritetimeOrTTL)raw;
            CFDefinition.Name name = cfDef.get(tot.id);
            if (name == null) {
                throw new InvalidRequestException(String.format("Undefined name %s in selection clause", tot.id));
            }
            if (name.kind != CFDefinition.Name.Kind.COLUMN_METADATA && name.kind != CFDefinition.Name.Kind.VALUE_ALIAS) {
                throw new InvalidRequestException(String.format("Cannot use selection function %s on PRIMARY KEY part %s", tot.isWritetime ? "writeTime" : "ttl", name));
            }
            if (name.type.isCollection()) {
                throw new InvalidRequestException(String.format("Cannot use selection function %s on collections", tot.isWritetime ? "writeTime" : "ttl"));
            }
            if (metadata != null) {
                metadata.add(Selection.makeWritetimeOrTTLSpec(cfDef, tot));
            }
            return new WritetimeOrTTLSelector(Selection.addAndGetIndex(name, names), tot.isWritetime);
        }
        RawSelector.WithFunction withFun = (RawSelector.WithFunction)raw;
        ArrayList<Selector> args = new ArrayList<Selector>(withFun.args.size());
        for (RawSelector rawArg : withFun.args) {
            args.add(Selection.makeSelector(cfDef, rawArg, names, null));
        }
        AbstractType<?> returnType = Functions.getReturnType(withFun.functionName, cfDef.cfm.ksName, cfDef.cfm.cfName);
        if (returnType == null) {
            throw new InvalidRequestException(String.format("Unknown function '%s'", withFun.functionName));
        }
        ColumnSpecification spec = Selection.makeFunctionSpec(cfDef, withFun, returnType);
        Function fun = Functions.get(withFun.functionName, args, spec);
        if (metadata != null) {
            metadata.add(spec);
        }
        return new FunctionSelector(fun, args);
    }

    private static ColumnSpecification makeWritetimeOrTTLSpec(CFDefinition cfDef, RawSelector.WritetimeOrTTL tot) {
        return new ColumnSpecification(cfDef.cfm.ksName, cfDef.cfm.cfName, new ColumnIdentifier(tot.toString(), true), tot.isWritetime ? LongType.instance : Int32Type.instance);
    }

    private static ColumnSpecification makeFunctionSpec(CFDefinition cfDef, RawSelector.WithFunction fun, AbstractType<?> returnType) throws InvalidRequestException {
        if (returnType == null) {
            throw new InvalidRequestException(String.format("Unknown function %s called in selection clause", fun.functionName));
        }
        return new ColumnSpecification(cfDef.cfm.ksName, cfDef.cfm.cfName, new ColumnIdentifier(fun.toString(), true), returnType);
    }

    public static Selection fromSelectors(CFDefinition cfDef, List<RawSelector> rawSelectors) throws InvalidRequestException {
        boolean usesFunction = Selection.isUsingFunction(rawSelectors);
        if (usesFunction) {
            ArrayList<CFDefinition.Name> names = new ArrayList<CFDefinition.Name>();
            ArrayList<ColumnSpecification> metadata = new ArrayList<ColumnSpecification>(rawSelectors.size());
            ArrayList<Selector> selectors = new ArrayList<Selector>(rawSelectors.size());
            boolean collectTimestamps = false;
            boolean collectTTLs = false;
            for (RawSelector rawSelector : rawSelectors) {
                Selector selector = Selection.makeSelector(cfDef, rawSelector, names, metadata);
                selectors.add(selector);
                if (!(selector instanceof WritetimeOrTTLSelector)) continue;
                collectTimestamps |= ((WritetimeOrTTLSelector)selector).isWritetime;
                collectTTLs |= !((WritetimeOrTTLSelector)selector).isWritetime;
            }
            return new SelectionWithFunctions(names, metadata, selectors, collectTimestamps, collectTTLs);
        }
        ArrayList<CFDefinition.Name> names = new ArrayList<CFDefinition.Name>(rawSelectors.size());
        for (RawSelector rawSelector : rawSelectors) {
            assert (rawSelector instanceof ColumnIdentifier);
            CFDefinition.Name name = cfDef.get((ColumnIdentifier)rawSelector);
            if (name == null) {
                throw new InvalidRequestException(String.format("Undefined name %s in selection clause", rawSelector));
            }
            names.add(name);
        }
        return new SimpleSelection(names);
    }

    protected abstract List<ByteBuffer> handleRow(ResultSetBuilder var1) throws InvalidRequestException;

    public List<ColumnIdentifier> regularColumnsToFetch() {
        ArrayList<ColumnIdentifier> toFetch = new ArrayList<ColumnIdentifier>();
        for (CFDefinition.Name name : this.columnsList) {
            if (name.kind != CFDefinition.Name.Kind.COLUMN_METADATA) continue;
            toFetch.add(name.name);
        }
        return toFetch;
    }

    public List<CFDefinition.Name> getColumnsList() {
        return this.columnsList;
    }

    public ResultSetBuilder resultSetBuilder() {
        return new ResultSetBuilder();
    }

    private static ByteBuffer value(IColumn c) {
        return c instanceof CounterColumn ? ByteBufferUtil.bytes(CounterContext.instance().total(c.value())) : c.value();
    }

    private static class SelectionWithFunctions
    extends Selection {
        private final List<Selector> selectors;

        public SelectionWithFunctions(List<CFDefinition.Name> columnsList, List<ColumnSpecification> metadata, List<Selector> selectors, boolean collectTimestamps, boolean collectTTLs) {
            super(columnsList, metadata, collectTimestamps, collectTTLs);
            this.selectors = selectors;
        }

        @Override
        protected List<ByteBuffer> handleRow(ResultSetBuilder rs) throws InvalidRequestException {
            ArrayList<ByteBuffer> result = new ArrayList<ByteBuffer>();
            for (Selector selector : this.selectors) {
                result.add(selector.compute(rs));
            }
            return result;
        }
    }

    private static class WritetimeOrTTLSelector
    implements Selector {
        private final int idx;
        private final boolean isWritetime;

        public WritetimeOrTTLSelector(int idx, boolean isWritetime) {
            this.idx = idx;
            this.isWritetime = isWritetime;
        }

        @Override
        public ByteBuffer compute(ResultSetBuilder rs) {
            if (this.isWritetime) {
                long ts = rs.timestamps[this.idx];
                return ts >= 0L ? ByteBufferUtil.bytes(ts) : null;
            }
            int ttl = rs.ttls[this.idx];
            return ttl > 0 ? ByteBufferUtil.bytes(ttl) : null;
        }

        @Override
        public boolean isAssignableTo(ColumnSpecification receiver) {
            return receiver.type.asCQL3Type().equals(this.isWritetime ? CQL3Type.Native.BIGINT : CQL3Type.Native.INT);
        }
    }

    private static class FunctionSelector
    implements Selector {
        private final Function fun;
        private final List<Selector> argSelectors;

        public FunctionSelector(Function fun, List<Selector> argSelectors) {
            this.fun = fun;
            this.argSelectors = argSelectors;
        }

        @Override
        public ByteBuffer compute(ResultSetBuilder rs) throws InvalidRequestException {
            ArrayList<ByteBuffer> args = new ArrayList<ByteBuffer>(this.argSelectors.size());
            for (Selector s : this.argSelectors) {
                args.add(s.compute(rs));
            }
            return this.fun.execute(args);
        }

        @Override
        public boolean isAssignableTo(ColumnSpecification receiver) {
            return this.fun.returnType().equals(receiver.type);
        }
    }

    private static class SimpleSelector
    implements Selector {
        private final int idx;
        private final AbstractType<?> type;

        public SimpleSelector(int idx, AbstractType<?> type) {
            this.idx = idx;
            this.type = type;
        }

        @Override
        public ByteBuffer compute(ResultSetBuilder rs) {
            return rs.current.get(this.idx);
        }

        @Override
        public boolean isAssignableTo(ColumnSpecification receiver) {
            return this.type.equals(receiver.type);
        }
    }

    private static interface Selector
    extends AssignementTestable {
        public ByteBuffer compute(ResultSetBuilder var1) throws InvalidRequestException;
    }

    private static class SimpleSelection
    extends Selection {
        public SimpleSelection(List<CFDefinition.Name> columnsList) {
            super(columnsList, new ArrayList<ColumnSpecification>(columnsList), false, false);
        }

        @Override
        protected List<ByteBuffer> handleRow(ResultSetBuilder rs) {
            return rs.current;
        }
    }

    public class ResultSetBuilder {
        private final ResultSet resultSet;
        List<ByteBuffer> current;
        final long[] timestamps;
        final int[] ttls;

        private ResultSetBuilder() {
            this.resultSet = new ResultSet(Selection.this.metadata);
            this.timestamps = Selection.this.collectTimestamps ? new long[Selection.this.columnsList.size()] : null;
            this.ttls = Selection.this.collectTTLs ? new int[Selection.this.columnsList.size()] : null;
        }

        public void add(ByteBuffer v) {
            this.current.add(v);
        }

        public void add(IColumn c) {
            this.current.add(this.isDead(c) ? null : Selection.value(c));
            if (this.timestamps != null) {
                long l = this.timestamps[this.current.size() - 1] = this.isDead(c) ? -1L : c.timestamp();
            }
            if (this.ttls != null) {
                int ttl = -1;
                if (!this.isDead(c) && c instanceof ExpiringColumn) {
                    ttl = ((ExpiringColumn)c).getLocalDeletionTime() - (int)(System.currentTimeMillis() / 1000L);
                }
                this.ttls[this.current.size() - 1] = ttl;
            }
        }

        private boolean isDead(IColumn c) {
            return c == null || c.isMarkedForDelete();
        }

        public void newRow() throws InvalidRequestException {
            if (this.current != null) {
                this.resultSet.addRow(Selection.this.handleRow(this));
            }
            this.current = new ArrayList<ByteBuffer>(Selection.this.columnsList.size());
        }

        public ResultSet build() throws InvalidRequestException {
            if (this.current != null) {
                this.resultSet.addRow(Selection.this.handleRow(this));
                this.current = null;
            }
            return this.resultSet;
        }
    }
}

