/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db;

import java.io.DataOutput;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.db.ColumnFamily;
import org.apache.cassandra.db.DeletionInfo;
import org.apache.cassandra.db.DeletionTime;
import org.apache.cassandra.db.IColumn;
import org.apache.cassandra.db.OnDiskAtom;
import org.apache.cassandra.db.RangeTombstone;
import org.apache.cassandra.db.TypeSizes;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.io.sstable.IndexHelper;
import org.apache.cassandra.utils.AlwaysPresentFilter;
import org.apache.cassandra.utils.FilterFactory;
import org.apache.cassandra.utils.IFilter;

public class ColumnIndex {
    public final List<IndexHelper.IndexInfo> columnsIndex;
    public final IFilter bloomFilter;
    private static final ColumnIndex EMPTY = new ColumnIndex(Collections.<IndexHelper.IndexInfo>emptyList(), new AlwaysPresentFilter());

    private ColumnIndex(int estimatedColumnCount) {
        this(new ArrayList<IndexHelper.IndexInfo>(), FilterFactory.getFilter((long)estimatedColumnCount, 4, false));
    }

    private ColumnIndex(List<IndexHelper.IndexInfo> columnsIndex, IFilter bloomFilter) {
        this.columnsIndex = columnsIndex;
        this.bloomFilter = bloomFilter;
    }

    public static class Builder {
        private final ColumnIndex result;
        private final long indexOffset;
        private long startPosition = -1L;
        private long endPosition = 0L;
        private long blockSize;
        private OnDiskAtom firstColumn;
        private OnDiskAtom lastColumn;
        private OnDiskAtom lastBlockClosing;
        private final DataOutput output;
        private final RangeTombstone.Tracker tombstoneTracker;
        private final OnDiskAtom.Serializer atomSerializer;
        private int atomCount;

        public Builder(ColumnFamily cf, ByteBuffer key, int estimatedColumnCount, DataOutput output) {
            this.indexOffset = Builder.rowHeaderSize(key, cf.deletionInfo());
            this.result = new ColumnIndex(estimatedColumnCount);
            this.output = output;
            this.atomSerializer = cf.getOnDiskSerializer();
            this.tombstoneTracker = new RangeTombstone.Tracker(cf.getComparator());
        }

        private static long rowHeaderSize(ByteBuffer key, DeletionInfo delInfo) {
            TypeSizes typeSizes = TypeSizes.NATIVE;
            int keysize = key.remaining();
            return (long)(typeSizes.sizeof((short)keysize) + keysize + typeSizes.sizeof(0L)) + DeletionTime.serializer.serializedSize(delInfo.getTopLevelDeletion(), typeSizes) + (long)typeSizes.sizeof(0);
        }

        public RangeTombstone.Tracker tombstoneTracker() {
            return this.tombstoneTracker;
        }

        public int writtenAtomCount() {
            return this.atomCount + this.tombstoneTracker.writtenAtom();
        }

        public ColumnIndex build(ColumnFamily cf) throws IOException {
            Iterator<RangeTombstone> rangeIter = cf.deletionInfo().rangeIterator();
            RangeTombstone tombstone = rangeIter.hasNext() ? rangeIter.next() : null;
            AbstractType<?> comparator = cf.getComparator();
            for (IColumn c : cf) {
                while (tombstone != null && comparator.compare(c.name(), tombstone.min) >= 0) {
                    this.add(tombstone);
                    tombstone = rangeIter.hasNext() ? rangeIter.next() : null;
                }
                this.add(c);
            }
            while (tombstone != null) {
                this.add(tombstone);
                tombstone = rangeIter.hasNext() ? rangeIter.next() : null;
            }
            return this.build();
        }

        public ColumnIndex build(Iterable<OnDiskAtom> columns) throws IOException {
            for (OnDiskAtom c : columns) {
                this.add(c);
            }
            return this.build();
        }

        public void add(OnDiskAtom column) throws IOException {
            ++this.atomCount;
            if (column instanceof IColumn) {
                this.result.bloomFilter.add(column.name());
            }
            if (this.firstColumn == null) {
                this.firstColumn = column;
                this.startPosition = this.endPosition;
                this.endPosition += this.tombstoneTracker.writeOpenedMarker(this.firstColumn, this.output, this.atomSerializer);
                this.blockSize = 0L;
            }
            long size = column.serializedSizeForSSTable();
            this.endPosition += size;
            this.blockSize += size;
            if (this.blockSize >= (long)DatabaseDescriptor.getColumnIndexSize()) {
                IndexHelper.IndexInfo cIndexInfo = new IndexHelper.IndexInfo(this.firstColumn.name(), column.name(), this.indexOffset + this.startPosition, this.endPosition - this.startPosition);
                this.result.columnsIndex.add(cIndexInfo);
                this.firstColumn = null;
                this.lastBlockClosing = column;
            }
            if (this.output != null) {
                this.atomSerializer.serializeForSSTable(column, this.output);
            }
            this.tombstoneTracker.update(column);
            this.lastColumn = column;
        }

        public ColumnIndex build() {
            if (this.lastColumn == null) {
                return EMPTY;
            }
            if (this.result.columnsIndex.isEmpty() || this.lastBlockClosing != this.lastColumn) {
                IndexHelper.IndexInfo cIndexInfo = new IndexHelper.IndexInfo(this.firstColumn.name(), this.lastColumn.name(), this.indexOffset + this.startPosition, this.endPosition - this.startPosition);
                this.result.columnsIndex.add(cIndexInfo);
            }
            assert (this.result.columnsIndex.size() > 0);
            return this.result;
        }
    }
}

