/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.io.sstable;

import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.EOFException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.apache.cassandra.db.TypeSizes;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.io.sstable.Descriptor;
import org.apache.cassandra.io.util.FileDataInput;
import org.apache.cassandra.io.util.FileMark;
import org.apache.cassandra.io.util.FileUtils;
import org.apache.cassandra.utils.ByteBufferUtil;
import org.apache.cassandra.utils.FilterFactory;
import org.apache.cassandra.utils.IFilter;

public class IndexHelper {
    public static void skipSSTableBloomFilter(DataInput in, Descriptor.Version version) throws IOException {
        if (version.hasBloomFilterSizeInHeader) {
            int size = in.readInt();
            FileUtils.skipBytesFully(in, size);
        } else {
            IndexHelper.skipBloomFilter(in, version.filterType);
        }
    }

    public static void skipBloomFilter(DataInput in, FilterFactory.Type type) throws IOException {
        int size = in.readInt();
        switch (type) {
            case SHA: {
                FileUtils.skipBytesFully(in, size);
                break;
            }
            case MURMUR2: 
            case MURMUR3: {
                long bitLength = in.readInt() * 8;
                FileUtils.skipBytesFully(in, bitLength);
                break;
            }
            default: {
                throw new IllegalStateException("Unknown filterfactory type " + type.toString());
            }
        }
    }

    public static void skipIndex(DataInput in) throws IOException {
        int columnIndexSize = in.readInt();
        if (in instanceof FileDataInput) {
            FileUtils.skipBytesFully(in, columnIndexSize);
        } else {
            byte[] skip = new byte[columnIndexSize];
            in.readFully(skip);
        }
    }

    public static List<IndexInfo> deserializeIndex(FileDataInput in) throws IOException {
        int columnIndexSize = in.readInt();
        if (columnIndexSize == 0) {
            return Collections.emptyList();
        }
        ArrayList<IndexInfo> indexList = new ArrayList<IndexInfo>();
        FileMark mark = in.mark();
        while (in.bytesPastMark(mark) < (long)columnIndexSize) {
            indexList.add(IndexInfo.deserialize(in));
        }
        assert (in.bytesPastMark(mark) == (long)columnIndexSize);
        return indexList;
    }

    public static IFilter defreezeBloomFilter(FileDataInput file, FilterFactory.Type type) throws IOException {
        return IndexHelper.defreezeBloomFilter(file, Integer.MAX_VALUE, type);
    }

    public static IFilter defreezeBloomFilter(FileDataInput file, long maxSize, FilterFactory.Type type) throws IOException {
        int size = file.readInt();
        if ((long)size > maxSize || size <= 0) {
            throw new EOFException("bloom filter claims to be " + size + " bytes, longer than entire row size " + maxSize);
        }
        ByteBuffer bytes = file.readBytes(size);
        DataInputStream stream = new DataInputStream(ByteBufferUtil.inputStream(bytes));
        return FilterFactory.deserialize(stream, type, false);
    }

    public static int indexFor(ByteBuffer name, List<IndexInfo> indexList, AbstractType<?> comparator, boolean reversed, int lastIndex) {
        int index;
        if (name.remaining() == 0 && reversed) {
            return indexList.size() - 1;
        }
        if (lastIndex >= indexList.size()) {
            return -1;
        }
        IndexInfo target = new IndexInfo(name, name, 0L, 0L);
        int startIdx = 0;
        List<IndexInfo> toSearch = indexList;
        if (lastIndex >= 0) {
            if (reversed) {
                toSearch = indexList.subList(0, lastIndex + 1);
            } else {
                startIdx = lastIndex;
                toSearch = indexList.subList(lastIndex, indexList.size());
            }
        }
        return startIdx + ((index = Collections.binarySearch(toSearch, target, IndexHelper.getComparator(comparator, reversed))) < 0 ? -index - (reversed ? 2 : 1) : index);
    }

    public static Comparator<IndexInfo> getComparator(AbstractType<?> nameComparator, boolean reversed) {
        return reversed ? nameComparator.indexReverseComparator : nameComparator.indexComparator;
    }

    public static class IndexInfo {
        public final long width;
        public final ByteBuffer lastName;
        public final ByteBuffer firstName;
        public final long offset;

        public IndexInfo(ByteBuffer firstName, ByteBuffer lastName, long offset, long width) {
            this.firstName = firstName;
            this.lastName = lastName;
            this.offset = offset;
            this.width = width;
        }

        public void serialize(DataOutput dos) throws IOException {
            ByteBufferUtil.writeWithShortLength(this.firstName, dos);
            ByteBufferUtil.writeWithShortLength(this.lastName, dos);
            dos.writeLong(this.offset);
            dos.writeLong(this.width);
        }

        public int serializedSize(TypeSizes typeSizes) {
            int firstNameSize = this.firstName.remaining();
            int lastNameSize = this.lastName.remaining();
            return typeSizes.sizeof((short)firstNameSize) + firstNameSize + typeSizes.sizeof((short)lastNameSize) + lastNameSize + typeSizes.sizeof(this.offset) + typeSizes.sizeof(this.width);
        }

        public static IndexInfo deserialize(DataInput dis) throws IOException {
            return new IndexInfo(ByteBufferUtil.readWithShortLength(dis), ByteBufferUtil.readWithShortLength(dis), dis.readLong(), dis.readLong());
        }
    }
}

