/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.thrift;

import java.net.SocketAddress;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.cassandra.thrift.ThriftClientState;

public class ThriftSessionManager {
    public static final ThriftSessionManager instance = new ThriftSessionManager();
    private final ThreadLocal<SocketAddress> remoteSocket = new ThreadLocal();
    private final Map<SocketAddress, ThriftClientState> activeSocketSessions = new ConcurrentHashMap<SocketAddress, ThriftClientState>();

    public void setCurrentSocket(SocketAddress socket) {
        this.remoteSocket.set(socket);
    }

    public ThriftClientState currentSession() {
        SocketAddress socket = this.remoteSocket.get();
        assert (socket != null);
        ThriftClientState cState = this.activeSocketSessions.get(socket);
        if (cState == null) {
            cState = new ThriftClientState();
            this.activeSocketSessions.put(socket, cState);
        }
        return cState;
    }

    public void connectionComplete(SocketAddress socket) {
        assert (socket != null);
        this.activeSocketSessions.remove(socket);
    }
}

