/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cache;

import com.googlecode.concurrentlinkedhashmap.ConcurrentLinkedHashMap;
import com.googlecode.concurrentlinkedhashmap.EvictionListener;
import com.googlecode.concurrentlinkedhashmap.Weighers;
import java.io.DataOutputStream;
import java.io.IOError;
import java.io.IOException;
import java.util.Set;
import org.apache.cassandra.cache.FreeableMemory;
import org.apache.cassandra.cache.ICache;
import org.apache.cassandra.io.ICompactSerializer3;
import org.apache.cassandra.io.util.MemoryInputStream;
import org.apache.cassandra.io.util.MemoryOutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SerializingCache<K, V>
implements ICache<K, V> {
    private static final Logger logger = LoggerFactory.getLogger(SerializingCache.class);
    private static final int DEFAULT_CONCURENCY_LEVEL = 64;
    private final ConcurrentLinkedHashMap<K, FreeableMemory> map;
    private final ICompactSerializer3<V> serializer;

    public SerializingCache(int capacity, ICompactSerializer3<V> serializer, String tableName, String cfName) {
        this.serializer = serializer;
        EvictionListener listener = new EvictionListener<K, FreeableMemory>(){

            public void onEviction(K k, FreeableMemory mem) {
                mem.free();
            }
        };
        this.map = new ConcurrentLinkedHashMap.Builder().weigher(Weighers.singleton()).initialCapacity(capacity).maximumWeightedCapacity(capacity).concurrencyLevel(64).listener(listener).build();
    }

    private V deserialize(FreeableMemory mem) {
        try {
            return (V)this.serializer.deserialize(new MemoryInputStream(mem));
        }
        catch (IOException e) {
            logger.debug("Cannot fetch in memory data, we will failback to read from disk ", (Throwable)e);
            return null;
        }
    }

    private FreeableMemory serialize(V value) {
        FreeableMemory freeableMemory;
        long serializedSize = this.serializer.serializedSize(value);
        if (serializedSize > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Unable to allocate " + serializedSize + " bytes");
        }
        try {
            freeableMemory = new FreeableMemory(serializedSize);
        }
        catch (OutOfMemoryError e) {
            return null;
        }
        try {
            this.serializer.serialize(value, new DataOutputStream(new MemoryOutputStream(freeableMemory)));
        }
        catch (IOException e) {
            throw new IOError(e);
        }
        return freeableMemory;
    }

    @Override
    public int capacity() {
        return this.map.capacity();
    }

    @Override
    public void setCapacity(int capacity) {
        this.map.setCapacity(capacity);
    }

    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public void clear() {
        this.map.clear();
    }

    @Override
    public V get(Object key) {
        FreeableMemory mem = (FreeableMemory)((Object)this.map.get(key));
        if (mem == null) {
            return null;
        }
        return this.deserialize(mem);
    }

    @Override
    public void put(K key, V value) {
        FreeableMemory mem = this.serialize(value);
        if (mem == null) {
            return;
        }
        FreeableMemory old = (FreeableMemory)((Object)this.map.put(key, (Object)mem));
        if (old != null) {
            old.free();
        }
    }

    @Override
    public void remove(K key) {
        FreeableMemory mem = (FreeableMemory)((Object)this.map.remove(key));
        if (mem != null) {
            mem.free();
        }
    }

    @Override
    public Set<K> keySet() {
        return this.map.keySet();
    }

    @Override
    public boolean isPutCopying() {
        return true;
    }
}

