/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.cassandra.db.ReadResponse;
import org.apache.cassandra.db.Row;
import org.apache.cassandra.io.ICompactSerializer;
import org.apache.cassandra.utils.ByteBufferUtil;

class ReadResponseSerializer
implements ICompactSerializer<ReadResponse> {
    ReadResponseSerializer() {
    }

    @Override
    public void serialize(ReadResponse rm, DataOutputStream dos, int version) throws IOException {
        dos.writeInt(rm.isDigestQuery() ? rm.digest().remaining() : 0);
        ByteBuffer buffer = rm.isDigestQuery() ? rm.digest() : ByteBufferUtil.EMPTY_BYTE_BUFFER;
        ByteBufferUtil.write(buffer, dos);
        dos.writeBoolean(rm.isDigestQuery());
        if (!rm.isDigestQuery()) {
            Row.serializer().serialize(rm.row(), dos, version);
        }
    }

    @Override
    public ReadResponse deserialize(DataInputStream dis, int version) throws IOException {
        byte[] digest = null;
        int digestSize = dis.readInt();
        if (digestSize > 0) {
            digest = new byte[digestSize];
            dis.readFully(digest, 0, digestSize);
        }
        boolean isDigest = dis.readBoolean();
        assert (isDigest == digestSize > 0);
        Row row = null;
        if (!isDigest) {
            row = Row.serializer().deserialize(dis, version, true);
        }
        return isDigest ? new ReadResponse(ByteBuffer.wrap(digest)) : new ReadResponse(row);
    }
}

