/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.marshal;

import java.nio.ByteBuffer;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.db.marshal.MarshalException;
import org.apache.cassandra.utils.ByteBufferUtil;

public class BooleanType
extends AbstractType<Boolean> {
    public static final BooleanType instance = new BooleanType();

    BooleanType() {
    }

    @Override
    public Boolean compose(ByteBuffer bytes) {
        byte value = bytes.get(bytes.position());
        return value != 0;
    }

    @Override
    public ByteBuffer decompose(Boolean value) {
        return value == null ? ByteBufferUtil.EMPTY_BYTE_BUFFER : (value != false ? ByteBuffer.wrap(new byte[]{1}) : ByteBuffer.wrap(new byte[]{0}));
    }

    @Override
    public int compare(ByteBuffer o1, ByteBuffer o2) {
        if (o1 == null || o1.remaining() != 1) {
            return o2 == null || o2.remaining() != 1 ? 0 : -1;
        }
        if (o2 == null || o2.remaining() != 1) {
            return 1;
        }
        return o1.compareTo(o2);
    }

    @Override
    public String getString(ByteBuffer bytes) {
        if (bytes.remaining() == 0) {
            return Boolean.FALSE.toString();
        }
        if (bytes.remaining() != 1) {
            throw new MarshalException("A boolean is stored in exactly 1 byte: " + bytes.remaining());
        }
        byte value = bytes.get(bytes.position());
        return value == 0 ? Boolean.FALSE.toString() : Boolean.TRUE.toString();
    }

    @Override
    public String toString(Boolean b) {
        return b.toString();
    }

    @Override
    public ByteBuffer fromString(String source) throws MarshalException {
        if (source.isEmpty() || source.equalsIgnoreCase(Boolean.FALSE.toString())) {
            return this.decompose(false);
        }
        if (source.equalsIgnoreCase(Boolean.TRUE.toString())) {
            return this.decompose(true);
        }
        throw new MarshalException(String.format("unable to make boolean from '%s'", source));
    }

    @Override
    public void validate(ByteBuffer bytes) throws MarshalException {
        if (bytes.remaining() != 1 && bytes.remaining() != 0) {
            throw new MarshalException(String.format("Expected 1 or 0 byte value (%d)", bytes.remaining()));
        }
    }

    @Override
    public Class<Boolean> getType() {
        return Boolean.class;
    }

    @Override
    public boolean isSigned() {
        return false;
    }

    @Override
    public boolean isCaseSensitive() {
        return false;
    }

    @Override
    public boolean isCurrency() {
        return false;
    }

    @Override
    public int getPrecision(Boolean obj) {
        return -1;
    }

    @Override
    public int getScale(Boolean obj) {
        return -1;
    }

    @Override
    public int getJdbcType() {
        return 16;
    }

    @Override
    public boolean needsQuotes() {
        return false;
    }
}

