/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.net;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOError;
import java.io.IOException;
import java.net.Socket;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.config.EncryptionOptions;
import org.apache.cassandra.gms.Gossiper;
import org.apache.cassandra.net.Message;
import org.apache.cassandra.net.MessagingService;
import org.apache.cassandra.security.streaming.SSLIncomingStreamReader;
import org.apache.cassandra.streaming.IncomingStreamReader;
import org.apache.cassandra.streaming.StreamHeader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IncomingTcpConnection
extends Thread {
    private static Logger logger = LoggerFactory.getLogger(IncomingTcpConnection.class);
    private static final int CHUNK_SIZE = 0x100000;
    private Socket socket;

    public IncomingTcpConnection(Socket socket) {
        assert (socket != null);
        this.socket = socket;
    }

    @Override
    public void run() {
        block15: {
            int version;
            boolean isStream;
            int header;
            DataInputStream input;
            try {
                input = new DataInputStream(this.socket.getInputStream());
                MessagingService.validateMagic(input.readInt());
                header = input.readInt();
                boolean bl = isStream = MessagingService.getBits(header, 3, 1) == 1;
                if (!isStream) {
                    input = new DataInputStream(new BufferedInputStream(this.socket.getInputStream(), 4096));
                }
                version = MessagingService.getBits(header, 15, 8);
                Gossiper.instance.setVersion(this.socket.getInetAddress(), version);
            }
            catch (IOException e) {
                this.close();
                throw new IOError(e);
            }
            try {
                int size;
                block14: {
                    while (true) {
                        if (isStream) {
                            if (version > 2) {
                                logger.error("Received untranslated stream from newer protcol version. Terminating connection!");
                                this.close();
                                return;
                            }
                            break block14;
                        }
                        size = input.readInt();
                        byte[] contentBytes = new byte[size];
                        int remainder = size % 0x100000;
                        for (int offset = 0; offset < size - remainder; offset += 0x100000) {
                            input.readFully(contentBytes, offset, 0x100000);
                        }
                        input.readFully(contentBytes, size - remainder, remainder);
                        if (version > 2) {
                            logger.info("Received connection from newer protocol version. Ignorning message.");
                        } else {
                            DataInputStream dis = new DataInputStream(new ByteArrayInputStream(contentBytes));
                            String id = dis.readUTF();
                            Message message = Message.serializer().deserialize(dis, version);
                            MessagingService.instance().receive(message, id);
                        }
                        MessagingService.validateMagic(input.readInt());
                        header = input.readInt();
                        version = MessagingService.getBits(header, 15, 8);
                        assert (isStream == (MessagingService.getBits(header, 3, 1) == 1)) : "Connections cannot change type: " + isStream;
                        assert (version == MessagingService.getBits(header, 15, 8)) : "Protocol version shouldn't change during a session";
                    }
                }
                size = input.readInt();
                byte[] headerBytes = new byte[size];
                input.readFully(headerBytes);
                this.stream(StreamHeader.serializer().deserialize(new DataInputStream(new ByteArrayInputStream(headerBytes)), version), input);
            }
            catch (EOFException e) {
                if (logger.isTraceEnabled()) {
                    logger.trace("eof reading from socket; closing", (Throwable)e);
                }
            }
            catch (IOException e) {
                if (!logger.isDebugEnabled()) break block15;
                logger.debug("error reading from socket; closing", (Throwable)e);
            }
        }
        this.close();
    }

    private void close() {
        block2: {
            try {
                this.socket.close();
            }
            catch (IOException e) {
                if (!logger.isDebugEnabled()) break block2;
                logger.debug("error closing socket", (Throwable)e);
            }
        }
    }

    private void stream(StreamHeader streamHeader, DataInputStream input) throws IOException {
        if (DatabaseDescriptor.getEncryptionOptions().internode_encryption == EncryptionOptions.InternodeEncryption.all) {
            new SSLIncomingStreamReader(streamHeader, this.socket, input).read();
        } else {
            new IncomingStreamReader(streamHeader, this.socket).read();
        }
    }
}

