/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cql3.statements;

import java.nio.ByteBuffer;
import java.util.List;
import org.apache.cassandra.cql3.CQLStatement;
import org.apache.cassandra.cql3.statements.ParsedStatement;
import org.apache.cassandra.db.ConsistencyLevel;
import org.apache.cassandra.exceptions.InvalidRequestException;
import org.apache.cassandra.exceptions.UnauthorizedException;
import org.apache.cassandra.service.ClientState;
import org.apache.cassandra.service.QueryState;
import org.apache.cassandra.transport.messages.ResultMessage;

public class UseStatement
extends ParsedStatement
implements CQLStatement {
    private final String keyspace;

    public UseStatement(String keyspace) {
        this.keyspace = keyspace;
    }

    @Override
    public ParsedStatement.Prepared prepare() throws InvalidRequestException {
        return new ParsedStatement.Prepared(this);
    }

    @Override
    public void checkAccess(ClientState state) throws UnauthorizedException {
        state.validateLogin();
    }

    @Override
    public void validate(ClientState state) throws InvalidRequestException {
    }

    @Override
    public ResultMessage execute(ConsistencyLevel cl, QueryState state, List<ByteBuffer> variables) throws InvalidRequestException {
        state.getClientState().setKeyspace(this.keyspace);
        return new ResultMessage.SetKeyspace(this.keyspace);
    }

    @Override
    public ResultMessage executeInternal(QueryState state) {
        throw new UnsupportedOperationException();
    }
}

