/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db;

import java.util.Arrays;
import java.util.Iterator;
import org.apache.cassandra.db.ColumnFamily;
import org.apache.cassandra.db.ColumnFamilyStore;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.IColumn;
import org.apache.cassandra.db.filter.ColumnSlice;
import org.apache.cassandra.db.filter.QueryFilter;
import org.apache.cassandra.db.filter.QueryPath;
import org.apache.cassandra.db.filter.SliceQueryFilter;

public class SliceQueryPager
implements Iterator<ColumnFamily> {
    public static final int DEFAULT_PAGE_SIZE = 10000;
    public final ColumnFamilyStore cfs;
    public final DecoratedKey key;
    private ColumnSlice[] slices;
    private boolean exhausted;

    public SliceQueryPager(ColumnFamilyStore cfs, DecoratedKey key, ColumnSlice[] slices) {
        this.cfs = cfs;
        this.key = key;
        this.slices = slices;
    }

    @Override
    public boolean hasNext() {
        return !this.exhausted;
    }

    @Override
    public ColumnFamily next() {
        SliceQueryFilter sliceFilter;
        if (this.exhausted) {
            return null;
        }
        QueryPath path = new QueryPath(this.cfs.getColumnFamilyName());
        QueryFilter filter = new QueryFilter(this.key, path, sliceFilter = new SliceQueryFilter(this.slices, false, 10000));
        ColumnFamily cf = this.cfs.getColumnFamily(filter);
        if (cf == null || sliceFilter.getLiveCount(cf) < 10000) {
            this.exhausted = true;
        } else {
            int i;
            Iterator<IColumn> iter = cf.getReverseSortedColumns().iterator();
            IColumn lastColumn = iter.next();
            while (lastColumn.isMarkedForDelete()) {
                lastColumn = iter.next();
            }
            for (i = 0; i < this.slices.length; ++i) {
                ColumnSlice current = this.slices[i];
                if (this.cfs.getComparator().compare(lastColumn.name(), current.finish) <= 0) break;
            }
            if (i >= this.slices.length) {
                this.exhausted = true;
            } else {
                this.slices = Arrays.copyOfRange(this.slices, i, this.slices.length);
            }
        }
        return cf == null ? ColumnFamily.create(this.cfs.metadata) : cf;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

