/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.security.MessageDigest;
import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.db.Column;
import org.apache.cassandra.db.ColumnFamilyStore;
import org.apache.cassandra.db.IColumn;
import org.apache.cassandra.db.marshal.MarshalException;
import org.apache.cassandra.io.util.DataOutputBuffer;
import org.apache.cassandra.utils.Allocator;
import org.apache.cassandra.utils.ByteBufferUtil;
import org.apache.cassandra.utils.HeapAllocator;

public class DeletedColumn
extends Column {
    public DeletedColumn(ByteBuffer name, int localDeletionTime, long timestamp) {
        this(name, ByteBufferUtil.bytes(localDeletionTime), timestamp);
    }

    public DeletedColumn(ByteBuffer name, ByteBuffer value, long timestamp) {
        super(name, value, timestamp);
    }

    @Override
    public boolean isMarkedForDelete() {
        return true;
    }

    @Override
    public long getMarkedForDeleteAt() {
        return this.timestamp;
    }

    @Override
    public void updateDigest(MessageDigest digest) {
        digest.update(this.name.duplicate());
        DataOutputBuffer buffer = new DataOutputBuffer();
        try {
            buffer.writeLong(this.timestamp);
            buffer.writeByte(this.serializationFlags());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        digest.update(buffer.getData(), 0, buffer.getLength());
    }

    @Override
    public int getLocalDeletionTime() {
        return this.value.getInt(this.value.position());
    }

    @Override
    public IColumn reconcile(IColumn column, Allocator allocator) {
        if (column instanceof DeletedColumn) {
            return super.reconcile(column, allocator);
        }
        return column.reconcile(this, allocator);
    }

    @Override
    public IColumn localCopy(ColumnFamilyStore cfs) {
        return new DeletedColumn(cfs.internOrCopy(this.name, HeapAllocator.instance), ByteBufferUtil.clone(this.value), this.timestamp);
    }

    @Override
    public IColumn localCopy(ColumnFamilyStore cfs, Allocator allocator) {
        return new DeletedColumn(cfs.internOrCopy(this.name, allocator), allocator.clone(this.value), this.timestamp);
    }

    @Override
    public int serializationFlags() {
        return 1;
    }

    @Override
    public void validateFields(CFMetaData metadata) throws MarshalException {
        this.validateName(metadata);
        if (this.value().remaining() != 4) {
            throw new MarshalException("A tombstone value should be 4 bytes long");
        }
        if (this.getLocalDeletionTime() < 0) {
            throw new MarshalException("The local deletion time should not be negative");
        }
    }

    public static DeletedColumn create(int localDeletionTime, long timestamp, String ... names) {
        return new DeletedColumn(DeletedColumn.decomposeName(names), localDeletionTime, timestamp);
    }
}

