/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db;

import java.io.DataInputStream;
import java.io.IOException;
import java.net.InetAddress;
import org.apache.cassandra.db.RowMutation;
import org.apache.cassandra.db.WriteResponse;
import org.apache.cassandra.io.util.FastByteArrayInputStream;
import org.apache.cassandra.net.CompactEndpointSerializationHelper;
import org.apache.cassandra.net.IVerbHandler;
import org.apache.cassandra.net.MessageIn;
import org.apache.cassandra.net.MessageOut;
import org.apache.cassandra.net.MessagingService;
import org.apache.cassandra.tracing.Tracing;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RowMutationVerbHandler
implements IVerbHandler<RowMutation> {
    private static final Logger logger = LoggerFactory.getLogger(RowMutationVerbHandler.class);

    @Override
    public void doVerb(MessageIn<RowMutation> message, String id) {
        try {
            InetAddress replyTo;
            RowMutation rm = (RowMutation)message.payload;
            byte[] from = message.parameters.get("FWD_FRM");
            if (from == null) {
                replyTo = message.from;
                byte[] forwardBytes = message.parameters.get("FWD_TO");
                if (forwardBytes != null && message.version >= 4) {
                    this.forwardToLocalNodes(rm, message.verb, forwardBytes, message.from);
                }
            } else {
                replyTo = InetAddress.getByAddress(from);
            }
            rm.apply();
            WriteResponse response = new WriteResponse();
            Tracing.trace("Enqueuing response to {}", replyTo);
            MessagingService.instance().sendReply(response.createMessage(), id, replyTo);
        }
        catch (IOException e) {
            logger.error("Error in row mutation", (Throwable)e);
        }
    }

    private void forwardToLocalNodes(RowMutation rm, MessagingService.Verb verb, byte[] forwardBytes, InetAddress from) throws IOException {
        DataInputStream dis = new DataInputStream(new FastByteArrayInputStream(forwardBytes));
        int size = dis.readInt();
        MessageOut<RowMutation> message = new MessageOut<RowMutation>(verb, rm, RowMutation.serializer).withParameter("FWD_FRM", from.getAddress());
        for (int i = 0; i < size; ++i) {
            InetAddress address = CompactEndpointSerializationHelper.deserialize(dis);
            String id = dis.readUTF();
            Tracing.trace("Enqueuing forwarded write to {}", address);
            MessagingService.instance().sendOneWay(message, id, address);
        }
    }
}

