/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.io.sstable;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.io.sstable.KeyIterator;
import org.apache.cassandra.io.sstable.SSTableReader;
import org.apache.cassandra.utils.CloseableIterator;
import org.apache.cassandra.utils.IMergeIterator;
import org.apache.cassandra.utils.MergeIterator;

public class ReducingKeyIterator
implements CloseableIterator<DecoratedKey> {
    private final IMergeIterator<DecoratedKey, DecoratedKey> mi;

    public ReducingKeyIterator(Collection<SSTableReader> sstables) {
        ArrayList<KeyIterator> iters = new ArrayList<KeyIterator>(sstables.size());
        for (SSTableReader sstable : sstables) {
            iters.add(new KeyIterator(sstable.descriptor));
        }
        this.mi = MergeIterator.get(iters, DecoratedKey.comparator, new MergeIterator.Reducer<DecoratedKey, DecoratedKey>(){
            DecoratedKey reduced = null;

            @Override
            public boolean trivialReduceIsTrivial() {
                return true;
            }

            @Override
            public void reduce(DecoratedKey current) {
                this.reduced = current;
            }

            @Override
            protected DecoratedKey getReduced() {
                return this.reduced;
            }
        });
    }

    @Override
    public void close() throws IOException {
        for (CloseableIterator<DecoratedKey> o : this.mi.iterators()) {
            o.close();
        }
    }

    public long getTotalBytes() {
        long m = 0L;
        for (CloseableIterator<DecoratedKey> o : this.mi.iterators()) {
            m += ((KeyIterator)o).getTotalBytes();
        }
        return m;
    }

    public long getBytesRead() {
        long m = 0L;
        for (CloseableIterator<DecoratedKey> o : this.mi.iterators()) {
            m += ((KeyIterator)o).getBytesRead();
        }
        return m;
    }

    public String getTaskType() {
        return "Secondary index build";
    }

    @Override
    public boolean hasNext() {
        return this.mi.hasNext();
    }

    @Override
    public DecoratedKey next() {
        return (DecoratedKey)this.mi.next();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

