/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cql3;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterators;
import com.google.common.collect.UnmodifiableIterator;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.cql3.CFDefinition;
import org.apache.cassandra.cql3.ColumnNameBuilder;
import org.apache.cassandra.cql3.Lists;
import org.apache.cassandra.cql3.Maps;
import org.apache.cassandra.cql3.Sets;
import org.apache.cassandra.cql3.Term;
import org.apache.cassandra.cql3.VariableSpecifications;
import org.apache.cassandra.db.Column;
import org.apache.cassandra.db.ColumnFamily;
import org.apache.cassandra.db.filter.ColumnSlice;
import org.apache.cassandra.db.marshal.CollectionType;
import org.apache.cassandra.db.marshal.CompositeType;
import org.apache.cassandra.db.marshal.CounterColumnType;
import org.apache.cassandra.exceptions.InvalidRequestException;

public class ColumnCondition {
    public final CFDefinition.Name column;
    private final Term value;
    private List<ByteBuffer> variables;

    private ColumnCondition(CFDefinition.Name column, Term value) {
        this.column = column;
        this.value = value;
    }

    public static ColumnCondition equal(CFDefinition.Name column, Term value) {
        return new ColumnCondition(column, value);
    }

    public ColumnCondition attach(List<ByteBuffer> variables) {
        this.variables = variables;
        return this;
    }

    public void collectMarkerSpecification(VariableSpecifications boundNames) {
        this.value.collectMarkerSpecification(boundNames);
    }

    public boolean equalsTo(ColumnCondition other) throws InvalidRequestException {
        return this.column.equals(other.column) && this.value.bindAndGet(this.variables).equals(other.value.bindAndGet(other.variables));
    }

    private ColumnNameBuilder copyOrUpdatePrefix(CFMetaData cfm, ColumnNameBuilder rowPrefix) {
        return this.column.kind == CFDefinition.Name.Kind.STATIC ? cfm.getStaticColumnNameBuilder() : rowPrefix.copy();
    }

    public boolean appliesTo(ColumnNameBuilder rowPrefix, ColumnFamily current, long now) throws InvalidRequestException {
        if (this.column.type instanceof CollectionType) {
            return this.collectionAppliesTo((CollectionType)this.column.type, rowPrefix, current, now);
        }
        ColumnNameBuilder prefix = this.copyOrUpdatePrefix(current.metadata(), rowPrefix);
        ByteBuffer columnName = this.column.kind == CFDefinition.Name.Kind.VALUE_ALIAS ? prefix.build() : prefix.add(this.column.name.key).build();
        Column c = current.getColumn(columnName);
        ByteBuffer v = this.value.bindAndGet(this.variables);
        return v == null ? c == null || !c.isLive(now) : c != null && c.isLive(now) && c.value().equals(v);
    }

    private boolean collectionAppliesTo(CollectionType type, ColumnNameBuilder rowPrefix, ColumnFamily current, final long now) throws InvalidRequestException {
        ColumnNameBuilder collectionPrefix = this.copyOrUpdatePrefix(current.metadata(), rowPrefix).add(this.column.name.key);
        ColumnSlice[] collectionSlice = new ColumnSlice[]{new ColumnSlice(collectionPrefix.build(), collectionPrefix.buildAsEndOfRange())};
        UnmodifiableIterator iter = Iterators.filter(current.iterator(collectionSlice), (Predicate)new Predicate<Column>(){

            public boolean apply(Column c) {
                return c.isLive(now);
            }
        });
        Term.Terminal v = this.value.bind(this.variables);
        if (v == null) {
            return !iter.hasNext();
        }
        switch (type.kind) {
            case LIST: {
                return this.listAppliesTo(current.metadata(), (Iterator<Column>)iter, ((Lists.Value)v).elements);
            }
            case SET: {
                return this.setAppliesTo(current.metadata(), (Iterator<Column>)iter, ((Sets.Value)v).elements);
            }
            case MAP: {
                return this.mapAppliesTo(current.metadata(), (Iterator<Column>)iter, ((Maps.Value)v).map);
            }
        }
        throw new AssertionError();
    }

    private static ByteBuffer collectionKey(CFMetaData cfm, Column c) {
        ByteBuffer[] bbs = ((CompositeType)cfm.comparator).split(c.name());
        return bbs[bbs.length - 1];
    }

    private boolean listAppliesTo(CFMetaData cfm, Iterator<Column> iter, List<ByteBuffer> elements) {
        for (ByteBuffer e : elements) {
            if (iter.hasNext() && !iter.next().value().equals(e)) continue;
            return false;
        }
        return !iter.hasNext();
    }

    private boolean setAppliesTo(CFMetaData cfm, Iterator<Column> iter, Set<ByteBuffer> elements) {
        HashSet<ByteBuffer> remaining = new HashSet<ByteBuffer>(elements);
        while (iter.hasNext()) {
            if (remaining.isEmpty()) {
                return false;
            }
            if (remaining.remove(ColumnCondition.collectionKey(cfm, iter.next()))) continue;
            return false;
        }
        return remaining.isEmpty();
    }

    private boolean mapAppliesTo(CFMetaData cfm, Iterator<Column> iter, Map<ByteBuffer, ByteBuffer> elements) {
        HashMap<ByteBuffer, ByteBuffer> remaining = new HashMap<ByteBuffer, ByteBuffer>(elements);
        while (iter.hasNext()) {
            if (remaining.isEmpty()) {
                return false;
            }
            Column c = iter.next();
            if (((ByteBuffer)remaining.remove(ColumnCondition.collectionKey(cfm, c))).equals(c.value())) continue;
            return false;
        }
        return remaining.isEmpty();
    }

    public static class Raw {
        private final Term.Raw value;

        public Raw(Term.Raw value) {
            this.value = value;
        }

        public ColumnCondition prepare(CFDefinition.Name receiver) throws InvalidRequestException {
            if (receiver.type instanceof CounterColumnType) {
                throw new InvalidRequestException("Condtions on counters are not supported");
            }
            return ColumnCondition.equal(receiver, this.value.prepare(receiver));
        }
    }
}

