/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.config;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.nio.charset.CharacterCodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.config.KSMetaData;
import org.apache.cassandra.db.ColumnFamilyStore;
import org.apache.cassandra.db.ColumnFamilyType;
import org.apache.cassandra.db.Keyspace;
import org.apache.cassandra.db.Row;
import org.apache.cassandra.db.SystemKeyspace;
import org.apache.cassandra.db.index.SecondaryIndexManager;
import org.apache.cassandra.io.sstable.Descriptor;
import org.apache.cassandra.service.MigrationManager;
import org.apache.cassandra.utils.ByteBufferUtil;
import org.apache.cassandra.utils.ConcurrentBiMap;
import org.apache.cassandra.utils.Pair;
import org.cliffc.high_scale_lib.NonBlockingHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Schema {
    private static final Logger logger = LoggerFactory.getLogger(Schema.class);
    public static final Schema instance = new Schema();
    public static final int NAME_LENGTH = 48;
    private final Map<String, KSMetaData> keyspaces = new NonBlockingHashMap();
    private final Map<String, Keyspace> keyspaceInstances = new NonBlockingHashMap();
    private final ConcurrentBiMap<Pair<String, String>, UUID> cfIdMap = new ConcurrentBiMap();
    private volatile UUID version;
    public static final UUID emptyVersion;
    public static final ImmutableSet<String> systemKeyspaceNames;

    public Schema load(Collection<KSMetaData> keyspaceDefs) {
        for (KSMetaData def : keyspaceDefs) {
            this.load(def);
        }
        return this;
    }

    public Schema load(KSMetaData keyspaceDef) {
        for (CFMetaData cfm : keyspaceDef.cfMetaData().values()) {
            this.load(cfm);
        }
        this.setKeyspaceDefinition(keyspaceDef);
        return this;
    }

    public Keyspace getKeyspaceInstance(String keyspaceName) {
        return this.keyspaceInstances.get(keyspaceName);
    }

    public ColumnFamilyStore getColumnFamilyStoreInstance(UUID cfId) {
        Pair<String, String> pair = this.cfIdMap.inverse().get(cfId);
        if (pair == null) {
            return null;
        }
        Keyspace instance = this.getKeyspaceInstance((String)pair.left);
        if (instance == null) {
            return null;
        }
        return instance.getColumnFamilyStore(cfId);
    }

    public void storeKeyspaceInstance(Keyspace keyspace) {
        if (this.keyspaceInstances.containsKey(keyspace.getName())) {
            throw new IllegalArgumentException(String.format("Keyspace %s was already initialized.", keyspace.getName()));
        }
        this.keyspaceInstances.put(keyspace.getName(), keyspace);
    }

    public Keyspace removeKeyspaceInstance(String keyspaceName) {
        return this.keyspaceInstances.remove(keyspaceName);
    }

    public void clearKeyspaceDefinition(KSMetaData ksm) {
        this.keyspaces.remove(ksm.name);
    }

    public CFMetaData getCFMetaData(String keyspaceName, String cfName) {
        assert (keyspaceName != null);
        KSMetaData ksm = this.keyspaces.get(keyspaceName);
        return ksm == null ? null : ksm.cfMetaData().get(cfName);
    }

    public CFMetaData getCFMetaData(UUID cfId) {
        Pair<String, String> cf = this.getCF(cfId);
        return cf == null ? null : this.getCFMetaData((String)cf.left, (String)cf.right);
    }

    public CFMetaData getCFMetaData(Descriptor descriptor) {
        return this.getCFMetaData(descriptor.ksname, descriptor.cfname);
    }

    public ColumnFamilyType getColumnFamilyType(String ksName, String cfName) {
        assert (ksName != null && cfName != null);
        CFMetaData cfMetaData = this.getCFMetaData(ksName, cfName);
        return cfMetaData == null ? null : cfMetaData.cfType;
    }

    public KSMetaData getKSMetaData(String keyspaceName) {
        assert (keyspaceName != null);
        return this.keyspaces.get(keyspaceName);
    }

    public List<String> getNonSystemKeyspaces() {
        return ImmutableList.copyOf((Collection)Sets.difference(this.keyspaces.keySet(), systemKeyspaceNames));
    }

    public Map<String, CFMetaData> getKeyspaceMetaData(String keyspaceName) {
        assert (keyspaceName != null);
        KSMetaData ksm = this.keyspaces.get(keyspaceName);
        assert (ksm != null);
        return ksm.cfMetaData();
    }

    public Set<String> getKeyspaces() {
        return this.keyspaces.keySet();
    }

    public Collection<KSMetaData> getKeyspaceDefinitions() {
        return this.keyspaces.values();
    }

    public void setKeyspaceDefinition(KSMetaData ksm) {
        assert (ksm != null);
        this.keyspaces.put(ksm.name, ksm);
    }

    public Pair<String, String> getCF(UUID cfId) {
        return this.cfIdMap.inverse().get(cfId);
    }

    public boolean hasCF(UUID cfId) {
        return this.cfIdMap.containsValue(cfId);
    }

    public UUID getId(String ksName, String cfName) {
        return this.cfIdMap.get(Pair.create(ksName, cfName));
    }

    public void load(CFMetaData cfm) {
        Pair<String, String> key = Pair.create(cfm.ksName, cfm.cfName);
        if (this.cfIdMap.containsKey(key)) {
            throw new RuntimeException(String.format("Attempting to load already loaded table %s.%s", cfm.ksName, cfm.cfName));
        }
        logger.debug("Adding {} to cfIdMap", (Object)cfm);
        this.cfIdMap.put(key, cfm.cfId);
    }

    public void purge(CFMetaData cfm) {
        this.cfIdMap.remove(Pair.create(cfm.ksName, cfm.cfName));
        cfm.markPurged();
    }

    public UUID getVersion() {
        return this.version;
    }

    public void updateVersion() {
        try {
            MessageDigest versionDigest = MessageDigest.getInstance("MD5");
            for (Row row : SystemKeyspace.serializedSchema()) {
                if (Schema.invalidSchemaRow(row) || Schema.ignoredSchemaRow(row)) continue;
                ColumnFamilyStore.removeDeletedColumnsOnly(row.cf, Integer.MAX_VALUE, SecondaryIndexManager.nullUpdater);
                row.cf.purgeTombstones(Integer.MAX_VALUE);
                row.cf.updateDigest(versionDigest);
            }
            this.version = UUID.nameUUIDFromBytes(versionDigest.digest());
            SystemKeyspace.updateSchemaVersion(this.version);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void updateVersionAndAnnounce() {
        this.updateVersion();
        MigrationManager.passiveAnnounce(this.version);
    }

    public synchronized void clear() {
        for (String keyspaceName : this.getNonSystemKeyspaces()) {
            KSMetaData ksm = this.getKSMetaData(keyspaceName);
            for (CFMetaData cfm : ksm.cfMetaData().values()) {
                this.purge(cfm);
            }
            this.clearKeyspaceDefinition(ksm);
        }
        this.updateVersionAndAnnounce();
    }

    public static boolean invalidSchemaRow(Row row) {
        return row.cf == null || row.cf.isMarkedForDelete() && !row.cf.hasColumns();
    }

    public static boolean ignoredSchemaRow(Row row) {
        try {
            return systemKeyspaceNames.contains((Object)ByteBufferUtil.string(row.key.getKey()));
        }
        catch (CharacterCodingException e) {
            throw new RuntimeException(e);
        }
    }

    static {
        systemKeyspaceNames = ImmutableSet.of((Object)"system");
        try {
            emptyVersion = UUID.nameUUIDFromBytes(MessageDigest.getInstance("MD5").digest());
        }
        catch (NoSuchAlgorithmException e) {
            throw new AssertionError();
        }
    }
}

