/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cql3;

import com.google.common.base.Objects;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterators;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.cassandra.config.ColumnDefinition;
import org.apache.cassandra.cql3.AbstractMarker;
import org.apache.cassandra.cql3.ColumnSpecification;
import org.apache.cassandra.cql3.Lists;
import org.apache.cassandra.cql3.Maps;
import org.apache.cassandra.cql3.QueryOptions;
import org.apache.cassandra.cql3.Relation;
import org.apache.cassandra.cql3.Sets;
import org.apache.cassandra.cql3.Term;
import org.apache.cassandra.cql3.VariableSpecifications;
import org.apache.cassandra.db.Cell;
import org.apache.cassandra.db.ColumnFamily;
import org.apache.cassandra.db.composites.CellName;
import org.apache.cassandra.db.composites.CellNameType;
import org.apache.cassandra.db.composites.Composite;
import org.apache.cassandra.db.filter.ColumnSlice;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.db.marshal.CollectionType;
import org.apache.cassandra.db.marshal.CounterColumnType;
import org.apache.cassandra.db.marshal.ListType;
import org.apache.cassandra.db.marshal.MapType;
import org.apache.cassandra.db.marshal.SetType;
import org.apache.cassandra.exceptions.InvalidRequestException;
import org.apache.cassandra.utils.ByteBufferUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ColumnCondition {
    private static final Logger logger = LoggerFactory.getLogger(ColumnCondition.class);
    public final ColumnDefinition column;
    private final Term collectionElement;
    private final Term value;
    private final List<Term> inValues;
    public final Relation.Type operator;

    private ColumnCondition(ColumnDefinition column, Term collectionElement, Term value, List<Term> inValues, Relation.Type op) {
        this.column = column;
        this.collectionElement = collectionElement;
        this.value = value;
        this.inValues = inValues;
        this.operator = op;
        if (!this.operator.equals((Object)Relation.Type.IN)) assert (this.inValues == null);
    }

    public static ColumnCondition condition(ColumnDefinition column, Term value, Relation.Type op) {
        return new ColumnCondition(column, null, value, null, op);
    }

    public static ColumnCondition condition(ColumnDefinition column, Term collectionElement, Term value, Relation.Type op) {
        return new ColumnCondition(column, collectionElement, value, null, op);
    }

    public static ColumnCondition inCondition(ColumnDefinition column, List<Term> inValues) {
        return new ColumnCondition(column, null, null, inValues, Relation.Type.IN);
    }

    public static ColumnCondition inCondition(ColumnDefinition column, Term collectionElement, List<Term> inValues) {
        return new ColumnCondition(column, collectionElement, null, inValues, Relation.Type.IN);
    }

    public static ColumnCondition inCondition(ColumnDefinition column, Term inMarker) {
        return new ColumnCondition(column, null, inMarker, null, Relation.Type.IN);
    }

    public static ColumnCondition inCondition(ColumnDefinition column, Term collectionElement, Term inMarker) {
        return new ColumnCondition(column, collectionElement, inMarker, null, Relation.Type.IN);
    }

    public void collectMarkerSpecification(VariableSpecifications boundNames) {
        if (this.collectionElement != null) {
            this.collectionElement.collectMarkerSpecification(boundNames);
        }
        if (this.operator.equals((Object)Relation.Type.IN) && this.inValues != null) {
            for (Term value : this.inValues) {
                value.collectMarkerSpecification(boundNames);
            }
        } else {
            this.value.collectMarkerSpecification(boundNames);
        }
    }

    public Bound bind(QueryOptions options) throws InvalidRequestException {
        boolean isInCondition = this.operator.equals((Object)Relation.Type.IN);
        if (this.column.type instanceof CollectionType) {
            if (this.collectionElement == null) {
                return isInCondition ? new CollectionInBound(this, options) : new CollectionBound(this, options);
            }
            return isInCondition ? new ElementAccessInBound(this, options) : new ElementAccessBound(this, options);
        }
        return isInCondition ? new SimpleInBound(this, options) : new SimpleBound(this, options);
    }

    public static class Raw {
        private final Term.Raw value;
        private final List<Term.Raw> inValues;
        private final AbstractMarker.INRaw inMarker;
        private final Term.Raw collectionElement;
        private final Relation.Type operator;

        private Raw(Term.Raw value, List<Term.Raw> inValues, AbstractMarker.INRaw inMarker, Term.Raw collectionElement, Relation.Type op) {
            this.value = value;
            this.inValues = inValues;
            this.inMarker = inMarker;
            this.collectionElement = collectionElement;
            this.operator = op;
        }

        public static Raw simpleCondition(Term.Raw value, Relation.Type op) {
            return new Raw(value, null, null, null, op);
        }

        public static Raw simpleInCondition(List<Term.Raw> inValues) {
            return new Raw(null, inValues, null, null, Relation.Type.IN);
        }

        public static Raw simpleInCondition(AbstractMarker.INRaw inMarker) {
            return new Raw(null, null, inMarker, null, Relation.Type.IN);
        }

        public static Raw collectionCondition(Term.Raw value, Term.Raw collectionElement, Relation.Type op) {
            return new Raw(value, null, null, collectionElement, op);
        }

        public static Raw collectionInCondition(Term.Raw collectionElement, List<Term.Raw> inValues) {
            return new Raw(null, inValues, null, collectionElement, Relation.Type.IN);
        }

        public static Raw collectionInCondition(Term.Raw collectionElement, AbstractMarker.INRaw inMarker) {
            return new Raw(null, null, inMarker, collectionElement, Relation.Type.IN);
        }

        public ColumnCondition prepare(String keyspace, ColumnDefinition receiver) throws InvalidRequestException {
            ColumnSpecification valueSpec;
            ColumnSpecification elementSpec;
            if (receiver.type instanceof CounterColumnType) {
                throw new InvalidRequestException("Conditions on counters are not supported");
            }
            if (this.collectionElement == null) {
                if (this.operator.equals((Object)Relation.Type.IN)) {
                    if (this.inValues == null) {
                        return ColumnCondition.inCondition(receiver, this.inMarker.prepare(keyspace, receiver));
                    }
                    ArrayList<Term> terms = new ArrayList<Term>(this.inValues.size());
                    for (Term.Raw value : this.inValues) {
                        terms.add(value.prepare(keyspace, receiver));
                    }
                    return ColumnCondition.inCondition(receiver, terms);
                }
                return ColumnCondition.condition(receiver, this.value.prepare(keyspace, receiver), this.operator);
            }
            if (!receiver.type.isCollection()) {
                throw new InvalidRequestException(String.format("Invalid element access syntax for non-collection column %s", receiver.name));
            }
            switch (((CollectionType)receiver.type).kind) {
                case LIST: {
                    elementSpec = Lists.indexSpecOf(receiver);
                    valueSpec = Lists.valueSpecOf(receiver);
                    break;
                }
                case MAP: {
                    elementSpec = Maps.keySpecOf(receiver);
                    valueSpec = Maps.valueSpecOf(receiver);
                    break;
                }
                case SET: {
                    throw new InvalidRequestException(String.format("Invalid element access syntax for set column %s", receiver.name));
                }
                default: {
                    throw new AssertionError();
                }
            }
            if (this.operator.equals((Object)Relation.Type.IN)) {
                if (this.inValues == null) {
                    return ColumnCondition.inCondition(receiver, this.collectionElement.prepare(keyspace, elementSpec), this.inMarker.prepare(keyspace, valueSpec));
                }
                ArrayList<Term> terms = new ArrayList<Term>(this.inValues.size());
                for (Term.Raw value : this.inValues) {
                    terms.add(value.prepare(keyspace, valueSpec));
                }
                return ColumnCondition.inCondition(receiver, this.collectionElement.prepare(keyspace, elementSpec), terms);
            }
            return ColumnCondition.condition(receiver, this.collectionElement.prepare(keyspace, elementSpec), this.value.prepare(keyspace, valueSpec), this.operator);
        }
    }

    public static class CollectionInBound
    extends Bound {
        public final List<Term.Terminal> inValues;

        private CollectionInBound(ColumnCondition condition, QueryOptions options) throws InvalidRequestException {
            block11: {
                block9: {
                    Lists.Marker inValuesMarker;
                    CollectionType collectionType;
                    block12: {
                        block10: {
                            super(condition.column, condition.operator);
                            assert (this.column.type instanceof CollectionType && condition.collectionElement == null);
                            assert (condition.operator.equals((Object)Relation.Type.IN));
                            this.inValues = new ArrayList<Term.Terminal>();
                            if (condition.inValues != null) break block9;
                            collectionType = (CollectionType)this.column.type;
                            inValuesMarker = (Lists.Marker)condition.value;
                            if (!(this.column.type instanceof ListType)) break block10;
                            ListType<?> deserializer = ListType.getInstance(collectionType.valueComparator());
                            for (ByteBuffer buffer : inValuesMarker.bind((QueryOptions)options).elements) {
                                if (buffer == null) {
                                    this.inValues.add(null);
                                    continue;
                                }
                                this.inValues.add(Lists.Value.fromSerialized(buffer, deserializer, options.getProtocolVersion()));
                            }
                            break block11;
                        }
                        if (!(this.column.type instanceof MapType)) break block12;
                        MapType<?, ?> deserializer = MapType.getInstance(collectionType.nameComparator(), collectionType.valueComparator());
                        for (ByteBuffer buffer : inValuesMarker.bind((QueryOptions)options).elements) {
                            if (buffer == null) {
                                this.inValues.add(null);
                                continue;
                            }
                            this.inValues.add(Maps.Value.fromSerialized(buffer, deserializer, options.getProtocolVersion()));
                        }
                        break block11;
                    }
                    if (!(this.column.type instanceof SetType)) break block11;
                    SetType<?> deserializer = SetType.getInstance(collectionType.valueComparator());
                    for (ByteBuffer buffer : inValuesMarker.bind((QueryOptions)options).elements) {
                        if (buffer == null) {
                            this.inValues.add(null);
                            continue;
                        }
                        this.inValues.add(Sets.Value.fromSerialized(buffer, deserializer, options.getProtocolVersion()));
                    }
                    break block11;
                }
                for (Term value : condition.inValues) {
                    this.inValues.add(value.bind(options));
                }
            }
        }

        @Override
        public boolean appliesTo(Composite rowPrefix, ColumnFamily current, long now) throws InvalidRequestException {
            CollectionType type = (CollectionType)this.column.type;
            CellName name = current.metadata().comparator.create(rowPrefix, this.column);
            ArrayList cells = com.google.common.collect.Lists.newArrayList(this.collectionColumns(name, current, now));
            for (Term.Terminal value : this.inValues) {
                if (!CollectionBound.valueAppliesTo(type, cells.iterator(), value, Relation.Type.EQ)) continue;
                return true;
            }
            return false;
        }

        public int hashCode() {
            ArrayList<Collection<ByteBuffer>> inValueBuffers = new ArrayList<Collection<ByteBuffer>>(this.inValues.size());
            switch (((CollectionType)this.column.type).kind) {
                case LIST: {
                    for (Term.Terminal term : this.inValues) {
                        inValueBuffers.add(term == null ? null : ((Lists.Value)term).elements);
                    }
                    break;
                }
                case SET: {
                    for (Term.Terminal term : this.inValues) {
                        inValueBuffers.add(term == null ? null : ((Sets.Value)term).elements);
                    }
                    break;
                }
                case MAP: {
                    for (Term.Terminal term : this.inValues) {
                        if (term != null) {
                            inValueBuffers.add(((Maps.Value)term).map.keySet());
                            inValueBuffers.add(((Maps.Value)term).map.values());
                            continue;
                        }
                        inValueBuffers.add(null);
                    }
                    break;
                }
            }
            return Objects.hashCode((Object[])new Object[]{this.column, inValueBuffers, this.operator});
        }
    }

    static class CollectionBound
    extends Bound {
        public final Term.Terminal value;

        private CollectionBound(ColumnCondition condition, QueryOptions options) throws InvalidRequestException {
            super(condition.column, condition.operator);
            assert (this.column.type instanceof CollectionType && condition.collectionElement == null);
            assert (!condition.operator.equals((Object)Relation.Type.IN));
            this.value = condition.value.bind(options);
        }

        @Override
        public boolean appliesTo(Composite rowPrefix, ColumnFamily current, long now) throws InvalidRequestException {
            CollectionType type = (CollectionType)this.column.type;
            Iterator<Cell> iter = this.collectionColumns(current.metadata().comparator.create(rowPrefix, this.column), current, now);
            if (this.value == null) {
                if (this.operator.equals((Object)Relation.Type.EQ)) {
                    return !iter.hasNext();
                }
                if (this.operator.equals((Object)Relation.Type.NEQ)) {
                    return iter.hasNext();
                }
                throw new InvalidRequestException(String.format("Invalid comparison with null for operator \"%s\"", new Object[]{this.operator}));
            }
            return CollectionBound.valueAppliesTo(type, iter, this.value, this.operator);
        }

        static boolean valueAppliesTo(CollectionType type, Iterator<Cell> iter, Term.Terminal value, Relation.Type operator) {
            if (value == null) {
                return !iter.hasNext();
            }
            switch (type.kind) {
                case LIST: {
                    return CollectionBound.listAppliesTo((ListType)type, iter, ((Lists.Value)value).elements, operator);
                }
                case SET: {
                    return CollectionBound.setAppliesTo((SetType)type, iter, ((Sets.Value)value).elements, operator);
                }
                case MAP: {
                    return CollectionBound.mapAppliesTo((MapType)type, iter, ((Maps.Value)value).map, operator);
                }
            }
            throw new AssertionError();
        }

        private static boolean setOrListAppliesTo(AbstractType<?> type, Iterator<Cell> iter, Iterator<ByteBuffer> conditionIter, Relation.Type operator, boolean isSet) {
            while (iter.hasNext()) {
                if (!conditionIter.hasNext()) {
                    return operator.equals((Object)Relation.Type.GT) || operator.equals((Object)Relation.Type.GTE) || operator.equals((Object)Relation.Type.NEQ);
                }
                ByteBuffer cellValue = isSet ? iter.next().name().collectionElement() : iter.next().value();
                int comparison = type.compare(cellValue, conditionIter.next());
                if (comparison == 0) continue;
                return CollectionBound.evaluateComparisonWithOperator(comparison, operator);
            }
            if (conditionIter.hasNext()) {
                return operator.equals((Object)Relation.Type.LT) || operator.equals((Object)Relation.Type.LTE) || operator.equals((Object)Relation.Type.NEQ);
            }
            return operator == Relation.Type.EQ || operator == Relation.Type.LTE || operator == Relation.Type.GTE;
        }

        private static boolean evaluateComparisonWithOperator(int comparison, Relation.Type operator) {
            switch (operator) {
                case EQ: {
                    return false;
                }
                case LT: 
                case LTE: {
                    return comparison < 0;
                }
                case GT: 
                case GTE: {
                    return comparison > 0;
                }
                case NEQ: {
                    return true;
                }
            }
            throw new AssertionError();
        }

        static boolean listAppliesTo(ListType type, Iterator<Cell> iter, List<ByteBuffer> elements, Relation.Type operator) {
            return CollectionBound.setOrListAppliesTo(type.elements, iter, elements.iterator(), operator, false);
        }

        static boolean setAppliesTo(SetType type, Iterator<Cell> iter, Set<ByteBuffer> elements, Relation.Type operator) {
            ArrayList<ByteBuffer> sortedElements = new ArrayList<ByteBuffer>(elements.size());
            sortedElements.addAll(elements);
            Collections.sort(sortedElements, type.elements);
            return CollectionBound.setOrListAppliesTo(type.elements, iter, sortedElements.iterator(), operator, true);
        }

        static boolean mapAppliesTo(MapType type, Iterator<Cell> iter, Map<ByteBuffer, ByteBuffer> elements, Relation.Type operator) {
            Iterator<Map.Entry<ByteBuffer, ByteBuffer>> conditionIter = elements.entrySet().iterator();
            while (iter.hasNext()) {
                if (!conditionIter.hasNext()) {
                    return operator.equals((Object)Relation.Type.GT) || operator.equals((Object)Relation.Type.GTE) || operator.equals((Object)Relation.Type.NEQ);
                }
                Map.Entry<ByteBuffer, ByteBuffer> conditionEntry = conditionIter.next();
                Cell c = iter.next();
                int comparison = type.keys.compare(c.name().collectionElement(), conditionEntry.getKey());
                if (comparison != 0) {
                    return CollectionBound.evaluateComparisonWithOperator(comparison, operator);
                }
                comparison = type.values.compare(c.value(), conditionEntry.getValue());
                if (comparison == 0) continue;
                return CollectionBound.evaluateComparisonWithOperator(comparison, operator);
            }
            if (conditionIter.hasNext()) {
                return operator.equals((Object)Relation.Type.LT) || operator.equals((Object)Relation.Type.LTE) || operator.equals((Object)Relation.Type.NEQ);
            }
            return operator == Relation.Type.EQ || operator == Relation.Type.LTE || operator == Relation.Type.GTE;
        }

        public int hashCode() {
            Integer val = null;
            if (this.value != null) {
                switch (((CollectionType)this.column.type).kind) {
                    case LIST: {
                        val = ((Lists.Value)this.value).elements.hashCode();
                        break;
                    }
                    case SET: {
                        val = ((Sets.Value)this.value).elements.hashCode();
                        break;
                    }
                    case MAP: {
                        val = ((Maps.Value)this.value).map.hashCode();
                    }
                }
            }
            return Objects.hashCode((Object[])new Object[]{this.column, val});
        }
    }

    static class ElementAccessInBound
    extends Bound {
        public final ByteBuffer collectionElement;
        public final List<ByteBuffer> inValues;

        private ElementAccessInBound(ColumnCondition condition, QueryOptions options) throws InvalidRequestException {
            super(condition.column, condition.operator);
            assert (this.column.type instanceof CollectionType && condition.collectionElement != null);
            this.collectionElement = condition.collectionElement.bindAndGet(options);
            if (condition.inValues == null) {
                this.inValues = ((Lists.Marker)condition.value).bind(options).getElements();
            } else {
                this.inValues = new ArrayList<ByteBuffer>(condition.inValues.size());
                for (Term value : condition.inValues) {
                    this.inValues.add(value.bindAndGet(options));
                }
            }
        }

        @Override
        public boolean appliesTo(Composite rowPrefix, ColumnFamily current, long now) throws InvalidRequestException {
            if (this.collectionElement == null) {
                throw new InvalidRequestException("Invalid null value for " + (this.column.type instanceof MapType ? "map" : "list") + " element access");
            }
            CellNameType nameType = current.metadata().comparator;
            if (this.column.type instanceof MapType) {
                CellName name = nameType.create(rowPrefix, this.column, this.collectionElement);
                Cell item = current.getColumn(name);
                AbstractType valueType = ((MapType)this.column.type).values;
                for (ByteBuffer value : this.inValues) {
                    if (!this.isSatisfiedByValue(value, item, valueType, Relation.Type.EQ, now)) continue;
                    return true;
                }
                return false;
            }
            assert (this.column.type instanceof ListType);
            ByteBuffer columnValue = ElementAccessBound.getListItem(this.collectionColumns(nameType.create(rowPrefix, this.column), current, now), ElementAccessBound.getListIndex(this.collectionElement));
            AbstractType valueType = ((ListType)this.column.type).elements;
            for (ByteBuffer value : this.inValues) {
                if (!this.compareWithOperator(Relation.Type.EQ, valueType, value, columnValue)) continue;
                return true;
            }
            return false;
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.column, this.collectionElement, this.inValues, this.operator});
        }
    }

    static class ElementAccessBound
    extends Bound {
        public final ByteBuffer collectionElement;
        public final ByteBuffer value;

        private ElementAccessBound(ColumnCondition condition, QueryOptions options) throws InvalidRequestException {
            super(condition.column, condition.operator);
            assert (this.column.type instanceof CollectionType && condition.collectionElement != null);
            assert (!condition.operator.equals((Object)Relation.Type.IN));
            this.collectionElement = condition.collectionElement.bindAndGet(options);
            this.value = condition.value.bindAndGet(options);
        }

        @Override
        public boolean appliesTo(Composite rowPrefix, ColumnFamily current, long now) throws InvalidRequestException {
            if (this.collectionElement == null) {
                throw new InvalidRequestException("Invalid null value for " + (this.column.type instanceof MapType ? "map" : "list") + " element access");
            }
            if (this.column.type instanceof MapType) {
                Cell cell = current.getColumn(current.metadata().comparator.create(rowPrefix, this.column, this.collectionElement));
                return this.isSatisfiedByValue(this.value, cell, ((MapType)this.column.type).values, this.operator, now);
            }
            assert (this.column.type instanceof ListType);
            ByteBuffer columnValue = ElementAccessBound.getListItem(this.collectionColumns(current.metadata().comparator.create(rowPrefix, this.column), current, now), ElementAccessBound.getListIndex(this.collectionElement));
            return this.compareWithOperator(this.operator, ((ListType)this.column.type).elements, this.value, columnValue);
        }

        static int getListIndex(ByteBuffer collectionElement) throws InvalidRequestException {
            int idx = ByteBufferUtil.toInt(collectionElement);
            if (idx < 0) {
                throw new InvalidRequestException(String.format("Invalid negative list index %d", idx));
            }
            return idx;
        }

        static ByteBuffer getListItem(Iterator<Cell> iter, int index) {
            int adv = Iterators.advance(iter, (int)index);
            if (adv == index && iter.hasNext()) {
                return iter.next().value();
            }
            return null;
        }

        @Override
        public ByteBuffer getCollectionElementValue() {
            return this.collectionElement;
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.column, this.collectionElement, this.value, this.operator});
        }
    }

    static class SimpleInBound
    extends Bound {
        public final List<ByteBuffer> inValues;

        private SimpleInBound(ColumnCondition condition, QueryOptions options) throws InvalidRequestException {
            super(condition.column, condition.operator);
            assert (!(this.column.type instanceof CollectionType) && condition.collectionElement == null);
            assert (condition.operator.equals((Object)Relation.Type.IN));
            if (condition.inValues == null) {
                this.inValues = ((Lists.Marker)condition.value).bind(options).getElements();
            } else {
                this.inValues = new ArrayList<ByteBuffer>(condition.inValues.size());
                for (Term value : condition.inValues) {
                    this.inValues.add(value.bindAndGet(options));
                }
            }
        }

        @Override
        public boolean appliesTo(Composite rowPrefix, ColumnFamily current, long now) throws InvalidRequestException {
            CellName name = current.metadata().comparator.create(rowPrefix, this.column);
            for (ByteBuffer value : this.inValues) {
                if (!this.isSatisfiedByValue(value, current.getColumn(name), this.column.type, Relation.Type.EQ, now)) continue;
                return true;
            }
            return false;
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.column, this.inValues, this.operator});
        }
    }

    static class SimpleBound
    extends Bound {
        public final ByteBuffer value;

        private SimpleBound(ColumnCondition condition, QueryOptions options) throws InvalidRequestException {
            super(condition.column, condition.operator);
            assert (!(this.column.type instanceof CollectionType) && condition.collectionElement == null);
            assert (!condition.operator.equals((Object)Relation.Type.IN));
            this.value = condition.value.bindAndGet(options);
        }

        @Override
        public boolean appliesTo(Composite rowPrefix, ColumnFamily current, long now) throws InvalidRequestException {
            CellName name = current.metadata().comparator.create(rowPrefix, this.column);
            return this.isSatisfiedByValue(this.value, current.getColumn(name), this.column.type, this.operator, now);
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.column, this.value, this.operator});
        }
    }

    public static abstract class Bound {
        public final ColumnDefinition column;
        public final Relation.Type operator;

        protected Bound(ColumnDefinition column, Relation.Type operator) {
            this.column = column;
            this.operator = operator;
        }

        public abstract boolean appliesTo(Composite var1, ColumnFamily var2, long var3) throws InvalidRequestException;

        public ByteBuffer getCollectionElementValue() {
            return null;
        }

        protected boolean isSatisfiedByValue(ByteBuffer value, Cell c, AbstractType<?> type, Relation.Type operator, long now) throws InvalidRequestException {
            ByteBuffer columnValue = c == null || !c.isLive(now) ? null : c.value();
            return this.compareWithOperator(operator, type, value, columnValue);
        }

        protected boolean compareWithOperator(Relation.Type operator, AbstractType<?> type, ByteBuffer value, ByteBuffer otherValue) throws InvalidRequestException {
            if (value == null) {
                switch (operator) {
                    case EQ: {
                        return otherValue == null;
                    }
                    case NEQ: {
                        return otherValue != null;
                    }
                }
                throw new InvalidRequestException(String.format("Invalid comparison with null for operator \"%s\"", new Object[]{operator}));
            }
            if (otherValue == null) {
                return operator.equals((Object)Relation.Type.NEQ);
            }
            int comparison = type.compare(otherValue, value);
            switch (operator) {
                case EQ: {
                    return comparison == 0;
                }
                case LT: {
                    return comparison < 0;
                }
                case LTE: {
                    return comparison <= 0;
                }
                case GT: {
                    return comparison > 0;
                }
                case GTE: {
                    return comparison >= 0;
                }
                case NEQ: {
                    return comparison != 0;
                }
            }
            throw new AssertionError();
        }

        protected Iterator<Cell> collectionColumns(CellName collection, ColumnFamily cf, final long now) {
            ColumnSlice[] collectionSlice = new ColumnSlice[]{collection.slice()};
            return Iterators.filter(cf.iterator(collectionSlice), (Predicate)new Predicate<Cell>(){

                public boolean apply(Cell c) {
                    return c.isLive(now);
                }
            });
        }
    }
}

