/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cql3;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.cassandra.config.ColumnDefinition;
import org.apache.cassandra.cql3.AbstractMarker;
import org.apache.cassandra.cql3.AssignmentTestable;
import org.apache.cassandra.cql3.ColumnIdentifier;
import org.apache.cassandra.cql3.ColumnSpecification;
import org.apache.cassandra.cql3.Constants;
import org.apache.cassandra.cql3.Operation;
import org.apache.cassandra.cql3.QueryOptions;
import org.apache.cassandra.cql3.Term;
import org.apache.cassandra.cql3.UpdateParameters;
import org.apache.cassandra.cql3.VariableSpecifications;
import org.apache.cassandra.db.ColumnFamily;
import org.apache.cassandra.db.composites.CellName;
import org.apache.cassandra.db.composites.Composite;
import org.apache.cassandra.db.marshal.MapType;
import org.apache.cassandra.exceptions.InvalidRequestException;
import org.apache.cassandra.serializers.CollectionSerializer;
import org.apache.cassandra.serializers.MapSerializer;
import org.apache.cassandra.serializers.MarshalException;
import org.apache.cassandra.utils.Pair;

public abstract class Maps {
    private Maps() {
    }

    public static ColumnSpecification keySpecOf(ColumnSpecification column) {
        return new ColumnSpecification(column.ksName, column.cfName, new ColumnIdentifier("key(" + column.name + ")", true), ((MapType)column.type).keys);
    }

    public static ColumnSpecification valueSpecOf(ColumnSpecification column) {
        return new ColumnSpecification(column.ksName, column.cfName, new ColumnIdentifier("value(" + column.name + ")", true), ((MapType)column.type).values);
    }

    public static class DiscarderByKey
    extends Operation {
        public DiscarderByKey(ColumnDefinition column, Term k) {
            super(column, k);
        }

        @Override
        public void execute(ByteBuffer rowKey, ColumnFamily cf, Composite prefix, UpdateParameters params) throws InvalidRequestException {
            Term.Terminal key = this.t.bind(params.options);
            if (key == null) {
                throw new InvalidRequestException("Invalid null map key");
            }
            assert (key instanceof Constants.Value);
            CellName cellName = cf.getComparator().create(prefix, this.column, ((Constants.Value)key).bytes);
            cf.addColumn(params.makeTombstone(cellName));
        }
    }

    public static class Putter
    extends Operation {
        public Putter(ColumnDefinition column, Term t) {
            super(column, t);
        }

        @Override
        public void execute(ByteBuffer rowKey, ColumnFamily cf, Composite prefix, UpdateParameters params) throws InvalidRequestException {
            Putter.doPut(this.t, cf, prefix, this.column, params);
        }

        static void doPut(Term t, ColumnFamily cf, Composite prefix, ColumnDefinition column, UpdateParameters params) throws InvalidRequestException {
            Term.Terminal value = t.bind(params.options);
            if (value == null) {
                return;
            }
            assert (value instanceof Value);
            Map<ByteBuffer, ByteBuffer> toAdd = ((Value)value).map;
            for (Map.Entry<ByteBuffer, ByteBuffer> entry : toAdd.entrySet()) {
                CellName cellName = cf.getComparator().create(prefix, column, entry.getKey());
                cf.addColumn(params.makeColumn(cellName, entry.getValue()));
            }
        }
    }

    public static class SetterByKey
    extends Operation {
        private final Term k;

        public SetterByKey(ColumnDefinition column, Term k, Term t) {
            super(column, t);
            this.k = k;
        }

        @Override
        public void collectMarkerSpecification(VariableSpecifications boundNames) {
            super.collectMarkerSpecification(boundNames);
            this.k.collectMarkerSpecification(boundNames);
        }

        @Override
        public void execute(ByteBuffer rowKey, ColumnFamily cf, Composite prefix, UpdateParameters params) throws InvalidRequestException {
            ByteBuffer key = this.k.bindAndGet(params.options);
            ByteBuffer value = this.t.bindAndGet(params.options);
            if (key == null) {
                throw new InvalidRequestException("Invalid null map key");
            }
            CellName cellName = cf.getComparator().create(prefix, this.column, key);
            if (value == null) {
                cf.addColumn(params.makeTombstone(cellName));
            } else {
                if (value.remaining() > 65535) {
                    throw new InvalidRequestException(String.format("Map value is too long. Map values are limited to %d bytes but %d bytes value provided", 65535, value.remaining()));
                }
                cf.addColumn(params.makeColumn(cellName, value));
            }
        }
    }

    public static class Setter
    extends Operation {
        public Setter(ColumnDefinition column, Term t) {
            super(column, t);
        }

        @Override
        public void execute(ByteBuffer rowKey, ColumnFamily cf, Composite prefix, UpdateParameters params) throws InvalidRequestException {
            CellName name = cf.getComparator().create(prefix, this.column);
            cf.addAtom(params.makeTombstoneForOverwrite(name.slice()));
            Putter.doPut(this.t, cf, prefix, this.column, params);
        }
    }

    public static class Marker
    extends AbstractMarker {
        protected Marker(int bindIndex, ColumnSpecification receiver) {
            super(bindIndex, receiver);
            assert (receiver.type instanceof MapType);
        }

        @Override
        public Value bind(QueryOptions options) throws InvalidRequestException {
            ByteBuffer value = options.getValues().get(this.bindIndex);
            return value == null ? null : Value.fromSerialized(value, (MapType)this.receiver.type, options.getProtocolVersion());
        }
    }

    public static class DelayedValue
    extends Term.NonTerminal {
        private final Comparator<ByteBuffer> comparator;
        private final Map<Term, Term> elements;

        public DelayedValue(Comparator<ByteBuffer> comparator, Map<Term, Term> elements) {
            this.comparator = comparator;
            this.elements = elements;
        }

        @Override
        public boolean containsBindMarker() {
            return false;
        }

        @Override
        public void collectMarkerSpecification(VariableSpecifications boundNames) {
        }

        @Override
        public Value bind(QueryOptions options) throws InvalidRequestException {
            TreeMap<ByteBuffer, ByteBuffer> buffers = new TreeMap<ByteBuffer, ByteBuffer>(this.comparator);
            for (Map.Entry<Term, Term> entry : this.elements.entrySet()) {
                ByteBuffer keyBytes = entry.getKey().bindAndGet(options);
                if (keyBytes == null) {
                    throw new InvalidRequestException("null is not supported inside collections");
                }
                if (keyBytes.remaining() > 65535) {
                    throw new InvalidRequestException(String.format("Map key is too long. Map keys are limited to %d bytes but %d bytes keys provided", 65535, keyBytes.remaining()));
                }
                ByteBuffer valueBytes = entry.getValue().bindAndGet(options);
                if (valueBytes == null) {
                    throw new InvalidRequestException("null is not supported inside collections");
                }
                if (valueBytes.remaining() > 65535) {
                    throw new InvalidRequestException(String.format("Map value is too long. Map values are limited to %d bytes but %d bytes value provided", 65535, valueBytes.remaining()));
                }
                buffers.put(keyBytes, valueBytes);
            }
            return new Value(buffers);
        }
    }

    public static class Value
    extends Term.Terminal {
        public final Map<ByteBuffer, ByteBuffer> map;

        public Value(Map<ByteBuffer, ByteBuffer> map) {
            this.map = map;
        }

        public static Value fromSerialized(ByteBuffer value, MapType type, int version) throws InvalidRequestException {
            try {
                Object m = ((MapSerializer)type.getSerializer()).deserializeForNativeProtocol(value, version);
                LinkedHashMap<ByteBuffer, ByteBuffer> map = new LinkedHashMap<ByteBuffer, ByteBuffer>(m.size());
                for (Map.Entry entry : m.entrySet()) {
                    map.put(type.keys.decompose(entry.getKey()), type.values.decompose(entry.getValue()));
                }
                return new Value(map);
            }
            catch (MarshalException e) {
                throw new InvalidRequestException(e.getMessage());
            }
        }

        @Override
        public ByteBuffer get(QueryOptions options) {
            ArrayList<ByteBuffer> buffers = new ArrayList<ByteBuffer>(2 * this.map.size());
            for (Map.Entry<ByteBuffer, ByteBuffer> entry : this.map.entrySet()) {
                buffers.add(entry.getKey());
                buffers.add(entry.getValue());
            }
            return CollectionSerializer.pack(buffers, this.map.size(), options.getProtocolVersion());
        }

        public boolean equals(MapType mt, Value v) {
            if (this.map.size() != v.map.size()) {
                return false;
            }
            Iterator<Map.Entry<ByteBuffer, ByteBuffer>> thisIter = this.map.entrySet().iterator();
            Iterator<Map.Entry<ByteBuffer, ByteBuffer>> thatIter = v.map.entrySet().iterator();
            while (thisIter.hasNext()) {
                Map.Entry<ByteBuffer, ByteBuffer> thisEntry = thisIter.next();
                Map.Entry<ByteBuffer, ByteBuffer> thatEntry = thatIter.next();
                if (mt.keys.compare(thisEntry.getKey(), thatEntry.getKey()) == 0 && mt.values.compare(thisEntry.getValue(), thatEntry.getValue()) == 0) continue;
                return false;
            }
            return true;
        }
    }

    public static class Literal
    implements Term.Raw {
        public final List<Pair<Term.Raw, Term.Raw>> entries;

        public Literal(List<Pair<Term.Raw, Term.Raw>> entries) {
            this.entries = entries;
        }

        @Override
        public Term prepare(String keyspace, ColumnSpecification receiver) throws InvalidRequestException {
            this.validateAssignableTo(keyspace, receiver);
            ColumnSpecification keySpec = Maps.keySpecOf(receiver);
            ColumnSpecification valueSpec = Maps.valueSpecOf(receiver);
            HashMap<Term, Term> values = new HashMap<Term, Term>(this.entries.size());
            boolean allTerminal = true;
            for (Pair<Term.Raw, Term.Raw> entry : this.entries) {
                Term k = ((Term.Raw)entry.left).prepare(keyspace, keySpec);
                Term v = ((Term.Raw)entry.right).prepare(keyspace, valueSpec);
                if (k.containsBindMarker() || v.containsBindMarker()) {
                    throw new InvalidRequestException(String.format("Invalid map literal for %s: bind variables are not supported inside collection literals", receiver.name));
                }
                if (k instanceof Term.NonTerminal || v instanceof Term.NonTerminal) {
                    allTerminal = false;
                }
                values.put(k, v);
            }
            DelayedValue value = new DelayedValue(((MapType)receiver.type).keys, values);
            return allTerminal ? value.bind(QueryOptions.DEFAULT) : value;
        }

        private void validateAssignableTo(String keyspace, ColumnSpecification receiver) throws InvalidRequestException {
            if (!(receiver.type instanceof MapType)) {
                throw new InvalidRequestException(String.format("Invalid map literal for %s of type %s", receiver.name, receiver.type.asCQL3Type()));
            }
            ColumnSpecification keySpec = Maps.keySpecOf(receiver);
            ColumnSpecification valueSpec = Maps.valueSpecOf(receiver);
            for (Pair<Term.Raw, Term.Raw> entry : this.entries) {
                if (!((Term.Raw)entry.left).testAssignment(keyspace, keySpec).isAssignable()) {
                    throw new InvalidRequestException(String.format("Invalid map literal for %s: key %s is not of type %s", receiver.name, entry.left, keySpec.type.asCQL3Type()));
                }
                if (((Term.Raw)entry.right).testAssignment(keyspace, valueSpec).isAssignable()) continue;
                throw new InvalidRequestException(String.format("Invalid map literal for %s: value %s is not of type %s", receiver.name, entry.right, valueSpec.type.asCQL3Type()));
            }
        }

        @Override
        public AssignmentTestable.TestResult testAssignment(String keyspace, ColumnSpecification receiver) {
            if (!(receiver.type instanceof MapType)) {
                return AssignmentTestable.TestResult.NOT_ASSIGNABLE;
            }
            if (this.entries.isEmpty()) {
                return AssignmentTestable.TestResult.WEAKLY_ASSIGNABLE;
            }
            ColumnSpecification keySpec = Maps.keySpecOf(receiver);
            ColumnSpecification valueSpec = Maps.valueSpecOf(receiver);
            AssignmentTestable.TestResult res = AssignmentTestable.TestResult.EXACT_MATCH;
            for (Pair<Term.Raw, Term.Raw> entry : this.entries) {
                AssignmentTestable.TestResult t1 = ((Term.Raw)entry.left).testAssignment(keyspace, keySpec);
                AssignmentTestable.TestResult t2 = ((Term.Raw)entry.right).testAssignment(keyspace, valueSpec);
                if (t1 == AssignmentTestable.TestResult.NOT_ASSIGNABLE || t2 == AssignmentTestable.TestResult.NOT_ASSIGNABLE) {
                    return AssignmentTestable.TestResult.NOT_ASSIGNABLE;
                }
                if (t1 == AssignmentTestable.TestResult.EXACT_MATCH && t2 == AssignmentTestable.TestResult.EXACT_MATCH) continue;
                res = AssignmentTestable.TestResult.WEAKLY_ASSIGNABLE;
            }
            return res;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("{");
            for (int i = 0; i < this.entries.size(); ++i) {
                if (i > 0) {
                    sb.append(", ");
                }
                sb.append(this.entries.get((int)i).left).append(":").append(this.entries.get((int)i).right);
            }
            sb.append("}");
            return sb.toString();
        }
    }
}

