/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cql3.selection;

import java.nio.ByteBuffer;
import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.cql3.ColumnIdentifier;
import org.apache.cassandra.cql3.ColumnSpecification;
import org.apache.cassandra.cql3.selection.Selection;
import org.apache.cassandra.cql3.selection.Selector;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.db.marshal.UTF8Type;
import org.apache.cassandra.db.marshal.UserType;
import org.apache.cassandra.exceptions.InvalidRequestException;

final class FieldSelector
extends Selector {
    private final UserType type;
    private final int field;
    private final Selector selected;

    public static Selector.Factory newFactory(final UserType type, final int field, final Selector.Factory factory) {
        return new Selector.Factory(){

            @Override
            public ColumnSpecification getColumnSpecification(CFMetaData cfm) {
                ColumnIdentifier identifier = new ColumnIdentifier(String.format("%s.%s", factory.getColumnSpecification((CFMetaData)cfm).name, UTF8Type.instance.getString(type.fieldName(field))), true);
                return new ColumnSpecification(cfm.ksName, cfm.cfName, identifier, type.fieldType(field));
            }

            @Override
            public Selector newInstance() {
                return new FieldSelector(type, field, factory.newInstance());
            }

            @Override
            public boolean isAggregateSelectorFactory() {
                return factory.isAggregateSelectorFactory();
            }
        };
    }

    @Override
    public boolean isAggregate() {
        return false;
    }

    @Override
    public void addInput(Selection.ResultSetBuilder rs) throws InvalidRequestException {
        this.selected.addInput(rs);
    }

    @Override
    public ByteBuffer getOutput() throws InvalidRequestException {
        ByteBuffer value = this.selected.getOutput();
        if (value == null) {
            return null;
        }
        ByteBuffer[] buffers = this.type.split(value);
        return this.field < buffers.length ? buffers[this.field] : null;
    }

    @Override
    public AbstractType<?> getType() {
        return this.type.fieldType(this.field);
    }

    @Override
    public void reset() {
        this.selected.reset();
    }

    public String toString() {
        return String.format("%s.%s", this.selected, UTF8Type.instance.getString(this.type.fieldName(this.field)));
    }

    private FieldSelector(UserType type, int field, Selector selected) {
        this.type = type;
        this.field = field;
        this.selected = selected;
    }
}

